/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.getfilesrowcount;

import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.getfilesrowcount.GetFilesRowsCountData;
import org.apache.hop.pipeline.transforms.getfilesrowcount.GetFilesRowsCountMeta;

public class GetFilesRowsCount
extends BaseTransform<GetFilesRowsCountMeta, GetFilesRowsCountData> {
    private static final Class<?> PKG = GetFilesRowsCountMeta.class;

    public GetFilesRowsCount(TransformMeta transformMeta, GetFilesRowsCountMeta meta, GetFilesRowsCountData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private boolean getOneRow() throws HopException {
        if (!this.openNextFile()) {
            return true;
        }
        try {
            Object[] outputRow;
            if (((GetFilesRowsCountMeta)this.meta).isFileFromField()) {
                outputRow = this.getInputRowMeta().cloneRow(((GetFilesRowsCountData)this.data).inputRow);
                outputRow = RowDataUtil.resizeArray((Object[])outputRow, (int)((GetFilesRowsCountData)this.data).outputRowMeta.size());
            } else {
                outputRow = RowDataUtil.allocateRowData((int)((GetFilesRowsCountData)this.data).outputRowMeta.size());
            }
            if (((GetFilesRowsCountMeta)this.meta).isSmartCount() && ((GetFilesRowsCountData)this.data).foundData) {
                ++((GetFilesRowsCountData)this.data).rowNumber;
            }
            outputRow[((GetFilesRowsCountData)this.data).totalPreviousFields] = ((GetFilesRowsCountData)this.data).rowNumber;
            if (((GetFilesRowsCountMeta)this.meta).isIncludeFilesCount()) {
                outputRow[((GetFilesRowsCountData)this.data).totalPreviousFields + 1] = ((GetFilesRowsCountData)this.data).fileNumber;
            }
            if (((GetFilesRowsCountMeta)this.meta).isFileFromField() || ((GetFilesRowsCountData)this.data).lastFile) {
                this.putRow(((GetFilesRowsCountData)this.data).outputRowMeta, outputRow);
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.TotalRowsFiles", (String[])new String[0]), new Object[]{((GetFilesRowsCountData)this.data).rowNumber, ((GetFilesRowsCountData)this.data).fileNumber});
                }
            }
            this.incrementLinesInput();
        }
        catch (Exception e) {
            throw new HopException("Unable to read row from file", (Throwable)e);
        }
        return false;
    }

    public boolean processRow() throws HopException {
        boolean done = this.getOneRow();
        if (done) {
            this.setOutputDone();
            return false;
        }
        return true;
    }

    private void getRowNumber() throws HopException {
        try {
            if (((GetFilesRowsCountData)this.data).file.getType() == FileType.FILE) {
                try (InputStream inputStream = HopVfs.getInputStream((FileObject)((GetFilesRowsCountData)this.data).file);){
                    int n;
                    byte[] buf = new byte[8192];
                    boolean prevCR = false;
                    while ((n = inputStream.read(buf)) != -1) {
                        for (int i = 0; i < n; ++i) {
                            ((GetFilesRowsCountData)this.data).foundData = true;
                            if (((GetFilesRowsCountMeta)this.meta).getRowSeparatorFormat() == GetFilesRowsCountMeta.SeparatorFormat.CRLF) {
                                if (buf[i] == 13 || buf[i] == 10) {
                                    if (buf[i] == 13) {
                                        prevCR = true;
                                        continue;
                                    }
                                    if (buf[i] != 10 || !prevCR) continue;
                                    ++((GetFilesRowsCountData)this.data).rowNumber;
                                    ((GetFilesRowsCountData)this.data).foundData = false;
                                    prevCR = false;
                                    continue;
                                }
                                prevCR = false;
                                continue;
                            }
                            if (buf[i] != ((GetFilesRowsCountData)this.data).separator) continue;
                            ++((GetFilesRowsCountData)this.data).rowNumber;
                            ((GetFilesRowsCountData)this.data).foundData = false;
                        }
                    }
                }
                catch (Exception ex) {
                    throw new HopException((Throwable)ex);
                }
            }
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.RowsInFile", (String[])new String[]{((GetFilesRowsCountData)this.data).file.toString(), "" + ((GetFilesRowsCountData)this.data).rowNumber}));
            }
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    private boolean openNextFile() {
        if (((GetFilesRowsCountData)this.data).lastFile) {
            return false;
        }
        try {
            if (!((GetFilesRowsCountMeta)this.meta).isFileFromField()) {
                if (this.getNextFilenameFromField()) {
                    return false;
                }
            } else {
                ((GetFilesRowsCountData)this.data).inputRow = this.getRow();
                if (((GetFilesRowsCountData)this.data).inputRow == null) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.FinishedProcessing", (String[])new String[0]));
                    }
                    return false;
                }
                if (this.first) {
                    this.first = false;
                    ((GetFilesRowsCountData)this.data).inputRowMeta = this.getInputRowMeta();
                    ((GetFilesRowsCountData)this.data).outputRowMeta = ((GetFilesRowsCountData)this.data).inputRowMeta.clone();
                    ((GetFilesRowsCountMeta)this.meta).getFields(((GetFilesRowsCountData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                    ((GetFilesRowsCountData)this.data).totalPreviousFields = ((GetFilesRowsCountData)this.data).inputRowMeta.size();
                    if (Utils.isEmpty((CharSequence)((GetFilesRowsCountMeta)this.meta).getOutputFilenameField())) {
                        this.logError(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.NoField", (String[])new String[0]));
                        throw new HopException(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.NoField", (String[])new String[0]));
                    }
                    if (((GetFilesRowsCountData)this.data).indexOfFilenameField < 0) {
                        ((GetFilesRowsCountData)this.data).indexOfFilenameField = this.getInputRowMeta().indexOfValue(((GetFilesRowsCountMeta)this.meta).getOutputFilenameField());
                        if (((GetFilesRowsCountData)this.data).indexOfFilenameField < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.ErrorFindingField", (String[])new String[]{((GetFilesRowsCountMeta)this.meta).getOutputFilenameField()}));
                            throw new HopException(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Exception.CouldnotFindField", (String[])new String[]{((GetFilesRowsCountMeta)this.meta).getOutputFilenameField()}));
                        }
                    }
                }
                String filename = this.getInputRowMeta().getString(((GetFilesRowsCountData)this.data).inputRow, ((GetFilesRowsCountData)this.data).indexOfFilenameField);
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.FilenameInStream", (String[])new String[]{((GetFilesRowsCountMeta)this.meta).getOutputFilenameField(), filename}));
                }
                ((GetFilesRowsCountData)this.data).file = HopVfs.getFileObject((String)filename, (IVariables)this.variables);
                if (((GetFilesRowsCountMeta)this.meta).isFileFromField()) {
                    ((GetFilesRowsCountData)this.data).rowNumber = 0L;
                }
            }
            ++((GetFilesRowsCountData)this.data).fileNumber;
            if (((GetFilesRowsCountMeta)this.meta).isAddResultFilename()) {
                ResultFile resultFile = new ResultFile(0, ((GetFilesRowsCountData)this.data).file, this.getPipelineMeta().getName(), this.getTransformName());
                resultFile.setComment(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.FileAddedResult", (String[])new String[0]));
                this.addResultFile(resultFile);
            }
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.OpeningFile", (String[])new String[]{((GetFilesRowsCountData)this.data).file.toString()}));
            }
            this.getRowNumber();
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.FileOpened", (String[])new String[]{((GetFilesRowsCountData)this.data).file.toString()}));
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.UnableToOpenFile", (String[])new String[]{"" + ((GetFilesRowsCountData)this.data).fileNumber, ((GetFilesRowsCountData)this.data).file.toString(), e.toString()}));
            this.stopAll();
            this.setErrors(1L);
            return false;
        }
        return true;
    }

    private boolean getNextFilenameFromField() {
        if (((GetFilesRowsCountData)this.data).fileNumber >= (long)((GetFilesRowsCountData)this.data).files.nrOfFiles()) {
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.FinishedProcessing", (String[])new String[0]));
            }
            return true;
        }
        ((GetFilesRowsCountData)this.data).lastFile = ((GetFilesRowsCountData)this.data).fileNumber == (long)(((GetFilesRowsCountData)this.data).files.nrOfFiles() - 1);
        ((GetFilesRowsCountData)this.data).file = ((GetFilesRowsCountData)this.data).files.getFile((int)((GetFilesRowsCountData)this.data).fileNumber);
        return false;
    }

    public boolean init() {
        if (!super.init()) {
            return false;
        }
        GetFilesRowsCountMeta.SeparatorFormat format = ((GetFilesRowsCountMeta)this.meta).getRowSeparatorFormat();
        switch (format) {
            case CUSTOM: {
                if (StringUtils.isEmpty((String)((GetFilesRowsCountMeta)this.meta).getRowSeparator())) {
                    this.logError(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Error.NoSeparator.Title", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Error.NoSeparator.Msg", (String[])new String[0])});
                    this.setErrors(1L);
                    return false;
                }
                ((GetFilesRowsCountData)this.data).separator = this.resolve(((GetFilesRowsCountMeta)this.meta).getRowSeparator()).charAt(0);
                break;
            }
            case LF: {
                ((GetFilesRowsCountData)this.data).separator = (char)10;
                break;
            }
            case CR: {
                ((GetFilesRowsCountData)this.data).separator = (char)13;
                break;
            }
            case TAB: {
                ((GetFilesRowsCountData)this.data).separator = (char)9;
                break;
            }
        }
        if (this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.Separator.Title", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.Separatoris.Infos", (String[])new String[0]) + " " + ((GetFilesRowsCountData)this.data).separator});
        }
        if (!((GetFilesRowsCountMeta)this.meta).isFileFromField()) {
            ((GetFilesRowsCountData)this.data).files = ((GetFilesRowsCountMeta)this.meta).getFiles((IVariables)this);
            if (((GetFilesRowsCountData)this.data).files == null || ((GetFilesRowsCountData)this.data).files.nrOfFiles() == 0) {
                this.logError(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.NoFiles", (String[])new String[0]));
                return false;
            }
            try {
                ((GetFilesRowsCountData)this.data).outputRowMeta = new RowMeta();
                ((GetFilesRowsCountMeta)this.meta).getFields(((GetFilesRowsCountData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            }
            catch (Exception e) {
                this.logError("Error initializing transform: ", e);
                return false;
            }
        }
        ((GetFilesRowsCountData)this.data).rowNumber = 0L;
        ((GetFilesRowsCountData)this.data).fileNumber = 0L;
        ((GetFilesRowsCountData)this.data).totalPreviousFields = 0;
        return true;
    }

    public void dispose() {
        if (((GetFilesRowsCountData)this.data).file != null) {
            try {
                ((GetFilesRowsCountData)this.data).file.close();
                ((GetFilesRowsCountData)this.data).file = null;
            }
            catch (Exception e) {
                this.logError("Error closing file", e);
            }
        }
        if (((GetFilesRowsCountData)this.data).lineStringBuilder != null) {
            ((GetFilesRowsCountData)this.data).lineStringBuilder = null;
        }
        super.dispose();
    }
}

