/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.execution.local;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.FileTypeSelector;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.json.HopJson;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.execution.Execution;
import org.apache.hop.execution.ExecutionData;
import org.apache.hop.execution.ExecutionState;
import org.apache.hop.execution.ExecutionType;
import org.apache.hop.execution.IExecutionInfoLocation;
import org.apache.hop.execution.IExecutionMatcher;
import org.apache.hop.execution.plugin.ExecutionInfoLocationPlugin;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;

@GuiPlugin(description="File execution information location GUI elements")
@ExecutionInfoLocationPlugin(id="local-folder", name="File location", description="Stores execution information in a folder structure")
public class FileExecutionInfoLocation
implements IExecutionInfoLocation {
    public static final String FILENAME_EXECUTION_JSON = "execution.json";
    public static final String FILENAME_STATE_JSON = "state.json";
    public static final String FILENAME_STATE_LOG = "state.log";
    public static final String CONST_DATA_JSON = "-data.json";
    public static final int MAX_JSON_LOGGING_TEXT_SIZE = 2000;
    @HopMetadataProperty
    protected String pluginId;
    @HopMetadataProperty
    protected String pluginName;
    @GuiWidgetElement(id="rootFolder", order="010", parentId="ExecutionInfoLocation-PluginSpecific-Options", type=GuiElementType.FOLDER, toolTip="i18n::LocalExecutionInfoLocation.RootFolder.Tooltip", label="i18n::LocalExecutionInfoLocation.RootFolder.Label")
    @HopMetadataProperty
    protected String rootFolder;
    private IVariables variables;

    public FileExecutionInfoLocation() {
    }

    public FileExecutionInfoLocation(String rootFolder) {
        this.pluginId = "local-folder";
        this.pluginName = "File location";
        this.rootFolder = rootFolder;
    }

    public FileExecutionInfoLocation(FileExecutionInfoLocation location) {
        this.pluginId = location.pluginId;
        this.pluginName = location.pluginName;
        this.rootFolder = location.rootFolder;
    }

    @Override
    public FileExecutionInfoLocation clone() {
        return new FileExecutionInfoLocation(this);
    }

    @Override
    public void initialize(IVariables variables, IHopMetadataProvider metadataProvider) throws HopException {
        this.variables = variables;
    }

    @Override
    public synchronized void close() throws HopException {
    }

    @Override
    public synchronized void registerExecution(Execution execution) throws HopException {
        try {
            String folderName = this.getSubFolder(execution);
            String registrationFileName = folderName + Const.FILE_SEPARATOR + FILENAME_EXECUTION_JSON;
            HopVfs.getFileObject((String)registrationFileName).getParent().createFolder();
            try (OutputStream outputStream = HopVfs.getOutputStream((String)registrationFileName, (boolean)false);){
                ObjectMapper mapper = HopJson.newMapper();
                mapper.writerWithDefaultPrettyPrinter().writeValue(outputStream, (Object)execution);
            }
        }
        catch (Exception e) {
            throw new HopException("Error registering execution information", (Throwable)e);
        }
    }

    @Override
    public synchronized boolean deleteExecution(String executionId) throws HopException {
        try {
            List<Execution> childExecutions = this.findExecutions(executionId);
            for (Execution childExecution : childExecutions) {
                this.deleteExecution(childExecution.getId());
            }
            FileObject executionFolder = HopVfs.getFileObject((String)this.getSubFolder(executionId));
            for (FileObject child : executionFolder.getChildren()) {
                child.delete();
            }
            executionFolder.delete();
            return true;
        }
        catch (Exception e) {
            throw new HopException("Error deleting execution with ID " + executionId, (Throwable)e);
        }
    }

    @Override
    public synchronized Execution findLastExecution(ExecutionType executionType, String name) throws HopException {
        try {
            List<String> ids = this.getExecutionIds(true, 100);
            for (String id : ids) {
                Execution execution = this.getExecution(id);
                if (execution.getExecutionType() != executionType || !name.equals(execution.getName())) continue;
                return execution;
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException("Error looking up the last execution of type " + String.valueOf((Object)executionType) + " and name " + name, (Throwable)e);
        }
    }

    @Override
    public synchronized void updateExecutionState(ExecutionState executionState) throws HopException {
        block18: {
            try {
                boolean saveLoggingToFile;
                ExecutionState oldState;
                if (executionState == null) {
                    throw new HopException("Please provide a non-null ExecutionState to update");
                }
                if (executionState.getLastLogLineNr() != null && (oldState = this.getExecutionState(executionState.getId())) != null) {
                    executionState.setLoggingText(oldState.getLoggingText() + executionState.getLoggingText());
                }
                String updateFilename = this.getUpdateFilename(executionState);
                String loggingText = executionState.getLoggingText();
                boolean bl = saveLoggingToFile = loggingText != null && loggingText.length() > 2000;
                if (saveLoggingToFile) {
                    executionState.setLoggingText(loggingText.substring(0, 2000));
                }
                HopVfs.getFileObject((String)updateFilename).getParent().createFolder();
                try (OutputStream outputStream = HopVfs.getOutputStream((String)updateFilename, (boolean)false);){
                    ObjectMapper mapper = HopJson.newMapper();
                    mapper.writerWithDefaultPrettyPrinter().writeValue(outputStream, (Object)executionState);
                }
                if (!saveLoggingToFile) break block18;
                String logFilename = this.getLogFilename(executionState);
                try (OutputStream outputStream = HopVfs.getOutputStream((String)logFilename, (boolean)false);){
                    outputStream.write(loggingText.getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (Exception e) {
                throw new HopException("Error updating execution information", (Throwable)e);
            }
        }
    }

    @Override
    public ExecutionState getExecutionState(String executionId) throws HopException {
        return this.getExecutionState(executionId, true);
    }

    @Override
    public synchronized ExecutionState getExecutionState(String executionId, boolean includeLogging) throws HopException {
        ExecutionState executionState;
        block10: {
            String updateFilename = this.getUpdateFilename(executionId);
            if (!HopVfs.fileExists((String)updateFilename)) {
                return null;
            }
            InputStream inputStream = HopVfs.getInputStream((String)updateFilename);
            try {
                ObjectMapper mapper = HopJson.newMapper();
                ExecutionState executionState2 = (ExecutionState)mapper.readValue(inputStream, ExecutionState.class);
                if (includeLogging) {
                    executionState2.setLoggingText(this.getExecutionStateLoggingText(executionId, 20000000));
                }
                executionState = executionState2;
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new HopException("Unable to get the execution status for ID " + executionId, (Throwable)e);
                }
            }
            inputStream.close();
        }
        return executionState;
    }

    @Override
    public String getExecutionStateLoggingText(String executionId, int sizeLimit) throws HopException {
        try {
            ExecutionState state = this.getExecutionState(executionId, false);
            if (state == null) {
                return null;
            }
            return this.getExecutionStateLoggingText(state, sizeLimit);
        }
        catch (Exception e) {
            throw new HopException("Error reading state logging text for execution ID " + executionId, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getExecutionStateLoggingText(ExecutionState executionState, int sizeLimit) throws HopException {
        try {
            String logFilename = this.getLogFilename(executionState);
            if (!HopVfs.fileExists((String)logFilename)) {
                if (!StringUtils.isEmpty((String)executionState.getLoggingText())) return executionState.getLoggingText().substring(0, Math.min(sizeLimit, executionState.getLoggingText().length()));
                return null;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(HopVfs.getInputStream((String)logFilename), StandardCharsets.UTF_8));){
                int c;
                StringBuilder log = new StringBuilder();
                while ((c = ((Reader)reader).read()) != -1 && (sizeLimit <= 0 || sizeLimit > log.length())) {
                    log.append((char)c);
                }
                String string = log.toString();
                return string;
            }
        }
        catch (Exception e) {
            throw new HopException("Error loading the logging text associated with the execution state of " + executionState.getId(), (Throwable)e);
        }
    }

    @Override
    public synchronized void registerData(ExecutionData data) throws HopException {
        try {
            String dataFilename = this.getDataFilename(data);
            try (OutputStream outputStream = HopVfs.getOutputStream((String)dataFilename, (boolean)false);){
                ObjectMapper mapper = HopJson.newMapper();
                mapper.writerWithDefaultPrettyPrinter().writeValue(outputStream, (Object)data);
            }
        }
        catch (Exception e) {
            throw new HopException("Error storing execution data", (Throwable)e);
        }
    }

    @Override
    public synchronized List<String> getExecutionIds(boolean includeChildren, int limit) throws HopException {
        try {
            ArrayList<ExecutionIdAndDate> list = new ArrayList<ExecutionIdAndDate>();
            ArrayList<FileObject> subFolders = new ArrayList<FileObject>();
            FileObject folder = HopVfs.getFileObject((String)this.variables.resolve(this.rootFolder));
            if (!folder.exists()) {
                return Collections.emptyList();
            }
            FileObject[] childFolders = folder.findFiles((FileSelector)new FileTypeSelector(FileType.FOLDER));
            for (FileObject child : childFolders) {
                if (!child.isFolder()) continue;
                subFolders.add(child);
            }
            for (FileObject subFolder : subFolders) {
                Date updateDate;
                Execution execution;
                FileObject executionFileObject = subFolder.getChild(FILENAME_EXECUTION_JSON);
                if (executionFileObject == null || !executionFileObject.exists()) continue;
                ObjectMapper objectMapper = HopJson.newMapper();
                ExecutionState state = null;
                try (InputStream inputStream = HopVfs.getInputStream((FileObject)executionFileObject);){
                    execution = (Execution)objectMapper.readValue(inputStream, Execution.class);
                }
                try {
                    inputStream = HopVfs.getInputStream((FileObject)subFolder.getChild(FILENAME_STATE_JSON));
                    try {
                        state = (ExecutionState)objectMapper.readValue(inputStream, ExecutionState.class);
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                }
                catch (Exception inputStream2) {
                    // empty catch block
                }
                String id = execution.getId();
                Date startDate = execution.getExecutionStartDate();
                Date date = updateDate = state == null ? null : state.getUpdateTime();
                if (!includeChildren && !StringUtils.isEmpty((String)execution.getParentId())) continue;
                list.add(new ExecutionIdAndDate(id, startDate, updateDate));
            }
            Collections.sort(list, ExecutionIdAndDate::compareTo);
            ArrayList<String> ids = new ArrayList<String>();
            list.forEach(e -> {
                if (limit <= 0 || ids.size() < limit) {
                    ids.add(e.id);
                }
            });
            return ids;
        }
        catch (Exception e2) {
            throw new HopException("Error listing execution IDs", (Throwable)e2);
        }
    }

    @Override
    public synchronized List<String> findChildIds(ExecutionType parentExecutionType, String parentExecutionId) throws HopException {
        try {
            ArrayList<String> ids = new ArrayList<String>();
            String suffix = CONST_DATA_JSON;
            FileObject folderObject = HopVfs.getFileObject((String)this.getSubFolder(parentExecutionId));
            for (FileObject child : folderObject.getChildren()) {
                String baseName;
                if (child == null || !(baseName = child.getName().getBaseName()).endsWith(suffix)) continue;
                String id = baseName.substring(0, baseName.length() - suffix.length());
                ids.add(id);
            }
            return ids;
        }
        catch (Exception e) {
            throw new HopException("Error finding children of " + parentExecutionType.name() + " execution " + parentExecutionId, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized Execution getExecution(String executionId) throws HopException {
        try (FileObject folder = HopVfs.getFileObject((String)this.getSubFolder(executionId));){
            Execution execution;
            block18: {
                if (folder == null || !folder.exists()) {
                    Execution execution2 = null;
                    return execution2;
                }
                FileObject executionFileObject = folder.getChild(FILENAME_EXECUTION_JSON);
                if (!executionFileObject.exists()) {
                    Execution execution3 = null;
                    return execution3;
                }
                ObjectMapper objectMapper = HopJson.newMapper();
                InputStream inputStream = HopVfs.getInputStream((FileObject)executionFileObject);
                try {
                    execution = (Execution)objectMapper.readValue(inputStream, Execution.class);
                    if (inputStream == null) break block18;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return execution;
        }
        catch (Exception e) {
            throw new HopException("Error getting execution information for ID " + executionId, (Throwable)e);
        }
    }

    @Override
    public synchronized List<Execution> findExecutions(String parentExecutionId) throws HopException {
        try {
            ArrayList<Execution> executions = new ArrayList<Execution>();
            for (String id : this.getExecutionIds(true, 10000)) {
                Execution execution = this.getExecution(id);
                if (!parentExecutionId.equals(execution.getParentId())) continue;
                executions.add(execution);
            }
            return executions;
        }
        catch (Exception e) {
            throw new HopException("Error finding child executions for parent ID " + parentExecutionId, (Throwable)e);
        }
    }

    @Override
    public synchronized List<Execution> findExecutions(IExecutionMatcher matcher) throws HopException {
        try {
            ArrayList<Execution> executions = new ArrayList<Execution>();
            for (String id : this.getExecutionIds(true, 0)) {
                Execution execution = this.getExecution(id);
                if (!matcher.matches(execution)) continue;
                executions.add(execution);
            }
            return executions;
        }
        catch (Exception e) {
            throw new HopException("Error finding executions with a matcher", (Throwable)e);
        }
    }

    @Override
    public synchronized Execution findPreviousSuccessfulExecution(ExecutionType executionType, String name) throws HopException {
        try {
            List<Execution> executions = this.findExecutions((Execution e) -> e.getExecutionType() == executionType && name.equals(e.getName()));
            for (Execution execution : executions) {
                ExecutionState executionState = this.getExecutionState(execution.getId());
                if (executionState == null || executionState.isFailed()) continue;
                return execution;
            }
            return null;
        }
        catch (Exception e2) {
            throw new HopException("Error finding previous successful execution", (Throwable)e2);
        }
    }

    @Override
    public synchronized String findParentId(String childId) throws HopException {
        try {
            for (String id : this.getExecutionIds(true, 100)) {
                ExecutionState executionState = this.getExecutionState(id);
                if (!executionState.getChildIds().contains(childId)) continue;
                return id;
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException("Error finding parent execution for child ID " + childId, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized ExecutionData getExecutionData(String parentExecutionId, String executionId) throws HopException {
        try (FileObject folder = HopVfs.getFileObject((String)this.getSubFolder(parentExecutionId));){
            ExecutionData executionData;
            block18: {
                if (!folder.exists()) {
                    ExecutionData executionData2 = null;
                    return executionData2;
                }
                FileObject dataFileObject = folder.getChild(executionId + CONST_DATA_JSON);
                if (dataFileObject == null || !dataFileObject.exists()) {
                    ExecutionData executionData3 = null;
                    return executionData3;
                }
                InputStream inputStream = HopVfs.getInputStream((FileObject)dataFileObject);
                try {
                    ObjectMapper objectMapper = HopJson.newMapper();
                    executionData = (ExecutionData)objectMapper.readValue(inputStream, ExecutionData.class);
                    if (inputStream == null) break block18;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return executionData;
        }
        catch (Exception e) {
            throw new HopException("Error looking up execution data for parent execution ID " + parentExecutionId, (Throwable)e);
        }
    }

    private String getSubFolder(Execution registration) {
        return this.variables.resolve(this.rootFolder) + "/" + registration.getId();
    }

    private String getSubFolder(ExecutionState update) {
        return this.getSubFolder(update.getId());
    }

    private String getSubFolder(String executionId) {
        return this.variables.resolve(this.rootFolder) + "/" + executionId;
    }

    private String getSubFolder(ExecutionData data) {
        return this.getSubFolder(data.getParentId());
    }

    private String getUpdateFilename(ExecutionState update) {
        return this.getUpdateFilename(update.getId());
    }

    private String getUpdateFilename(String id) {
        Object filename = this.getSubFolder(id);
        filename = (String)filename + "/state.json";
        return filename;
    }

    private String getLogFilename(ExecutionState update) {
        Object filename = this.getSubFolder(update);
        filename = (String)filename + "/" + update.getExecutionType().getFilePrefix() + "-log.txt";
        return filename;
    }

    private String getDataFilename(ExecutionData data) {
        Object filename = this.getSubFolder(data);
        filename = (String)filename + "/" + data.getOwnerId() + CONST_DATA_JSON;
        return filename;
    }

    @Override
    public String getPluginId() {
        return this.pluginId;
    }

    @Override
    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    @Override
    public String getPluginName() {
        return this.pluginName;
    }

    @Override
    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public String getRootFolder() {
        return this.rootFolder;
    }

    public void setRootFolder(String rootFolder) {
        this.rootFolder = rootFolder;
    }

    private static class ExecutionIdAndDate {
        public String id;
        public Date startDate;
        public Date updateDate;

        public ExecutionIdAndDate(String id, Date startDate, Date updateDate) {
            this.id = id;
            this.startDate = startDate;
            this.updateDate = updateDate;
        }

        public int compareTo(ExecutionIdAndDate e) {
            if (e.updateDate == null || this.updateDate == null) {
                return -this.startDate.compareTo(e.startDate);
            }
            return -this.updateDate.compareTo(e.updateDate);
        }
    }
}

