/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.crypto.cipher;

import com.trilead.ssh2.crypto.cipher.BlockCipher;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CipherOutputStream {
    private BlockCipher currentCipher;
    private final BufferedOutputStream bo;
    private byte[] buffer;
    private byte[] enc;
    private int blockSize;
    private int pos;
    private boolean recordingOutput;
    private final ByteArrayOutputStream recordingOutputStream = new ByteArrayOutputStream();

    public CipherOutputStream(BlockCipher tc, OutputStream bo) {
        this.bo = bo instanceof BufferedOutputStream ? (BufferedOutputStream)bo : new BufferedOutputStream(bo);
        this.changeCipher(tc);
    }

    public void flush() throws IOException {
        if (this.pos != 0) {
            throw new IOException("FATAL: cannot flush since crypto buffer is not aligned.");
        }
        this.bo.flush();
    }

    public void changeCipher(BlockCipher bc) {
        this.currentCipher = bc;
        this.blockSize = bc.getBlockSize();
        this.buffer = new byte[this.blockSize];
        this.enc = new byte[this.blockSize];
        this.pos = 0;
    }

    public void startRecording() {
        this.recordingOutput = true;
    }

    public byte[] getRecordedOutput() {
        this.recordingOutput = false;
        byte[] recordedOutput = this.recordingOutputStream.toByteArray();
        this.recordingOutputStream.reset();
        return recordedOutput;
    }

    private void writeBlock() throws IOException {
        try {
            this.currentCipher.transformBlock(this.buffer, 0, this.enc, 0);
        }
        catch (Exception e) {
            throw new IOException("Error while decrypting block.", e);
        }
        this.bo.write(this.enc, 0, this.blockSize);
        this.pos = 0;
        if (this.recordingOutput) {
            this.recordingOutputStream.write(this.enc, 0, this.blockSize);
        }
    }

    public void write(byte[] src, int off, int len) throws IOException {
        while (len > 0) {
            int avail = this.blockSize - this.pos;
            int copy = Math.min(avail, len);
            System.arraycopy(src, off, this.buffer, this.pos, copy);
            this.pos += copy;
            off += copy;
            len -= copy;
            if (this.pos < this.blockSize) continue;
            this.writeBlock();
        }
    }

    public void write(int b) throws IOException {
        this.buffer[this.pos++] = (byte)b;
        if (this.pos >= this.blockSize) {
            this.writeBlock();
        }
    }

    public void writePlain(int b) throws IOException {
        if (this.pos != 0) {
            throw new IOException("Cannot write plain since crypto buffer is not aligned.");
        }
        this.bo.write(b);
    }

    public void writePlain(byte[] b, int off, int len) throws IOException {
        if (this.pos != 0) {
            throw new IOException("Cannot write plain since crypto buffer is not aligned.");
        }
        this.bo.write(b, off, len);
    }
}

