/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.accessoutput;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import com.healthmarketscience.jackcess.Table;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.accessoutput.AccessFileFormat;
import org.apache.hop.pipeline.transforms.accessoutput.AccessOutput;
import org.apache.hop.pipeline.transforms.accessoutput.AccessOutputData;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;

@Transform(id="AccessOutput", name="i18n::AccessOutput.Name", description="i18n::AccessOutput.Description", image="accessoutput.svg", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Output", keywords={"i18n::AccessOutput.Keyword"}, documentationUrl="/pipeline/transforms/accessoutput.html")
public class AccessOutputMeta
extends BaseTransformMeta<AccessOutput, AccessOutputData> {
    private static final Class<?> PKG = AccessOutputMeta.class;
    public static final int COMMIT_SIZE = 500;
    @HopMetadataProperty(key="filename", injectionKeyDescription="AccessOutputMeta.Injection.FILE_NAME")
    private String fileName;
    @HopMetadataProperty(key="fileformat", storeWithCode=true, injectionKeyDescription="AccessOutputMeta.Injection.FILE_FORMAT")
    private AccessFileFormat fileFormat;
    @HopMetadataProperty(key="tablename", injectionKeyDescription="AccessOutputMeta.Injection.TABLE_NAME")
    private String tableName;
    @HopMetadataProperty(key="create_table", injectionKeyDescription="AccessOutputMeta.Injection.CREATE_TABLE")
    private boolean createTable;
    @HopMetadataProperty(key="create_file", injectionKeyDescription="AccessOutputMeta.Injection.CREATE_FILE")
    private boolean createFile;
    @HopMetadataProperty(key="truncate", injectionKeyDescription="AccessOutputMeta.Injection.TRUNCATE")
    private boolean truncateTable;
    @HopMetadataProperty(key="commit_size", injectionKeyDescription="AccessOutputMeta.Injection.COMMIT_SIZE")
    private int commitSize;
    @HopMetadataProperty(key="add_to_result_filenames", injectionKeyDescription="AccessOutputMeta.Injection.ADD_TO_RESULT_FILE")
    private boolean addToResultFile;
    @HopMetadataProperty(key="do_not_open_newfile_init", injectionKeyDescription="AccessOutputMeta.Injection.WAIT_FIRST_ROW_TO_CREATE_FILE")
    private boolean waitFirstRowToCreateFile;

    public Object clone() {
        AccessOutputMeta retval = (AccessOutputMeta)((Object)super.clone());
        return retval;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tablename) {
        this.tableName = tablename;
    }

    public void setTruncateTable(boolean truncateTable) {
        this.truncateTable = truncateTable;
    }

    public void setDefault() {
        this.createFile = true;
        this.fileFormat = AccessFileFormat.V2019;
        this.createTable = true;
        this.truncateTable = false;
        this.commitSize = 500;
        this.waitFirstRowToCreateFile = false;
        this.addToResultFile = true;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"AccessOutputMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"AccessOutputMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (Utils.isEmpty((CharSequence)this.fileName)) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"AccessOutputMeta.CheckResult.MissingDatabaseFileName", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (Utils.isEmpty((CharSequence)this.tableName)) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"AccessOutputMeta.CheckResult.MissingTableName", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public IRowMeta getRequiredFields(IVariables variables) throws HopException {
        String realFilename = variables.resolve(this.fileName);
        File file = new File(realFilename);
        Database db = null;
        try {
            String realTablename;
            if (!file.exists() || !file.isFile()) {
                throw new HopException(BaseMessages.getString(PKG, (String)"AccessOutputMeta.Exception.FileDoesNotExist", (String[])new String[]{realFilename}));
            }
            db = DatabaseBuilder.open((File)file);
            Table table = db.getTable(realTablename = variables.resolve(this.tableName));
            if (table == null) {
                throw new HopException(BaseMessages.getString(PKG, (String)"AccessOutputMeta.Exception.TableDoesNotExist", (String[])new String[]{realTablename}));
            }
            IRowMeta iRowMeta = AccessOutputMeta.getLayout(table);
            return iRowMeta;
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"AccessOutputMeta.Exception.ErrorGettingFields", (String[])new String[0]), (Throwable)e);
        }
        finally {
            try {
                if (db != null) {
                    db.close();
                }
            }
            catch (IOException e) {
                throw new HopException(BaseMessages.getString(PKG, (String)"AccessOutputMeta.Exception.ErrorClosingDatabase", (String[])new String[0]), (Throwable)e);
            }
        }
    }

    public static final IRowMeta getLayout(Table table) throws HopTransformException, IOException {
        RowMeta row = new RowMeta();
        for (Column column : table.getColumns()) {
            IValueMeta v;
            int valtype = 2;
            int length = -1;
            int precision = -1;
            int type = column.getType().getSQLType();
            switch (type) {
                case -1: 
                case 1: 
                case 12: {
                    valtype = 2;
                    length = column.getLength();
                    break;
                }
                case 2005: {
                    valtype = 2;
                    length = 9999999;
                    break;
                }
                case -5: {
                    valtype = 5;
                    precision = 0;
                    length = 15;
                    break;
                }
                case 4: {
                    valtype = 5;
                    precision = 0;
                    length = 9;
                    break;
                }
                case 5: {
                    valtype = 5;
                    precision = 0;
                    length = 4;
                    break;
                }
                case -6: {
                    valtype = 5;
                    precision = 0;
                    length = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    valtype = 1;
                    length = column.getLength();
                    precision = column.getPrecision();
                    if (length >= 126) {
                        length = -1;
                    }
                    if (precision >= 126) {
                        precision = -1;
                    }
                    if (type == 8 || type == 6 || type == 7) {
                        if (precision == 0) {
                            precision = -1;
                        }
                    } else if (precision == 0 && length < 18 && length > 0) {
                        valtype = 5;
                    }
                    if (length <= 18 && precision <= 18) break;
                    valtype = 6;
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    valtype = 3;
                    break;
                }
                case -7: 
                case 16: {
                    valtype = 4;
                    break;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    valtype = 8;
                    break;
                }
                default: {
                    valtype = 2;
                    length = column.getLength();
                }
            }
            try {
                v = ValueMetaFactory.createValueMeta((String)column.getName(), (int)valtype);
            }
            catch (HopPluginException e) {
                throw new HopTransformException((Throwable)e);
            }
            v.setLength(length, precision);
            row.addValueMeta(v);
        }
        return row;
    }

    public boolean isCreateFile() {
        return this.createFile;
    }

    public void setCreateFile(boolean fileCreated) {
        this.createFile = fileCreated;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String filename) {
        this.fileName = filename;
    }

    public AccessFileFormat getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(AccessFileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }

    public boolean isCreateTable() {
        return this.createTable;
    }

    public void setCreateTable(boolean tableCreated) {
        this.createTable = tableCreated;
    }

    public boolean isTruncateTable() {
        return this.truncateTable;
    }

    public int getCommitSize() {
        return this.commitSize;
    }

    public void setCommitSize(int commitSize) {
        this.commitSize = commitSize;
    }

    public boolean isAddToResultFile() {
        return this.addToResultFile;
    }

    public void setAddToResultFile(boolean addtoresultfilenamesin) {
        this.addToResultFile = addtoresultfilenamesin;
    }

    public boolean isWaitFirstRowToCreateFile() {
        return this.waitFirstRowToCreateFile;
    }

    public void setWaitFirstRowToCreateFile(boolean doNotOpenNewFileInit) {
        this.waitFirstRowToCreateFile = doNotOpenNewFileInit;
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            if (!Utils.isEmpty((CharSequence)this.fileName)) {
                FileObject fileObject = HopVfs.getFileObject((String)variables.resolve(this.fileName));
                this.fileName = iResourceNaming.nameResource(fileObject, variables, true);
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }
}

