/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

enum CloudKnownType {
    TEXT("http://schema.org/Text", new Class[]{String.class}){

        @Override
        public <T> T parse(@UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
            return clazz.cast(value);
        }
    }
    ,
    BOOLEAN("http://schema.org/Boolean", new Class[]{Boolean.class}){

        @Override
        public <T> T parse(@UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
            return clazz.cast(value);
        }
    }
    ,
    INTEGER("http://schema.org/Integer", new Class[]{Long.class, Integer.class}){

        @Override
        public <T> T parse(@UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
            Object result = null;
            if (value.getClass() == clazz) {
                result = value;
            } else if (clazz == Long.class) {
                if (value instanceof Integer) {
                    result = ((Integer)value).longValue();
                } else if (value instanceof String) {
                    result = Long.valueOf((String)value);
                }
            } else if (clazz == Integer.class) {
                if (value instanceof Long) {
                    result = ((Long)value).intValue();
                } else if (value instanceof String) {
                    result = Integer.valueOf((String)value);
                }
            }
            return clazz.cast(result);
        }
    }
    ,
    FLOAT("http://schema.org/Float", new Class[]{Double.class, Float.class}){

        @Override
        public <T> T parse(@UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
            Object result = null;
            if (value.getClass() == clazz) {
                result = value;
            } else if (clazz == Double.class) {
                if (value instanceof Float) {
                    result = ((Float)value).doubleValue();
                } else if (value instanceof String) {
                    result = Double.valueOf((String)value);
                }
            } else if (clazz == Float.class) {
                if (value instanceof Double) {
                    result = Float.valueOf(((Double)value).floatValue());
                } else if (value instanceof String) {
                    result = Float.valueOf((String)value);
                }
            }
            return clazz.cast(result);
        }
    };

    private final @UnknownKeyFor @NonNull @Initialized String uri;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> classes;
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized CloudKnownType> typesByUri;
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized CloudKnownType> typesByClass;

    private CloudKnownType(String uri, Class<?> ... classes) {
        this.uri = uri;
        this.classes = ImmutableList.copyOf((Object[])classes);
    }

    public @UnknownKeyFor @NonNull @Initialized String getUri() {
        return this.uri;
    }

    public abstract <T> T parse(@UnknownKeyFor @NonNull @Initialized Object var1, @UnknownKeyFor @NonNull @Initialized Class<T> var2);

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> defaultClass() {
        return (Class)this.classes.get(0);
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized CloudKnownType> buildTypesByUri() {
        HashMap<String, CloudKnownType> result = new HashMap<String, CloudKnownType>();
        for (CloudKnownType ty : CloudKnownType.values()) {
            result.put(ty.getUri(), ty);
        }
        return result;
    }

    public static @Nullable @UnknownKeyFor @Initialized CloudKnownType forUri(@Nullable @UnknownKeyFor @Initialized String uri) {
        if (uri == null) {
            return null;
        }
        return typesByUri.get(uri);
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized CloudKnownType> buildTypesByClass() {
        HashMap result = new HashMap();
        for (CloudKnownType ty : CloudKnownType.values()) {
            for (Class clazz : ty.classes) {
                result.put(clazz, ty);
            }
        }
        return result;
    }

    public static @Nullable @UnknownKeyFor @Initialized CloudKnownType forClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz) {
        return typesByClass.get(clazz);
    }

    static {
        typesByUri = Collections.unmodifiableMap(CloudKnownType.buildTypesByUri());
        typesByClass = Collections.unmodifiableMap(CloudKnownType.buildTypesByClass());
    }
}

