/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cassandra.cql3.Json;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.FrozenType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.serializers.ListSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.TimeUUID;

public class ListType<T>
extends CollectionType<List<T>> {
    private static final ConcurrentHashMap<AbstractType<?>, ListType> instances = new ConcurrentHashMap();
    private static final ConcurrentHashMap<AbstractType<?>, ListType> frozenInstances = new ConcurrentHashMap();
    private final AbstractType<T> elements;
    public final ListSerializer<T> serializer;
    private final boolean isMultiCell;

    public static ListType<?> getInstance(TypeParser parser) throws ConfigurationException, SyntaxException {
        List<AbstractType<?>> l = parser.getTypeParameters();
        if (l.size() != 1) {
            throw new ConfigurationException("ListType takes exactly 1 type parameter");
        }
        return ListType.getInstance(l.get(0), true);
    }

    public static <T> ListType<T> getInstance(AbstractType<T> elements, boolean isMultiCell) {
        ConcurrentHashMap<AbstractType<?>, ListType> internMap = isMultiCell ? instances : frozenInstances;
        ListType t = internMap.get(elements);
        return null == t ? internMap.computeIfAbsent(elements, k -> new ListType(k, isMultiCell)) : t;
    }

    private ListType(AbstractType<T> elements, boolean isMultiCell) {
        super(AbstractType.ComparisonType.CUSTOM, CollectionType.Kind.LIST);
        this.elements = elements;
        this.serializer = ListSerializer.getInstance(elements.getSerializer());
        this.isMultiCell = isMultiCell;
    }

    @Override
    public <V> boolean referencesUserType(V name, ValueAccessor<V> accessor) {
        return this.elements.referencesUserType(name, accessor);
    }

    @Override
    public ListType<?> withUpdatedUserType(UserType udt) {
        if (!this.referencesUserType(udt.name)) {
            return this;
        }
        (this.isMultiCell ? instances : frozenInstances).remove(this.elements);
        return ListType.getInstance(this.elements.withUpdatedUserType(udt), this.isMultiCell);
    }

    @Override
    public AbstractType<?> expandUserTypes() {
        return ListType.getInstance(this.elements.expandUserTypes(), this.isMultiCell);
    }

    @Override
    public boolean referencesDuration() {
        return this.getElementsType().referencesDuration();
    }

    public AbstractType<T> getElementsType() {
        return this.elements;
    }

    @Override
    public AbstractType<TimeUUID> nameComparator() {
        return TimeUUIDType.instance;
    }

    @Override
    public AbstractType<T> valueComparator() {
        return this.elements;
    }

    @Override
    public ListSerializer<T> getSerializer() {
        return this.serializer;
    }

    @Override
    public AbstractType<?> freeze() {
        if (this.isMultiCell) {
            return ListType.getInstance(this.elements, false);
        }
        return this;
    }

    @Override
    public AbstractType<?> freezeNestedMulticellTypes() {
        if (!this.isMultiCell()) {
            return this;
        }
        if (this.elements.isFreezable() && this.elements.isMultiCell()) {
            return ListType.getInstance(this.elements.freeze(), this.isMultiCell);
        }
        return ListType.getInstance(this.elements.freezeNestedMulticellTypes(), this.isMultiCell);
    }

    @Override
    public List<AbstractType<?>> subTypes() {
        return Collections.singletonList(this.elements);
    }

    @Override
    public boolean isMultiCell() {
        return this.isMultiCell;
    }

    @Override
    public boolean isCompatibleWithFrozen(CollectionType<?> previous) {
        assert (!this.isMultiCell);
        return this.elements.isCompatibleWith(((ListType)previous).elements);
    }

    @Override
    public boolean isValueCompatibleWithFrozen(CollectionType<?> previous) {
        assert (!this.isMultiCell);
        return this.elements.isValueCompatibleWithInternal(((ListType)previous).elements);
    }

    @Override
    public <VL, VR> int compareCustom(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
        return ListType.compareListOrSet(this.elements, left, accessorL, right, accessorR);
    }

    static <VL, VR> int compareListOrSet(AbstractType<?> elementsComparator, VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
        if (accessorL.isEmpty(left) || accessorR.isEmpty(right)) {
            return Boolean.compare(accessorR.isEmpty(right), accessorL.isEmpty(left));
        }
        int sizeL = CollectionSerializer.readCollectionSize(left, accessorL, ProtocolVersion.V3);
        int offsetL = CollectionSerializer.sizeOfCollectionSize(sizeL, ProtocolVersion.V3);
        int sizeR = CollectionSerializer.readCollectionSize(right, accessorR, ProtocolVersion.V3);
        int offsetR = 4;
        for (int i = 0; i < Math.min(sizeL, sizeR); ++i) {
            VL v1 = CollectionSerializer.readValue(left, accessorL, offsetL, ProtocolVersion.V3);
            offsetL += CollectionSerializer.sizeOfValue(v1, accessorL, ProtocolVersion.V3);
            VR v2 = CollectionSerializer.readValue(right, accessorR, offsetR, ProtocolVersion.V3);
            offsetR += CollectionSerializer.sizeOfValue(v2, accessorR, ProtocolVersion.V3);
            int cmp = elementsComparator.compare(v1, accessorL, v2, accessorR);
            if (cmp == 0) continue;
            return cmp;
        }
        return sizeL == sizeR ? 0 : (sizeL < sizeR ? -1 : 1);
    }

    @Override
    public String toString(boolean ignoreFreezing) {
        boolean includeFrozenType = !ignoreFreezing && !this.isMultiCell();
        StringBuilder sb = new StringBuilder();
        if (includeFrozenType) {
            sb.append(FrozenType.class.getName()).append("(");
        }
        sb.append(this.getClass().getName());
        sb.append(TypeParser.stringifyTypeParameters(Collections.singletonList(this.elements), ignoreFreezing || !this.isMultiCell));
        if (includeFrozenType) {
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public List<ByteBuffer> serializedValues(Iterator<Cell<?>> cells) {
        assert (this.isMultiCell);
        ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>();
        while (cells.hasNext()) {
            bbs.add(cells.next().buffer());
        }
        return bbs;
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        if (parsed instanceof String) {
            parsed = Json.decodeJson((String)parsed);
        }
        if (!(parsed instanceof List)) {
            throw new MarshalException(String.format("Expected a list, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
        List list = (List)parsed;
        ArrayList<Term> terms = new ArrayList<Term>(list.size());
        for (Object element : list) {
            if (element == null) {
                throw new MarshalException("Invalid null element in list");
            }
            terms.add(this.elements.fromJSONObject(element));
        }
        return new Lists.DelayedValue(terms);
    }

    public static String setOrListToJsonString(ByteBuffer buffer, AbstractType elementsType, ProtocolVersion protocolVersion) {
        ByteBuffer value = buffer.duplicate();
        StringBuilder sb = new StringBuilder("[");
        int size = CollectionSerializer.readCollectionSize(value, protocolVersion);
        int offset = CollectionSerializer.sizeOfCollectionSize(size, protocolVersion);
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            ByteBuffer element = CollectionSerializer.readValue(value, ByteBufferAccessor.instance, offset, protocolVersion);
            offset += CollectionSerializer.sizeOfValue(element, ByteBufferAccessor.instance, protocolVersion);
            sb.append(elementsType.toJSONString(element, protocolVersion));
        }
        return sb.append("]").toString();
    }

    public ByteBuffer getSliceFromSerialized(ByteBuffer collection, ByteBuffer from, ByteBuffer to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
        return ListType.setOrListToJsonString(buffer, this.elements, protocolVersion);
    }
}

