/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.search.ISearchQuery;
import org.apache.hop.core.search.ISearchResult;
import org.apache.hop.core.search.ISearchable;
import org.apache.hop.core.search.ISearchableAnalyser;
import org.apache.hop.core.search.ISearchablesLocation;
import org.apache.hop.core.search.SearchQuery;
import org.apache.hop.core.search.SearchableAnalyserPluginType;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.context.IGuiContextHandler;
import org.apache.hop.ui.hopgui.file.IHopFileType;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.empty.EmptyHopFileTypeHandler;
import org.apache.hop.ui.hopgui.perspective.HopPerspectivePlugin;
import org.apache.hop.ui.hopgui.perspective.IHopPerspective;
import org.apache.hop.ui.hopgui.perspective.TabItemHandler;
import org.apache.hop.ui.hopgui.shared.AuditManagerGuiUtil;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

@HopPerspectivePlugin(id="400-HopSearchPerspective", name="i18n::HopSearchPerspective.Name", description="i18n::HopSearchPerspective.Description", image="ui/images/search.svg")
@GuiPlugin(description="i18n::HopSearchPerspective.GuiPlugin.Description")
public class HopSearchPerspective
implements IHopPerspective {
    private static final Class<?> PKG = HopSearchPerspective.class;
    public static final String ID_PERSPECTIVE_TOOLBAR_ITEM = "20020-perspective-search";
    public static final String AUDIT_TYPE_SEARCH_LOCATION = "search-location";
    public static final String AUDIT_TYPE_SEARCH_STRING = "search-string";
    private HopGui hopGui;
    private Composite composite;
    private List<ISearchablesLocation> searchablesLocations;
    private String[] locations;
    private Combo wLocations;
    private Combo wSearchString;
    private Button wCaseSensitive;
    private Button wRegEx;
    private TableView wResults;
    List<ISearchResult> allSearchResults;

    @Override
    public String getId() {
        return "search";
    }

    @Override
    public void activate() {
        this.hopGui.setActivePerspective(this);
    }

    @Override
    public void perspectiveActivated() {
        this.wSearchString.setFocus();
        this.searchablesLocations = this.hopGui.getSearchablesLocations();
        this.locations = new String[this.searchablesLocations.size()];
        for (int i = 0; i < this.locations.length; ++i) {
            this.locations[i] = this.searchablesLocations.get(i).getLocationDescription();
        }
        this.refreshLastUsedLocation();
        this.refreshLastUsedSearchStrings();
    }

    private void refreshLastUsedLocation() {
        if (this.wLocations != null && !this.wLocations.isDisposed()) {
            int index;
            this.wLocations.setItems(this.locations);
            String lastLocation = AuditManagerGuiUtil.getLastUsedValue(AUDIT_TYPE_SEARCH_LOCATION);
            if (lastLocation != null && (index = Const.indexOfString((String)lastLocation, (String[])this.locations)) >= 0) {
                this.wLocations.select(index);
            }
        }
    }

    private void refreshLastUsedSearchStrings() {
        if (this.wSearchString != null && !this.wSearchString.isDisposed()) {
            try {
                String[] lastUsedValues = AuditManagerGuiUtil.getLastUsedValues(AUDIT_TYPE_SEARCH_STRING);
                this.wSearchString.setItems(lastUsedValues);
            }
            catch (Exception e) {
                this.hopGui.getLog().logError("Error reading list of used search strings", (Throwable)e);
            }
        }
    }

    @Override
    public IHopFileTypeHandler getActiveFileTypeHandler() {
        return new EmptyHopFileTypeHandler();
    }

    @Override
    public void setActiveFileTypeHandler(IHopFileTypeHandler activeFileTypeHandler) {
    }

    @Override
    public List<IHopFileType> getSupportedHopFileTypes() {
        return Collections.emptyList();
    }

    @Override
    public boolean isActive() {
        return this.hopGui.isActivePerspective(this);
    }

    @Override
    public void initialize(HopGui hopGui, Composite parent) {
        this.hopGui = hopGui;
        PropsUi props = PropsUi.getInstance();
        this.composite = new Composite(parent, 0);
        PropsUi.setLook((Widget)this.composite);
        FormLayout layout = new FormLayout();
        layout.marginLeft = PropsUi.getMargin();
        layout.marginTop = PropsUi.getMargin();
        layout.marginLeft = PropsUi.getMargin();
        layout.marginBottom = PropsUi.getMargin();
        this.composite.setLayout((Layout)layout);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.composite.setLayoutData((Object)formData);
        int margin = (int)((double)PropsUi.getMargin() * props.getZoomFactor());
        Label wlInfo = new Label(this.composite, 16384);
        PropsUi.setLook((Widget)wlInfo);
        wlInfo.setText(BaseMessages.getString(PKG, (String)"HopSearchPerspective.Header.Description.Text", (String[])new String[0]));
        wlInfo.setFont(GuiResource.getInstance().getFontBold());
        FormData fdInfo = new FormData();
        fdInfo.left = new FormAttachment(0, 0);
        fdInfo.right = new FormAttachment(100, 0);
        fdInfo.top = new FormAttachment(0, 0);
        wlInfo.setLayoutData((Object)fdInfo);
        Label lastControl = wlInfo;
        Label wlSep1 = new Label(this.composite, 258);
        PropsUi.setLook((Widget)wlSep1);
        FormData fdlSep1 = new FormData();
        fdlSep1.left = new FormAttachment(0, 0);
        fdlSep1.right = new FormAttachment(100, 0);
        fdlSep1.top = new FormAttachment((Control)lastControl, margin);
        wlSep1.setLayoutData((Object)fdlSep1);
        lastControl = wlSep1;
        Label wlLocations = new Label(this.composite, 16384);
        PropsUi.setLook((Widget)wlLocations);
        wlLocations.setText(BaseMessages.getString(PKG, (String)"HopSearchPerspective.Label.Location", (String[])new String[0]));
        FormData fdlLocations = new FormData();
        fdlLocations.left = new FormAttachment(0, 0);
        fdlLocations.top = new FormAttachment((Control)lastControl, margin);
        wlLocations.setLayoutData((Object)fdlLocations);
        lastControl = wlLocations;
        this.wLocations = new Combo(this.composite, 2048);
        PropsUi.setLook((Widget)this.wLocations);
        FormData fdLocations = new FormData();
        fdLocations.left = new FormAttachment(0, 0);
        fdLocations.top = new FormAttachment((Control)lastControl, margin);
        fdLocations.right = new FormAttachment(50, 0);
        this.wLocations.setLayoutData((Object)fdLocations);
        lastControl = this.wLocations;
        Label wlSearchString = new Label(this.composite, 16384);
        PropsUi.setLook((Widget)wlSearchString);
        wlSearchString.setText(BaseMessages.getString(PKG, (String)"HopSearchPerspective.SearchStringOptions.Description", (String[])new String[0]));
        FormData fdlSearchString = new FormData();
        fdlSearchString.left = new FormAttachment(0, 0);
        fdlSearchString.top = new FormAttachment((Control)lastControl, margin);
        wlSearchString.setLayoutData((Object)fdlSearchString);
        this.wCaseSensitive = new Button(this.composite, 32);
        PropsUi.setLook((Widget)this.wCaseSensitive);
        this.wCaseSensitive.setText(BaseMessages.getString(PKG, (String)"HopSearchPerspective.SearchStringOptions.Option1.Label", (String[])new String[0]));
        FormData fdCaseSensitive = new FormData();
        fdCaseSensitive.left = new FormAttachment((Control)wlSearchString, margin * 2);
        fdCaseSensitive.top = new FormAttachment((Control)lastControl, margin);
        this.wCaseSensitive.setLayoutData((Object)fdCaseSensitive);
        this.wRegEx = new Button(this.composite, 32);
        PropsUi.setLook((Widget)this.wRegEx);
        this.wRegEx.setText(BaseMessages.getString(PKG, (String)"HopSearchPerspective.SearchStringOptions.Option2.Label", (String[])new String[0]));
        FormData fdRegEx = new FormData();
        fdRegEx.left = new FormAttachment((Control)this.wCaseSensitive, margin * 2);
        fdRegEx.top = new FormAttachment((Control)lastControl, margin);
        this.wRegEx.setLayoutData((Object)fdRegEx);
        lastControl = this.wCaseSensitive;
        this.wSearchString = new Combo(this.composite, 2052);
        PropsUi.setLook((Widget)this.wSearchString);
        this.wSearchString.setFont(GuiResource.getInstance().getFontBold());
        FormData fdSearchString = new FormData();
        fdSearchString.left = new FormAttachment(0, 0);
        fdSearchString.top = new FormAttachment((Control)lastControl, margin);
        fdSearchString.right = new FormAttachment(50, 0);
        this.wSearchString.setLayoutData((Object)fdSearchString);
        this.wSearchString.addListener(14, this::search);
        lastControl = this.wSearchString;
        Button wbSearch = new Button(this.composite, 8);
        PropsUi.setLook((Widget)wbSearch);
        wbSearch.setText(BaseMessages.getString(PKG, (String)"HopSearchPerspective.Search.Button.Label", (String[])new String[0]));
        FormData fdbSearch = new FormData();
        fdbSearch.left = new FormAttachment(0, 0);
        fdbSearch.top = new FormAttachment((Control)lastControl, margin);
        wbSearch.setLayoutData((Object)fdbSearch);
        wbSearch.addListener(13, this::search);
        lastControl = wbSearch;
        this.wSearchString.addListener(24, e -> wbSearch.setEnabled(!Utils.isEmpty((CharSequence)this.wSearchString.getText())));
        Button wbOpen = new Button(this.composite, 8);
        PropsUi.setLook((Widget)wbOpen);
        wbOpen.setText(BaseMessages.getString(PKG, (String)"HopSearchPerspective.Open.Button.Label", (String[])new String[0]));
        FormData fdbOpen = new FormData();
        fdbOpen.left = new FormAttachment(50, 0);
        fdbOpen.bottom = new FormAttachment(100, -margin);
        wbOpen.setLayoutData((Object)fdbOpen);
        wbOpen.addListener(13, this::open);
        wbOpen.setEnabled(false);
        ColumnInfo[] resultsColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"HopSearchPerspective.ResultsTable.Type.Field", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"HopSearchPerspective.ResultsTable.Name.Field", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"HopSearchPerspective.ResultsTable.File.Field", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"HopSearchPerspective.ResultsTable.Location.Field", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"HopSearchPerspective.ResultsTable.MatchText.Field", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"HopSearchPerspective.ResultsTable.Value.Field", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"HopSearchPerspective.ResultsTable.Description.Field", (String[])new String[0]), 1, false, true)};
        this.wResults = new TableView(hopGui.getVariables(), this.composite, 514, resultsColumns, 0, null, props);
        PropsUi.setLook((Widget)this.wResults);
        this.wResults.setReadonly(true);
        FormData fdResults = new FormData();
        fdResults.left = new FormAttachment(0, 0);
        fdResults.right = new FormAttachment(100, 0);
        fdResults.top = new FormAttachment((Control)lastControl, margin);
        fdResults.bottom = new FormAttachment((Control)wbOpen, -2 * margin);
        this.wResults.setLayoutData(fdResults);
        this.wResults.table.addListener(13, e -> wbOpen.setEnabled(this.wResults.getSelectionIndices().length == 1));
        this.wResults.table.addListener(14, this::open);
    }

    private void open(Event event) {
        int index = this.wResults.getSelectionIndex();
        if (index < 0) {
            return;
        }
        TableItem tableItem = this.wResults.table.getSelection()[0];
        int itemNr = Const.toInt((String)tableItem.getText(0), (int)-1);
        if (itemNr <= 0) {
            return;
        }
        ISearchResult searchResult = this.allSearchResults.get(itemNr - 1);
        ISearchable searchable = searchResult.getMatchingSearchable();
        try {
            searchable.getSearchCallback().callback(searchable, searchResult);
        }
        catch (Exception e) {
            new ErrorDialog(this.hopGui.getActiveShell(), "Error", "Error opening " + searchable.getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void search(Event event) {
        if (Utils.isEmpty((CharSequence)this.wSearchString.getText())) {
            return;
        }
        boolean caseSensitive = this.wCaseSensitive.getSelection();
        boolean regularExpression = this.wRegEx.getSelection();
        SearchQuery searchQuery = new SearchQuery(this.wSearchString.getText(), caseSensitive, regularExpression);
        this.wResults.table.removeAll();
        this.allSearchResults = new ArrayList<ISearchResult>();
        try {
            HashMap<Class, ISearchableAnalyser> searchableAnalyserMap = new HashMap<Class, ISearchableAnalyser>();
            PluginRegistry registry = PluginRegistry.getInstance();
            for (IPlugin analyserPlugin : registry.getPlugins(SearchableAnalyserPluginType.class)) {
                ISearchableAnalyser searchableAnalyser = (ISearchableAnalyser)registry.loadClass(analyserPlugin);
                searchableAnalyserMap.put(searchableAnalyser.getSearchableClass(), searchableAnalyser);
            }
            ISearchablesLocation searchablesLocation = this.getSelectedSearchLocation();
            if (searchablesLocation == null) {
                return;
            }
            AuditManagerGuiUtil.addLastUsedValue(AUDIT_TYPE_SEARCH_LOCATION, searchablesLocation.getLocationDescription());
            AuditManagerGuiUtil.addLastUsedValue(AUDIT_TYPE_SEARCH_STRING, this.wSearchString.getText());
            Iterator iterator = searchablesLocation.getSearchables((IHopMetadataProvider)this.hopGui.getMetadataProvider(), this.hopGui.getVariables());
            while (iterator.hasNext()) {
                ISearchableAnalyser searchableAnalyser;
                ISearchable searchable = (ISearchable)iterator.next();
                Object object = searchable.getSearchableObject();
                if (object == null || (searchableAnalyser = (ISearchableAnalyser)searchableAnalyserMap.get(object.getClass())) == null) continue;
                List searchResults = searchableAnalyser.search(searchable, (ISearchQuery)searchQuery);
                this.addSearchResults(searchResults);
            }
            this.wResults.removeEmptyRows();
            this.wResults.setRowNums();
            this.wResults.optWidth(true);
        }
        catch (Exception e) {
            new ErrorDialog(this.hopGui.getActiveShell(), "Error", "Error searching", e);
        }
        finally {
            this.refreshLastUsedLocation();
            this.refreshLastUsedSearchStrings();
        }
    }

    private ISearchablesLocation getSelectedSearchLocation() {
        String locationDescription = this.wLocations.getText();
        for (ISearchablesLocation searchablesLocation : this.searchablesLocations) {
            if (!searchablesLocation.getLocationDescription().equalsIgnoreCase(locationDescription)) continue;
            return searchablesLocation;
        }
        return null;
    }

    private void addSearchResults(List<ISearchResult> searchResults) {
        for (ISearchResult searchResult : searchResults) {
            ISearchable searchable = searchResult.getMatchingSearchable();
            TableItem item = new TableItem(this.wResults.table, 0);
            int c = 1;
            item.setText(c++, Const.NVL((String)searchable.getType(), (String)""));
            item.setText(c++, Const.NVL((String)searchable.getName(), (String)""));
            item.setText(c++, Const.NVL((String)searchable.getFilename(), (String)""));
            item.setText(c++, Const.NVL((String)searchable.getLocation(), (String)""));
            item.setText(c++, Const.NVL((String)searchResult.getMatchingString(), (String)""));
            item.setText(c++, Const.NVL((String)searchResult.getValue(), (String)""));
            item.setText(c++, Const.NVL((String)searchResult.getDescription(), (String)""));
            this.allSearchResults.add(searchResult);
        }
    }

    @Override
    public boolean remove(IHopFileTypeHandler typeHandler) {
        return false;
    }

    @Override
    public List<TabItemHandler> getItems() {
        return null;
    }

    @Override
    public void navigateToPreviousFile() {
    }

    @Override
    public void navigateToNextFile() {
    }

    @Override
    public boolean hasNavigationPreviousFile() {
        return false;
    }

    @Override
    public boolean hasNavigationNextFile() {
        return false;
    }

    public HopGui getHopGui() {
        return this.hopGui;
    }

    public void setHopGui(HopGui hopGui) {
        this.hopGui = hopGui;
    }

    @Override
    public Control getControl() {
        return this.composite;
    }

    @Override
    public List<IGuiContextHandler> getContextHandlers() {
        return new ArrayList<IGuiContextHandler>();
    }

    @Override
    public List<ISearchable> getSearchables() {
        return new ArrayList<ISearchable>();
    }
}

