/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server;

import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.common.Time;
import org.slf4j.Logger;

public class RateLogger {
    private final Logger LOG;
    private String msg = null;
    private long timestamp;
    private int count = 0;

    public RateLogger(Logger log) {
        this.LOG = log;
    }

    public void flush() {
        if (this.msg != null) {
            if (this.count > 1) {
                this.LOG.warn("[" + this.count + " times] " + this.msg);
            } else if (this.count == 1) {
                this.LOG.warn(this.msg);
            }
        }
        this.msg = null;
        this.count = 0;
    }

    public void rateLimitLog(String newMsg) {
        long now = Time.currentElapsedTime();
        if (newMsg.equals(this.msg)) {
            ++this.count;
            if (now - this.timestamp >= 100L) {
                this.flush();
                this.msg = newMsg;
                this.timestamp = now;
            }
        } else {
            this.flush();
            this.msg = newMsg;
            this.timestamp = now;
            this.LOG.warn(this.msg);
        }
    }
}

