/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.job.AbstractJobVertexHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.FlameGraphTypeQueryParameter;
import org.apache.flink.runtime.rest.messages.JobIDPathParameter;
import org.apache.flink.runtime.rest.messages.JobVertexFlameGraphHeaders;
import org.apache.flink.runtime.rest.messages.JobVertexFlameGraphParameters;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.runtime.webmonitor.threadinfo.JobVertexFlameGraph;
import org.apache.flink.runtime.webmonitor.threadinfo.JobVertexFlameGraphFactory;
import org.apache.flink.runtime.webmonitor.threadinfo.JobVertexThreadInfoStats;
import org.apache.flink.runtime.webmonitor.threadinfo.JobVertexThreadInfoTracker;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;

public class JobVertexFlameGraphHandler
extends AbstractJobVertexHandler<JobVertexFlameGraph, JobVertexFlameGraphParameters> {
    private final JobVertexThreadInfoTracker<JobVertexThreadInfoStats> threadInfoOperatorTracker;

    public JobVertexFlameGraphHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, ExecutionGraphCache executionGraphCache, Executor executor, JobVertexThreadInfoTracker<JobVertexThreadInfoStats> threadInfoOperatorTracker) {
        super(leaderRetriever, timeout, responseHeaders, JobVertexFlameGraphHeaders.getInstance(), executionGraphCache, executor);
        this.threadInfoOperatorTracker = threadInfoOperatorTracker;
    }

    @Override
    protected JobVertexFlameGraph handleRequest(HandlerRequest<EmptyRequestBody> request, AccessExecutionJobVertex jobVertex) throws RestHandlerException {
        Optional<JobVertexFlameGraph> operatorFlameGraph;
        if (jobVertex.getAggregateState().isTerminal()) {
            return JobVertexFlameGraph.terminated();
        }
        Optional<JobVertexThreadInfoStats> threadInfoSample = this.threadInfoOperatorTracker.getVertexStats((JobID)request.getPathParameter(JobIDPathParameter.class), jobVertex);
        FlameGraphTypeQueryParameter.Type flameGraphType = JobVertexFlameGraphHandler.getFlameGraphType(request);
        switch (flameGraphType) {
            case FULL: {
                operatorFlameGraph = threadInfoSample.map(JobVertexFlameGraphFactory::createFullFlameGraphFrom);
                break;
            }
            case ON_CPU: {
                operatorFlameGraph = threadInfoSample.map(JobVertexFlameGraphFactory::createOnCpuFlameGraph);
                break;
            }
            case OFF_CPU: {
                operatorFlameGraph = threadInfoSample.map(JobVertexFlameGraphFactory::createOffCpuFlameGraph);
                break;
            }
            default: {
                throw new RestHandlerException("Unknown Flame Graph type " + (Object)((Object)flameGraphType) + '.', HttpResponseStatus.BAD_REQUEST);
            }
        }
        return operatorFlameGraph.orElse(JobVertexFlameGraph.waiting());
    }

    private static FlameGraphTypeQueryParameter.Type getFlameGraphType(HandlerRequest<?> request) {
        List flameGraphTypeParameter = request.getQueryParameter(FlameGraphTypeQueryParameter.class);
        if (flameGraphTypeParameter.isEmpty()) {
            return FlameGraphTypeQueryParameter.Type.FULL;
        }
        return (FlameGraphTypeQueryParameter.Type)((Object)flameGraphTypeParameter.get(0));
    }

    public void close() throws Exception {
        this.threadInfoOperatorTracker.shutDown();
    }

    public static AbstractRestHandler<?, ?, ?, ?> disabledHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders) {
        return new DisabledJobVertexFlameGraphHandler(leaderRetriever, timeout, responseHeaders);
    }

    private static class DisabledJobVertexFlameGraphHandler
    extends AbstractRestHandler<RestfulGateway, EmptyRequestBody, JobVertexFlameGraph, JobVertexFlameGraphParameters> {
        protected DisabledJobVertexFlameGraphHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders) {
            super(leaderRetriever, timeout, responseHeaders, JobVertexFlameGraphHeaders.getInstance());
        }

        @Override
        protected CompletableFuture<JobVertexFlameGraph> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody> request, @Nonnull RestfulGateway gateway) throws RestHandlerException {
            return CompletableFuture.completedFuture(JobVertexFlameGraph.disabled());
        }
    }
}

