/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.Printer;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.AbstractVAction;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VActionContext;
import com.ibm.as400.vaccess.VObject;

class PrinterReleaseAction
extends AbstractVAction {
    static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String displayName_ = ResourceLoader.getText("ACTION_RELEASE");
    private Printer printer_ = null;

    public PrinterReleaseAction(VObject object, Printer printer) {
        super(object);
        this.printer_ = printer;
    }

    @Override
    public String getText() {
        return displayName_;
    }

    @Override
    public void perform(VActionContext context) {
        try {
            this.fireStartWorking();
            String status_ = this.printer_.getStringAttribute(121).trim();
            if (status_ == null || status_.equals("")) {
                if (Trace.isTraceOn()) {
                    Trace.log(2, "ERROR No writer for [" + this.printer_.getName() + "].");
                }
                Exception e = new Exception(ResourceLoader.getText("EXC_AS400_ERROR"));
                this.fireError(e);
            } else {
                CommandCall cmd = new CommandCall(this.printer_.getSystem());
                String cmdString = "RLSWTR WTR(" + this.printer_.getName() + ")";
                try {
                    if (!cmd.run(cmdString)) {
                        if (Trace.isTraceOn()) {
                            Trace.log(2, "ERROR RLSWTR cmd for [" + this.printer_.getName() + "].");
                        }
                        Exception e = new Exception(ResourceLoader.getText("EXC_AS400_ERROR"));
                        this.fireError(e);
                    } else {
                        if (Trace.isTraceOn()) {
                            Trace.log(3, "Released printer [" + this.printer_.getName() + "].");
                        }
                        this.fireObjectChanged();
                    }
                    if (Trace.isTraceOn()) {
                        AS400Message[] messagelist = cmd.getMessageList();
                        for (int i = 0; i < messagelist.length; ++i) {
                            Trace.log(3, messagelist[i].getText());
                        }
                    }
                }
                catch (Exception e) {
                    if (Trace.isTraceOn()) {
                        Trace.log(2, "ERROR CommandCall exception for [" + this.printer_.getName() + "].");
                    }
                    this.fireError(e);
                }
            }
            this.fireStopWorking();
        }
        catch (Exception e) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "ERROR releasing printer [" + this.printer_.getName() + "].");
            }
            this.fireError(e);
        }
    }
}

