/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.vaccess.DBCellRenderer;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;

class DBDateCellRenderer
extends DBCellRenderer {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static DateFormat dateFormat_ = DateFormat.getDateInstance();
    private static DateFormat timeFormat_ = DateFormat.getTimeInstance();
    private static DateFormat timestampFormat_ = DateFormat.getDateTimeInstance();
    public static final int FORMAT_TIME = 1;
    public static final int FORMAT_TIMESTAMP = 2;
    public static final int FORMAT_DATE = 3;
    private int type_;

    public DBDateCellRenderer(int type) {
        this.type_ = type;
    }

    public static int getDisplaySize(int type) {
        Date sample = new Date();
        switch (type) {
            case 3: {
                return dateFormat_.format(sample).length();
            }
            case 1: {
                return timeFormat_.format(sample).length();
            }
        }
        return timestampFormat_.format(sample).length();
    }

    @Override
    public String getText(Object value) {
        if (value instanceof Date) {
            switch (this.type_) {
                case 3: {
                    return dateFormat_.format((Date)value);
                }
                case 1: {
                    return timeFormat_.format((Date)value);
                }
            }
            return timestampFormat_.format((Date)value);
        }
        if (value != null) {
            return value.toString();
        }
        return "-";
    }

    static {
        dateFormat_.setTimeZone(TimeZone.getDefault());
        timeFormat_.setTimeZone(TimeZone.getDefault());
        timestampFormat_.setTimeZone(TimeZone.getDefault());
    }
}

