/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.Trace;
import java.io.CharConversionException;

public class ConvTableUnicodeBigMap
extends ConvTable {
    ConvTableUnicodeBigMap(int ccsid) {
        super(ccsid);
    }

    @Override
    public final String byteArrayToString(byte[] buf, int offset, int length, int type) {
        return this.byteArrayToString(buf, offset, length);
    }

    @Override
    final String byteArrayToString(byte[] buf, int offset, int length, BidiConversionProperties properties) {
        return this.byteArrayToString(buf, offset, length);
    }

    @Override
    public final String byteArrayToString(byte[] buf, int offset, int length) {
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting byte array to string for ccsid: " + this.ccsid_, buf, offset, length);
        }
        char[] dest = new char[length / 2];
        int bufPos = offset;
        for (int destPos = 0; destPos < dest.length; ++destPos) {
            dest[destPos] = (char)(((buf[bufPos++] & 0xFF) << 8) + (buf[bufPos++] & 0xFF));
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination string for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(dest));
        }
        return String.copyValueOf(dest);
    }

    @Override
    public final byte[] stringToByteArray(String source, int type) {
        char[] src = source.toCharArray();
        return this.stringToByteArray(src, 0, src.length);
    }

    @Override
    final byte[] stringToByteArray(String source, BidiConversionProperties properties) {
        char[] src = source.toCharArray();
        return this.stringToByteArray(src, 0, src.length);
    }

    @Override
    public final byte[] stringToByteArray(char[] src, int offset, int length) {
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting string to byte array for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(src, offset, length));
        }
        byte[] dest = new byte[length * 2];
        int destPos = 0;
        for (int srcPos = offset; srcPos < length; ++srcPos) {
            dest[destPos++] = (byte)(src[srcPos] >>> 8);
            dest[destPos++] = (byte)src[srcPos];
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination byte array for ccsid: " + this.ccsid_, dest);
        }
        return dest;
    }

    @Override
    public final void stringToByteArray(String source, byte[] buf, int offset) throws CharConversionException {
        this.charArrayToByteArray(source.toCharArray(), buf, offset);
    }

    @Override
    public final void stringToByteArray(String source, byte[] buf, int offset, int length) throws CharConversionException {
        this.charArrayToByteArray(source.toCharArray(), buf, offset, length);
    }

    @Override
    public final void stringToByteArray(String source, byte[] buf, int offset, int length, int type) throws CharConversionException {
        this.stringToByteArray(source, buf, offset, length);
    }

    @Override
    public final int stringToByteArray(String source, byte[] buf, int offset, int length, BidiConversionProperties properties) throws CharConversionException {
        this.stringToByteArray(source, buf, offset, length);
        return 0;
    }

    @Override
    public final char[] byteArrayToCharArray(byte[] buf, int offset, int length, int type) {
        return this.byteArrayToCharArray(buf, offset, length);
    }

    @Override
    final char[] byteArrayToCharArray(byte[] buf, int offset, int length, BidiConversionProperties properties) {
        return this.byteArrayToCharArray(buf, offset, length);
    }

    @Override
    public final char[] byteArrayToCharArray(byte[] buf, int offset, int length) {
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting byte array to string for ccsid: " + this.ccsid_, buf, offset, length);
        }
        char[] dest = new char[length / 2];
        int bufPos = offset;
        for (int destPos = 0; destPos < dest.length; ++destPos) {
            dest[destPos] = (char)(((buf[bufPos++] & 0xFF) << 8) + (buf[bufPos++] & 0xFF));
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination string for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(dest));
        }
        return dest;
    }

    @Override
    public final byte[] charArrayToByteArray(char[] src, int type) {
        return this.stringToByteArray(src, 0, src.length);
    }

    @Override
    final byte[] charArrayToByteArray(char[] src, BidiConversionProperties properties) {
        return this.stringToByteArray(src, 0, src.length);
    }

    @Override
    public final void charArrayToByteArray(char[] src, byte[] buf, int offset) throws CharConversionException {
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting string to byte array for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(src));
        }
        try {
            int bufPos = offset;
            for (int srcPos = 0; srcPos < src.length; ++srcPos) {
                buf[bufPos++] = (byte)(src[srcPos] >>> 8);
                buf[bufPos++] = (byte)src[srcPos];
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Trace.log(2, "Source length: " + src.length + "; Source offset: 0; Destination length: " + buf.length + "; Destination offset: " + offset + ";", (Throwable)e);
            throw new CharConversionException();
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination byte array for ccsid: " + this.ccsid_, buf, offset, src.length * 2);
        }
    }

    @Override
    public final void charArrayToByteArray(char[] src, byte[] buf, int offset, int length) throws CharConversionException {
        int copyLength = Math.min(src.length, length / 2);
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting string to byte array for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(src, 0, copyLength));
        }
        try {
            int bufPos = offset;
            for (int srcPos = 0; srcPos < copyLength; ++srcPos) {
                buf[bufPos++] = (byte)(src[srcPos] >>> 8);
                buf[bufPos++] = (byte)src[srcPos];
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Trace.log(5, "Source length: " + src.length + "; Source offset: 0; Destination length: " + buf.length + "; Destination offset: " + offset + "; Number of bytes to copy: " + length, (Throwable)e);
            throw new CharConversionException();
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination byte array for ccsid: " + this.ccsid_, buf, offset, copyLength * 2);
        }
    }

    @Override
    public final void charArrayToByteArray(char[] source, byte[] buf, int offset, int length, int type) throws CharConversionException {
        this.charArrayToByteArray(source, buf, offset, length);
    }

    @Override
    public final int charArrayToByteArray(char[] source, byte[] buf, int offset, int length, BidiConversionProperties properties) throws CharConversionException {
        this.charArrayToByteArray(source, buf, offset, length);
        return 0;
    }
}

