/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.workflow;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.workflow.HopWorkflowFileType;
import org.apache.hop.ui.util.SwtSvgImageUtil;
import org.apache.hop.ui.workflow.actions.ActionBaseDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.workflow.ActionWorkflow;
import org.apache.hop.workflow.config.WorkflowRunConfiguration;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class ActionWorkflowDialog
extends ActionBaseDialog {
    private static final Class<?> PKG = ActionWorkflow.class;
    private ActionWorkflow action;
    private MetaSelectionLine<WorkflowRunConfiguration> wRunConfiguration;
    private static final String[] FILE_FILTERLOGNAMES = new String[]{BaseMessages.getString(PKG, (String)"ActionWorkflow.Fileformat.TXT", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionWorkflow.Fileformat.LOG", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionWorkflow.Fileformat.All", (String[])new String[0])};

    public ActionWorkflowDialog(Shell parent, ActionWorkflow action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, (IAction)action, workflowMeta, variables);
        this.action = action;
    }

    public IAction open() {
        Shell parent = this.getParent();
        this.display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        this.backupChanged = this.action.hasChanged();
        this.createElements();
        this.getData();
        this.setActive();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    protected void createElements() {
        super.createElements();
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionWorkflow.Header", (String[])new String[0]));
        this.wlPath.setText(BaseMessages.getString(PKG, (String)"ActionWorkflow.WorkflowFile.Label", (String[])new String[0]));
        this.wPassParams.setText(BaseMessages.getString(PKG, (String)"ActionWorkflow.PassAllParameters.Label", (String[])new String[0]));
        this.wWaitingToFinish = new Button((Composite)this.gExecution, 32);
        PropsUi.setLook((Widget)this.wWaitingToFinish);
        this.wWaitingToFinish.setText(BaseMessages.getString(PKG, (String)"ActionWorkflow.WaitToFinish.Label", (String[])new String[0]));
        FormData fdWait = new FormData();
        fdWait.top = new FormAttachment((Control)this.wEveryRow, 10);
        fdWait.left = new FormAttachment(0, 0);
        this.wWaitingToFinish.setLayoutData((Object)fdWait);
        this.wbGetParams.addListener(13, e -> this.getParameters(null));
        this.wbBrowse.addListener(13, e -> this.pickFileVFS());
        this.wbLogFilename.addListener(13, e -> this.selectLogFile(FILE_FILTERLOGNAMES));
    }

    protected ActionBase getAction() {
        return this.action;
    }

    protected Image getImage() {
        return SwtSvgImageUtil.getImage((Display)this.shell.getDisplay(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"ui/images/workflow.svg", (int)48, (int)48);
    }

    protected int getParameterCount() {
        return this.action.getParameterDefinition().getParameters().size();
    }

    protected void getParameters(WorkflowMeta inputWorkflowMeta) {
        try {
            if (inputWorkflowMeta == null) {
                ActionWorkflow jej = new ActionWorkflow();
                this.getInfo(jej);
                inputWorkflowMeta = jej.getWorkflowMeta(this.getMetadataProvider(), this.variables);
            }
            String[] parameters = inputWorkflowMeta.listParameters();
            String[] existing = this.wParameters.getItems(1);
            for (int i = 0; i < parameters.length; ++i) {
                if (Const.indexOfString((String)parameters[i], (String[])existing) >= 0) continue;
                TableItem item = new TableItem(this.wParameters.table, 0);
                item.setText(1, parameters[i]);
            }
            this.wParameters.removeEmptyRows();
            this.wParameters.setRowNums();
            this.wParameters.optWidth(true);
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"ActionWorkflowDialog.Exception.UnableToLoadWorkflow.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionWorkflowDialog.Exception.UnableToLoadWorkflow.Message", (String[])new String[0]), e);
        }
    }

    protected Control createRunConfigurationControl() {
        this.wRunConfiguration = new MetaSelectionLine(this.variables, this.metadataProvider, WorkflowRunConfiguration.class, (Composite)this.shell, 2048, null, null, true);
        return this.wRunConfiguration;
    }

    protected void pickFileVFS() {
        HopWorkflowFileType workflowFileType = new HopWorkflowFileType();
        String filename = BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wPath, (IVariables)this.variables, (String[])workflowFileType.getFilterExtensions(), (String[])workflowFileType.getFilterNames(), (boolean)true);
        if (filename != null) {
            this.replaceNameWithBaseFilename(filename);
        }
    }

    public void setActive() {
        super.setActive();
    }

    public void getData() {
        this.wName.setText(Const.NVL((String)this.action.getName(), (String)""));
        this.wPath.setText(Const.NVL((String)this.action.getFilename(), (String)""));
        ActionWorkflow.ParameterDefinition parameterDefinition = this.action.getParameterDefinition();
        if (this.action.getParameterDefinition() != null) {
            for (int i = 0; i < parameterDefinition.getParameters().size(); ++i) {
                ActionWorkflow.Parameter parameter = parameterDefinition.getParameters().get(i);
                TableItem item = this.wParameters.getTable().getItem(i);
                if (Utils.isEmpty((CharSequence)parameter.getName())) continue;
                item.setText(1, Const.NVL((String)parameter.getName(), (String)""));
                item.setText(2, Const.NVL((String)parameter.getField(), (String)""));
                item.setText(3, Const.NVL((String)parameter.getValue(), (String)""));
            }
            this.wParameters.setRowNums();
            this.wParameters.optWidth(true);
        }
        this.wPassParams.setSelection(parameterDefinition.isPassingAllParameters());
        this.wPrevToParams.setSelection(this.action.isParamsFromPrevious());
        this.wEveryRow.setSelection(this.action.isExecPerRow());
        this.wSetLogfile.setSelection(this.action.isSetLogfile());
        if (this.action.getLogfile() != null) {
            this.wLogfile.setText(this.action.getLogfile());
        }
        if (this.action.getLogext() != null) {
            this.wLogext.setText(this.action.getLogext());
        }
        this.wAddDate.setSelection(this.action.isAddDate());
        this.wAddTime.setSelection(this.action.isAddTime());
        if (this.action.getLogFileLevel() != null) {
            this.wLoglevel.select(this.action.getLogFileLevel().getLevel());
        } else {
            this.wLoglevel.select(ActionWorkflow.DEFAULT_LOG_LEVEL.getLevel());
        }
        this.wAppendLogfile.setSelection(this.action.isSetAppendLogfile());
        this.wCreateParentFolder.setSelection(this.action.isCreateParentFolder());
        this.wWaitingToFinish.setSelection(this.action.isWaitingToFinish());
        try {
            List runConfigurations = this.getMetadataProvider().getSerializer(WorkflowRunConfiguration.class).listObjectNames();
            try {
                ExtensionPointHandler.callExtensionPoint((ILogChannel)HopGui.getInstance().getLog(), (IVariables)this.variables, (String)HopExtensionPoint.HopGuiRunConfiguration.id, (Object)new Object[]{runConfigurations, "workflow"});
            }
            catch (HopException hopException) {
                // empty catch block
            }
            this.wRunConfiguration.setItems(runConfigurations.toArray(new String[0]));
            if (Utils.isEmpty((CharSequence)this.action.getRunConfiguration())) {
                this.wRunConfiguration.select(0);
            } else {
                this.wRunConfiguration.setText(this.action.getRunConfiguration());
            }
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error getting workflow run configurations", (Throwable)e);
        }
        this.setLogFileEnabled();
        this.wName.selectAll();
        this.wName.setFocus();
    }

    protected void cancel() {
        this.action.setChanged(this.backupChanged);
        this.action = null;
        this.dispose();
    }

    @VisibleForTesting
    protected void getInfo(ActionWorkflow action) {
        action.setName(this.wName.getText());
        action.setFileName(this.wPath.getText());
        action.setRunConfiguration(this.wRunConfiguration.getText());
        ActionWorkflow.ParameterDefinition parameterDefinition = action.getParameterDefinition();
        parameterDefinition.getParameters().clear();
        int nrItems = this.wParameters.nrNonEmpty();
        for (int i = 0; i < nrItems; ++i) {
            TableItem item = this.wParameters.getNonEmpty(i);
            ActionWorkflow.Parameter parameter = new ActionWorkflow.Parameter();
            parameter.setName(item.getText(1));
            String fieldName = Const.trim((String)item.getText(2));
            if (!Utils.isEmpty((CharSequence)fieldName)) {
                parameter.setField(fieldName);
            } else {
                parameter.setField("");
            }
            String value = Const.trim((String)item.getText(3));
            if (!Utils.isEmpty((CharSequence)value)) {
                parameter.setValue(value);
            } else {
                parameter.setValue("");
            }
            parameterDefinition.getParameters().add(parameter);
        }
        parameterDefinition.setPassingAllParameters(this.wPassParams.getSelection());
        action.setSetLogfile(this.wSetLogfile.getSelection());
        action.setAddDate(this.wAddDate.getSelection());
        action.setAddTime(this.wAddTime.getSelection());
        action.setLogfile(this.wLogfile.getText());
        action.setLogext(this.wLogext.getText());
        action.setLogFileLevel(LogLevel.lookupDescription((String)this.wLoglevel.getText()));
        action.setParamsFromPrevious(this.wPrevToParams.getSelection());
        action.setExecPerRow(this.wEveryRow.getSelection());
        action.setSetAppendLogfile(this.wAppendLogfile.getSelection());
        action.setWaitingToFinish(this.wWaitingToFinish.getSelection());
        action.setCreateParentFolder(this.wCreateParentFolder.getSelection());
        action.setRunConfiguration(this.wRunConfiguration.getText());
    }

    public void ok() {
        if (Utils.isEmpty((CharSequence)this.getName())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        if (Utils.isEmpty((CharSequence)this.wPath.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"ActionWorkflowDialog.FilenameMissing.Header", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"ActionWorkflowDialog.FilenameMissing.Message", (String[])new String[0]));
            mb.open();
            return;
        }
        if (this.isSelfReferencing()) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"ActionWorkflowDialog.SelfReference.Header", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"ActionWorkflowDialog.SelfReference.Message", (String[])new String[0]));
            mb.open();
            return;
        }
        this.getInfo(this.action);
        this.action.setChanged();
        this.dispose();
    }

    @VisibleForTesting
    protected String getName() {
        return this.wName.getText();
    }

    @VisibleForTesting
    protected String getPath() {
        return this.wPath.getText();
    }

    private boolean isSelfReferencing() {
        return this.variables.resolve(this.wPath.getText()).equals(this.variables.resolve(this.workflowMeta.getFilename()));
    }
}

