/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.CyclicMetadataException;
import org.apache.calcite.rel.metadata.Metadata;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.NullSentinel;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.metadata.UnboundMetadata;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.FlatLists;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.ReflectiveVisitor;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ReflectiveRelMetadataProvider
implements RelMetadataProvider,
ReflectiveVisitor {
    @Deprecated
    private final ConcurrentMap<Class<RelNode>, UnboundMetadata> map;
    @Deprecated
    private final Class<? extends Metadata> metadataClass0;
    @Deprecated
    private final ImmutableMultimap<Method, MetadataHandler> handlerMap;
    private final Class<? extends MetadataHandler<?>> handlerClass;
    private final ImmutableList<MetadataHandler<?>> handlers;

    protected ReflectiveRelMetadataProvider(ConcurrentMap<Class<RelNode>, UnboundMetadata> map, Class<? extends Metadata> metadataClass0, Multimap<Method, MetadataHandler<?>> handlerMap, Class<? extends MetadataHandler<?>> handlerClass) {
        Preconditions.checkArgument((!map.isEmpty() ? 1 : 0) != 0, (Object)"ReflectiveRelMetadataProvider methods map is empty; are your methods named wrong?");
        this.map = map;
        this.metadataClass0 = metadataClass0;
        this.handlerMap = ImmutableMultimap.copyOf(handlerMap);
        this.handlerClass = handlerClass;
        this.handlers = ImmutableList.copyOf((Collection)handlerMap.values());
    }

    @Deprecated
    public static RelMetadataProvider reflectiveSource(Method method, MetadataHandler target) {
        return ReflectiveRelMetadataProvider.reflectiveSource(target, (ImmutableList<Method>)ImmutableList.of((Object)method), target.getDef().handlerClass);
    }

    @Deprecated
    public static RelMetadataProvider reflectiveSource(MetadataHandler target, Method ... methods) {
        return ReflectiveRelMetadataProvider.reflectiveSource(target, (ImmutableList<Method>)ImmutableList.copyOf((Object[])methods), target.getDef().handlerClass);
    }

    public static <M extends Metadata> RelMetadataProvider reflectiveSource(MetadataHandler<? extends M> handler, Class<? extends MetadataHandler<M>> handlerClass) {
        return ReflectiveRelMetadataProvider.reflectiveSource(handler, handler.getDef().methods, handlerClass);
    }

    @Deprecated
    private static RelMetadataProvider reflectiveSource(MetadataHandler target, ImmutableList<Method> methods, Class<? extends MetadataHandler<?>> handlerClass) {
        Space2 space = Space2.create(target, methods);
        ConcurrentHashMap<Class<RelNode>, UnboundMetadata> methodsMap = new ConcurrentHashMap<Class<RelNode>, UnboundMetadata>();
        for (Class key : space.classes) {
            ImmutableNullableList.Builder<Method> builder = ImmutableNullableList.builder();
            for (Method method : methods) {
                builder.add(space.find(key, method));
            }
            List handlerMethods = builder.build();
            UnboundMetadata<Metadata> function = (rel, mq) -> (Metadata)Proxy.newProxyInstance(space.metadataClass0.getClassLoader(), new Class[]{space.metadataClass0}, (proxy, method, args) -> {
                Object args2;
                List<Object> key1;
                Object[] args1;
                if (method.equals(BuiltInMethod.METADATA_REL.method)) {
                    return rel;
                }
                if (method.equals(BuiltInMethod.OBJECT_TO_STRING.method)) {
                    return space.metadataClass0.getSimpleName() + "(" + rel + ")";
                }
                int i = methods.indexOf((Object)method);
                if (i < 0) {
                    throw new AssertionError((Object)("not handled: " + method + " for " + rel));
                }
                Method handlerMethod = (Method)handlerMethods.get(i);
                if (handlerMethod == null) {
                    throw new AssertionError((Object)("not handled: " + method + " for " + rel));
                }
                if (args == null) {
                    args1 = new Object[]{rel, mq};
                    key1 = FlatLists.of(rel, method);
                } else {
                    args1 = new Object[args.length + 2];
                    args1[0] = rel;
                    args1[1] = mq;
                    System.arraycopy(args, 0, args1, 2, args.length);
                    args2 = (Object[])args1.clone();
                    args2[1] = method;
                    for (int j = 0; j < ((Object[])args2).length; ++j) {
                        if (args2[j] == null) {
                            args2[j] = NullSentinel.INSTANCE;
                            continue;
                        }
                        if (!(args2[j] instanceof RexNode)) continue;
                        args2[j] = args2[j].toString();
                    }
                    key1 = FlatLists.copyOf(args2);
                }
                if (mq.map.put((Object)rel, key1, (Object)NullSentinel.INSTANCE) != null) {
                    throw new CyclicMetadataException();
                }
                try {
                    args2 = handlerMethod.invoke((Object)target, args1);
                    return args2;
                }
                catch (InvocationTargetException | UndeclaredThrowableException e) {
                    throw Util.throwAsRuntime(Util.causeOrSelf(e));
                }
                finally {
                    mq.map.remove((Object)rel, key1);
                }
            });
            methodsMap.put(key, function);
        }
        return new ReflectiveRelMetadataProvider((ConcurrentMap<Class<RelNode>, UnboundMetadata>)methodsMap, space.metadataClass0, (Multimap<Method, MetadataHandler<?>>)space.providerMap, handlerClass);
    }

    @Override
    @Deprecated
    public <M extends Metadata> Multimap<Method, MetadataHandler<M>> handlers(MetadataDef<M> def) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (Map.Entry entry : this.handlerMap.entries()) {
            if (!def.methods.contains(entry.getKey())) continue;
            builder.put(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    @Override
    public List<MetadataHandler<?>> handlers(Class<? extends MetadataHandler<?>> handlerClass) {
        if (this.handlerClass.isAssignableFrom(handlerClass)) {
            return this.handlers;
        }
        return ImmutableList.of();
    }

    @Deprecated
    private static boolean couldImplement(Method handlerMethod, Method method) {
        Class<?>[] parameterTypes;
        if (!handlerMethod.getName().equals(method.getName()) || (handlerMethod.getModifiers() & 8) != 0 || (handlerMethod.getModifiers() & 1) == 0) {
            return false;
        }
        Class<?>[] parameterTypes1 = handlerMethod.getParameterTypes();
        return parameterTypes1.length == (parameterTypes = method.getParameterTypes()).length + 2 && RelNode.class.isAssignableFrom(parameterTypes1[0]) && RelMetadataQuery.class == parameterTypes1[1] && Arrays.asList(parameterTypes).equals(Util.skip(Arrays.asList(parameterTypes1), 2));
    }

    @Override
    @Deprecated
    public <M extends Metadata> @Nullable UnboundMetadata<M> apply(Class<? extends RelNode> relClass, Class<? extends M> metadataClass) {
        if (metadataClass == this.metadataClass0) {
            return this.apply(relClass);
        }
        return null;
    }

    @Deprecated
    public <M extends Metadata> @Nullable UnboundMetadata<M> apply(Class<? extends RelNode> relClass) {
        ArrayList<Class<? extends RelNode>> newSources = new ArrayList<Class<? extends RelNode>>();
        while (true) {
            UnboundMetadata function;
            if ((function = (UnboundMetadata)this.map.get(relClass)) != null) {
                for (Class clazz : newSources) {
                    this.map.put(clazz, function);
                }
                return function;
            }
            newSources.add(relClass);
            for (Class<?> interfaceClass : relClass.getInterfaces()) {
                UnboundMetadata function2;
                if (!RelNode.class.isAssignableFrom(interfaceClass) || (function2 = (UnboundMetadata)this.map.get(interfaceClass)) == null) continue;
                for (Class clazz : newSources) {
                    this.map.put(clazz, function2);
                }
                return function2;
            }
            Class<? extends RelNode> superclass = relClass.getSuperclass();
            if (superclass == null || !RelNode.class.isAssignableFrom(superclass)) break;
            relClass = superclass;
        }
        return null;
    }

    @Deprecated
    static class Space2
    extends Space {
        private Class<Metadata> metadataClass0;

        Space2(Class<Metadata> metadataClass0, ImmutableMultimap<Method, MetadataHandler<?>> providerMap) {
            super((Multimap<Method, MetadataHandler<?>>)providerMap);
            this.metadataClass0 = metadataClass0;
        }

        @Deprecated
        public static Space2 create(MetadataHandler<?> target, ImmutableList<Method> methods) {
            assert (methods.size() > 0);
            Method method0 = (Method)methods.get(0);
            Class<Metadata> metadataClass0 = method0.getDeclaringClass();
            assert (Metadata.class.isAssignableFrom(metadataClass0));
            for (Method method : methods) {
                assert (method.getDeclaringClass() == metadataClass0);
            }
            ImmutableMultimap.Builder providerBuilder = ImmutableMultimap.builder();
            for (Method method : methods) {
                providerBuilder.put((Object)method, target);
            }
            return new Space2(metadataClass0, providerBuilder.build());
        }
    }

    @Deprecated
    static class Space {
        final Set<Class<RelNode>> classes = new HashSet<Class<RelNode>>();
        final Map<Pair<Class<RelNode>, Method>, Method> handlerMap = new HashMap<Pair<Class<RelNode>, Method>, Method>();
        final ImmutableMultimap<Method, MetadataHandler<?>> providerMap;

        Space(Multimap<Method, MetadataHandler<?>> providerMap) {
            this.providerMap = ImmutableMultimap.copyOf(providerMap);
            for (Map.Entry entry : providerMap.entries()) {
                Method method = (Method)entry.getKey();
                MetadataHandler provider = (MetadataHandler)entry.getValue();
                for (Method handlerMethod : provider.getClass().getMethods()) {
                    if (!ReflectiveRelMetadataProvider.couldImplement(handlerMethod, method)) continue;
                    Class<?> relNodeClass = handlerMethod.getParameterTypes()[0];
                    this.classes.add(relNodeClass);
                    this.handlerMap.put(Pair.of(relNodeClass, method), handlerMethod);
                }
            }
        }

        Method find(Class<? extends RelNode> relNodeClass, Method method) {
            Objects.requireNonNull(relNodeClass, "relNodeClass");
            Class<? extends RelNode> r = relNodeClass;
            do {
                Method implementingMethod;
                if ((implementingMethod = this.handlerMap.get(Pair.of(r, method))) != null) {
                    return implementingMethod;
                }
                for (Class<?> clazz : r.getInterfaces()) {
                    if (!RelNode.class.isAssignableFrom(clazz) || (implementingMethod = this.handlerMap.get(Pair.of(clazz, method))) == null) continue;
                    return implementingMethod;
                }
            } while ((r = r.getSuperclass()) != null && RelNode.class.isAssignableFrom(r));
            throw new IllegalArgumentException("No handler for method [" + method + "] applied to argument of type [" + relNodeClass + "]; we recommend you create a catch-all (RelNode) handler");
        }
    }
}

