/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlan;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ArrayMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.mapping.MappingHelper;
import org.datanucleus.store.rdbms.mapping.MappingType;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedPCMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.query.StatementClassMapping;
import org.datanucleus.store.rdbms.scostore.AbstractArrayStore;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.ElementIteratorStatement;
import org.datanucleus.store.rdbms.sql.DiscriminatorStatementGenerator;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.UnionStatementGenerator;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class FKArrayStore<E>
extends AbstractArrayStore<E> {
    private String clearNullifyStmt;
    private String updateFkStmt;

    public FKArrayStore(AbstractMemberMetaData mmd, RDBMSStoreManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr, clr);
        this.setOwner(mmd);
        ArrayMetaData arrmd = mmd.getArray();
        if (arrmd == null) {
            throw new NucleusUserException(Localiser.msg((String)"056000", (Object[])new Object[]{mmd.getFullFieldName()}));
        }
        this.elementType = mmd.getType().getComponentType().getName();
        Class element_class = clr.classForName(this.elementType);
        if (ClassUtils.isReferenceType((Class)element_class)) {
            this.elementIsPersistentInterface = storeMgr.getNucleusContext().getMetaDataManager().isPersistentInterface(element_class.getName());
            this.elementCmd = this.elementIsPersistentInterface ? storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForInterface(element_class, clr) : storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForImplementationOfReference(element_class, null, clr);
        } else {
            this.elementCmd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(element_class, clr);
        }
        if (this.elementCmd == null) {
            throw new NucleusUserException(Localiser.msg((String)"056003", (Object[])new Object[]{element_class.getName(), mmd.getFullFieldName()}));
        }
        this.elementInfo = this.getComponentInformationForClass(this.elementType, this.elementCmd);
        if (this.elementInfo == null || this.elementInfo.length == 0) {
            throw new NucleusUserException(Localiser.msg((String)"056075", (Object[])new Object[]{this.ownerMemberMetaData.getFullFieldName(), this.elementType}));
        }
        if (this.elementInfo.length > 1) {
            throw new NucleusUserException(Localiser.msg((String)"056045", (Object[])new Object[]{this.ownerMemberMetaData.getFullFieldName()}));
        }
        this.elementMapping = this.elementInfo[0].getDatastoreClass().getIdMapping();
        this.elementsAreEmbedded = false;
        this.elementsAreSerialised = false;
        for (int i = 0; i < this.elementInfo.length; ++i) {
            JavaTypeMapping ownerMapping = null;
            if (mmd.getMappedBy() != null) {
                if (mmd.getMappedBy().indexOf(46) < 0) {
                    AbstractMemberMetaData eofmd;
                    AbstractClassMetaData eoCmd = storeMgr.getMetaDataManager().getMetaDataForClass(element_class, clr);
                    AbstractMemberMetaData abstractMemberMetaData = eofmd = eoCmd != null ? eoCmd.getMetaDataForMember(mmd.getMappedBy()) : null;
                    if (eofmd == null) {
                        throw new NucleusUserException(Localiser.msg((String)"056024", (Object[])new Object[]{mmd.getFullFieldName(), mmd.getMappedBy(), element_class.getName()}));
                    }
                    if (!clr.isAssignableFrom(eofmd.getType(), mmd.getAbstractClassMetaData().getFullClassName())) {
                        throw new NucleusUserException(Localiser.msg((String)"056025", (Object[])new Object[]{mmd.getFullFieldName(), eofmd.getFullFieldName(), eofmd.getTypeName(), mmd.getAbstractClassMetaData().getFullClassName()}));
                    }
                    String ownerFieldName = eofmd.getName();
                    ownerMapping = this.elementInfo[i].getDatastoreClass().getMemberMapping(eofmd);
                    if (ownerMapping == null) {
                        throw new NucleusUserException(Localiser.msg((String)"056046", (Object[])new Object[]{mmd.getAbstractClassMetaData().getFullClassName(), mmd.getName(), this.elementType, ownerFieldName}));
                    }
                    if (this.isEmbeddedMapping(ownerMapping)) {
                        throw new NucleusUserException(Localiser.msg((String)"056026", (Object[])new Object[]{ownerFieldName, this.elementType, eofmd.getTypeName(), mmd.getClassName()}));
                    }
                } else {
                    AbstractMemberMetaData otherMmd = null;
                    AbstractClassMetaData otherCmd = this.elementCmd;
                    String remainingMappedBy = this.ownerMemberMetaData.getMappedBy();
                    JavaTypeMapping otherMapping = null;
                    while (remainingMappedBy.indexOf(46) > 0) {
                        int dotPosition = remainingMappedBy.indexOf(46);
                        String thisMappedBy = remainingMappedBy.substring(0, dotPosition);
                        otherMmd = otherCmd.getMetaDataForMember(thisMappedBy);
                        if (otherMapping == null) {
                            otherMapping = this.elementInfo[i].getDatastoreClass().getMemberMapping(thisMappedBy);
                        } else {
                            if (!(otherMapping instanceof EmbeddedPCMapping)) {
                                throw new NucleusUserException("Processing of mappedBy DOT notation for " + this.ownerMemberMetaData.getFullFieldName() + " found mapping=" + otherMapping + " but expected to be embedded");
                            }
                            otherMapping = ((EmbeddedPCMapping)otherMapping).getJavaTypeMapping(thisMappedBy);
                        }
                        remainingMappedBy = remainingMappedBy.substring(dotPosition + 1);
                        otherCmd = storeMgr.getMetaDataManager().getMetaDataForClass(otherMmd.getTypeName(), clr);
                        if (remainingMappedBy.indexOf(46) >= 0) continue;
                        if (!(otherMapping instanceof EmbeddedPCMapping)) {
                            throw new NucleusUserException("Processing of mappedBy DOT notation for " + this.ownerMemberMetaData.getFullFieldName() + " found mapping=" + otherMapping + " but expected to be embedded");
                        }
                        otherMapping = ((EmbeddedPCMapping)otherMapping).getJavaTypeMapping(remainingMappedBy);
                    }
                    ownerMapping = otherMapping;
                }
            } else {
                ownerMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(mmd, MappingType.EXTERNAL_FK);
                if (ownerMapping == null) {
                    throw new NucleusUserException(Localiser.msg((String)"056047", (Object[])new Object[]{mmd.getAbstractClassMetaData().getFullClassName(), mmd.getName(), this.elementType}));
                }
            }
            this.elementInfo[i].setOwnerMapping(ownerMapping);
        }
        this.ownerMapping = this.elementInfo[0].getOwnerMapping();
        this.orderMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(mmd, MappingType.EXTERNAL_INDEX);
        if (this.orderMapping == null) {
            throw new NucleusUserException(Localiser.msg((String)"056048", (Object[])new Object[]{mmd.getAbstractClassMetaData().getFullClassName(), mmd.getName(), this.elementType}));
        }
        this.relationDiscriminatorMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(mmd, MappingType.EXTERNAL_FK_DISCRIMINATOR);
        if (this.relationDiscriminatorMapping != null) {
            this.relationDiscriminatorValue = mmd.getValueForExtension("relation-discriminator-value");
            if (this.relationDiscriminatorValue == null) {
                this.relationDiscriminatorValue = mmd.getFullFieldName();
            }
        }
        this.containerTable = this.elementInfo[0].getDatastoreClass();
        if (mmd.getMappedBy() != null && this.ownerMapping.getTable() != this.containerTable) {
            this.containerTable = this.ownerMapping.getTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateElementFk(DNStateManager ownerSM, E element, Object owner, int index) {
        boolean retval;
        if (element == null) {
            return false;
        }
        String updateFkStmt = this.getUpdateFkStmt();
        ExecutionContext ec = ownerSM.getExecutionContext();
        try {
            ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, updateFkStmt, false);
                try {
                    int jdbcPosition = 1;
                    if (this.elementInfo.length > 1) {
                        DatastoreClass table = this.storeMgr.getDatastoreClass(element.getClass().getName(), this.clr);
                        if (table != null) {
                            ps.setString(jdbcPosition++, table.toString());
                        } else {
                            NucleusLogger.PERSISTENCE.info((Object)(">> FKArrayStore.updateElementFK : need to set table in statement but dont know table where to store " + element));
                        }
                    }
                    if (owner == null) {
                        this.ownerMapping.setObject(ec, ps, MappingHelper.getMappingIndices(jdbcPosition, this.ownerMapping), null);
                        jdbcPosition += this.ownerMapping.getNumberOfColumnMappings();
                    } else {
                        jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerSM, ec, ps, jdbcPosition, this);
                    }
                    jdbcPosition = BackingStoreHelper.populateOrderInStatement(ec, ps, index, jdbcPosition, this.orderMapping);
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                    }
                    jdbcPosition = BackingStoreHelper.populateElementInStatement(ec, ps, element, jdbcPosition, this.elementMapping);
                    sqlControl.executeStatementUpdate(ec, mconn, updateFkStmt, ps, true);
                    retval = true;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"056027", (Object[])new Object[]{updateFkStmt}), (Throwable)e);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUpdateFkStmt() {
        if (this.updateFkStmt == null) {
            FKArrayStore fKArrayStore = this;
            synchronized (fKArrayStore) {
                int i;
                StringBuilder stmt = new StringBuilder("UPDATE ");
                if (this.elementInfo.length > 1) {
                    stmt.append("?");
                } else {
                    stmt.append(this.elementInfo[0].getDatastoreClass().toString());
                }
                stmt.append(" SET ");
                for (i = 0; i < this.ownerMapping.getNumberOfColumnMappings(); ++i) {
                    if (i > 0) {
                        stmt.append(",");
                    }
                    stmt.append(this.ownerMapping.getColumnMapping(i).getColumn().getIdentifier().toString());
                    stmt.append(" = ");
                    stmt.append(this.ownerMapping.getColumnMapping(i).getUpdateInputParameter());
                }
                for (i = 0; i < this.orderMapping.getNumberOfColumnMappings(); ++i) {
                    stmt.append(",");
                    stmt.append(this.orderMapping.getColumnMapping(i).getColumn().getIdentifier().toString());
                    stmt.append(" = ");
                    stmt.append(this.orderMapping.getColumnMapping(i).getUpdateInputParameter());
                }
                if (this.relationDiscriminatorMapping != null) {
                    for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfColumnMappings(); ++i) {
                        stmt.append(",");
                        stmt.append(this.relationDiscriminatorMapping.getColumnMapping(i).getColumn().getIdentifier().toString());
                        stmt.append(" = ");
                        stmt.append(this.relationDiscriminatorMapping.getColumnMapping(i).getUpdateInputParameter());
                    }
                }
                stmt.append(" WHERE ");
                BackingStoreHelper.appendWhereClauseForMapping(stmt, this.elementMapping, null, true);
                this.updateFkStmt = stmt.toString();
            }
        }
        return this.updateFkStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(DNStateManager ownerSM) {
        boolean deleteElements = false;
        if (this.ownerMemberMetaData.getArray().isDependentElement()) {
            NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"056034"));
            deleteElements = true;
        } else if (this.ownerMapping.isNullable() && this.orderMapping.isNullable()) {
            NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"056036"));
            deleteElements = false;
        } else {
            NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"056035"));
            deleteElements = true;
        }
        if (deleteElements) {
            ownerSM.isLoaded(this.ownerMemberMetaData.getAbsoluteFieldNumber());
            Object[] value = (Object[])ownerSM.provideField(this.ownerMemberMetaData.getAbsoluteFieldNumber());
            if (value != null && value.length > 0) {
                ownerSM.getExecutionContext().deleteObjects(value);
            }
        } else {
            boolean ownerSoftDelete = ownerSM.getClassMetaData().isSoftDelete();
            if (!ownerSoftDelete) {
                String clearNullifyStmt = this.getClearNullifyStmt();
                try {
                    ExecutionContext ec = ownerSM.getExecutionContext();
                    ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
                    SQLController sqlControl = this.storeMgr.getSQLController();
                    try {
                        PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, clearNullifyStmt, false);
                        try {
                            int jdbcPosition = 1;
                            jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerSM, ec, ps, jdbcPosition, this);
                            if (this.relationDiscriminatorMapping != null) {
                                BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                            }
                            sqlControl.executeStatementUpdate(ec, mconn, clearNullifyStmt, ps, true);
                        }
                        finally {
                            sqlControl.closeStatement(mconn, ps);
                        }
                    }
                    finally {
                        mconn.release();
                    }
                }
                catch (SQLException e) {
                    throw new NucleusDataStoreException(Localiser.msg((String)"056013", (Object[])new Object[]{clearNullifyStmt}), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getClearNullifyStmt() {
        if (this.clearNullifyStmt == null) {
            FKArrayStore fKArrayStore = this;
            synchronized (fKArrayStore) {
                int i;
                StringBuilder stmt = new StringBuilder("UPDATE ");
                if (this.elementInfo.length > 1) {
                    stmt.append("?");
                } else {
                    stmt.append(this.elementInfo[0].getDatastoreClass().toString());
                }
                stmt.append(" SET ");
                for (i = 0; i < this.ownerMapping.getNumberOfColumnMappings(); ++i) {
                    if (i > 0) {
                        stmt.append(", ");
                    }
                    stmt.append(this.ownerMapping.getColumnMapping(i).getColumn().getIdentifier().toString() + " = NULL");
                }
                for (i = 0; i < this.orderMapping.getNumberOfColumnMappings(); ++i) {
                    stmt.append(", ");
                    stmt.append(this.orderMapping.getColumnMapping(i).getColumn().getIdentifier().toString() + " = NULL");
                }
                if (this.relationDiscriminatorMapping != null) {
                    for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfColumnMappings(); ++i) {
                        stmt.append(", ");
                        stmt.append(this.relationDiscriminatorMapping.getColumnMapping(i).getColumn().getIdentifier().toString() + " = NULL");
                    }
                }
                stmt.append(" WHERE ");
                BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
                if (this.relationDiscriminatorMapping != null) {
                    BackingStoreHelper.appendWhereClauseForMapping(stmt, this.relationDiscriminatorMapping, null, false);
                }
                this.clearNullifyStmt = stmt.toString();
            }
        }
        return this.clearNullifyStmt;
    }

    @Override
    public boolean set(DNStateManager ownerSM, Object array) {
        if (array == null) {
            return true;
        }
        for (int i = 0; i < Array.getLength(array); ++i) {
            this.validateElementForWriting(ownerSM.getExecutionContext(), Array.get(array, i), null);
        }
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object obj = Array.get(array, i);
            this.updateElementFk(ownerSM, obj, ownerSM.getObject(), i);
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Iterator<E> iterator(DNStateManager ownerSM) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ElementIteratorStatement getIteratorStatement(ExecutionContext ec, FetchPlan fp, boolean addRestrictionOnOwner) {
        SQLStatement sqlStmt = null;
        SQLExpressionFactory exprFactory = this.storeMgr.getSQLExpressionFactory();
        StatementClassMapping elementClsMapping = new StatementClassMapping();
        if (this.elementInfo[0].getDatastoreClass().getDiscriminatorMetaData() != null && this.elementInfo[0].getDatastoreClass().getDiscriminatorMetaData().getStrategy() != DiscriminatorStrategy.NONE) {
            String elementType = this.ownerMemberMetaData.getArray().getElementType();
            if (ClassUtils.isReferenceType((Class)this.clr.classForName(elementType))) {
                String[] clsNames = this.storeMgr.getNucleusContext().getMetaDataManager().getClassesImplementingInterface(elementType, this.clr);
                Class[] cls = new Class[clsNames.length];
                for (int i = 0; i < clsNames.length; ++i) {
                    cls[i] = this.clr.classForName(clsNames[i]);
                }
                sqlStmt = new DiscriminatorStatementGenerator(this.storeMgr, this.clr, cls, true, null, null).getStatement(ec);
            } else {
                sqlStmt = new DiscriminatorStatementGenerator(this.storeMgr, this.clr, this.clr.classForName(this.elementInfo[0].getClassName()), true, null, null).getStatement(ec);
            }
            this.iterateUsingDiscriminator = true;
            SQLStatementHelper.selectFetchPlanOfSourceClassInStatement((SelectStatement)sqlStmt, elementClsMapping, fp, sqlStmt.getPrimaryTable(), this.elementCmd, fp.getMaxFetchDepth());
        } else {
            for (int i = 0; i < this.elementInfo.length; ++i) {
                Class elementCls = this.clr.classForName(this.elementInfo[i].getClassName());
                UnionStatementGenerator stmtGen = new UnionStatementGenerator(this.storeMgr, this.clr, elementCls, true, null, null);
                stmtGen.setOption("selectDnType");
                elementClsMapping.setNucleusTypeColumnName("DN_TYPE");
                SelectStatement subStmt = stmtGen.getStatement(ec);
                if (sqlStmt == null) {
                    if (this.elementInfo.length > 1) {
                        SQLStatementHelper.selectIdentityOfCandidateInStatement(subStmt, elementClsMapping, this.elementInfo[i].getAbstractClassMetaData());
                    } else {
                        SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(subStmt, elementClsMapping, fp, subStmt.getPrimaryTable(), this.elementInfo[i].getAbstractClassMetaData(), fp.getMaxFetchDepth());
                    }
                } else if (this.elementInfo.length > 1) {
                    SQLStatementHelper.selectIdentityOfCandidateInStatement(subStmt, null, this.elementInfo[i].getAbstractClassMetaData());
                } else {
                    SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(subStmt, null, fp, subStmt.getPrimaryTable(), this.elementInfo[i].getAbstractClassMetaData(), fp.getMaxFetchDepth());
                }
                if (sqlStmt == null) {
                    sqlStmt = subStmt;
                    continue;
                }
                ((SelectStatement)sqlStmt).union(subStmt);
            }
        }
        if (sqlStmt == null) {
            throw new NucleusException("Error in generation of SQL statement for iterator over (FK) array. Statement is null");
        }
        if (addRestrictionOnOwner) {
            SQLTable ownerSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.ownerMapping);
            SQLExpression ownerExpr = exprFactory.newExpression(sqlStmt, ownerSqlTbl, this.ownerMapping);
            SQLExpression ownerVal = exprFactory.newLiteralParameter(sqlStmt, this.ownerMapping, null, "OWNER");
            ((SelectStatement)sqlStmt).whereAnd(ownerExpr.eq(ownerVal), true);
        }
        if (this.relationDiscriminatorMapping != null) {
            SQLTable distSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.relationDiscriminatorMapping);
            SQLExpression distExpr = exprFactory.newExpression(sqlStmt, distSqlTbl, this.relationDiscriminatorMapping);
            SQLExpression distVal = exprFactory.newLiteral(sqlStmt, this.relationDiscriminatorMapping, this.relationDiscriminatorValue);
            ((SelectStatement)sqlStmt).whereAnd(distExpr.eq(distVal), true);
        }
        if (this.orderMapping != null) {
            SQLTable orderSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
            SQLExpression[] orderExprs = new SQLExpression[this.orderMapping.getNumberOfColumnMappings()];
            boolean[] descendingOrder = new boolean[this.orderMapping.getNumberOfColumnMappings()];
            orderExprs[0] = exprFactory.newExpression(sqlStmt, orderSqlTbl, this.orderMapping);
            ((SelectStatement)sqlStmt).setOrdering(orderExprs, descendingOrder);
        }
        return new ElementIteratorStatement(this, (SelectStatement)sqlStmt, elementClsMapping);
    }
}

