/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.constraint.drop;

import java.io.Serializable;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Drop Constraint", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class AlterTableDropConstraintDesc
implements DDLDesc.DDLDescWithWriteId,
Serializable {
    private static final long serialVersionUID = 1L;
    private final TableName tableName;
    private final ReplicationSpec replicationSpec;
    private final String constraintName;
    private Long writeId;

    public AlterTableDropConstraintDesc(TableName tableName, ReplicationSpec replicationSpec, String constraintName) throws SemanticException {
        this.tableName = tableName;
        this.replicationSpec = replicationSpec;
        this.constraintName = constraintName;
    }

    public TableName getTableName() {
        return this.tableName;
    }

    @Explain(displayName="table name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getDbTableName() {
        return this.tableName.getNotEmptyDbTable();
    }

    public ReplicationSpec getReplicationSpec() {
        return this.replicationSpec;
    }

    @Explain(displayName="constraint name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getConstraintName() {
        return this.constraintName;
    }

    @Override
    public String getFullTableName() {
        return this.tableName.getNotEmptyDbTable();
    }

    @Override
    public void setWriteId(long writeId) {
        this.writeId = writeId;
    }

    public Long getWriteId() {
        return this.writeId;
    }

    @Override
    public boolean mayNeedWriteId() {
        return true;
    }
}

