/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.NodeUtils;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.StatsTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskRunner;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.StatsWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskQueue {
    private static final Logger LOG = LoggerFactory.getLogger((String)Driver.class.getName());
    private static final SessionState.LogHelper CONSOLE = new SessionState.LogHelper(LOG);
    private static final int SLEEP_TIME = 2000;
    private final Queue<Task<?>> runnable = new ConcurrentLinkedQueue();
    private final List<TaskRunner> running = new ArrayList<TaskRunner>();
    private final Map<String, StatsTask> statsTasks = new HashMap<String, StatsTask>(1);
    private final Context ctx;
    private int curJobNo;
    private boolean shutdown;

    public TaskQueue() {
        this(null);
    }

    public TaskQueue(Context ctx) {
        this.ctx = ctx;
    }

    public synchronized boolean isShutdown() {
        return this.shutdown;
    }

    public synchronized boolean isRunning() {
        return !this.shutdown && (!this.running.isEmpty() || !this.runnable.isEmpty());
    }

    public synchronized void remove(Task<?> task) {
        this.runnable.remove(task);
    }

    public synchronized void launching(TaskRunner runner) throws HiveException {
        this.checkShutdown();
        this.running.add(runner);
    }

    public synchronized Task<?> getRunnable(int maxthreads) throws HiveException {
        this.checkShutdown();
        if (this.runnable.peek() != null && this.running.size() < maxthreads) {
            return this.runnable.remove();
        }
        return null;
    }

    public synchronized void releaseRunnable() {
        this.notify();
    }

    public synchronized TaskRunner pollFinished() throws InterruptedException {
        while (!this.shutdown) {
            Iterator<TaskRunner> it = this.running.iterator();
            while (it.hasNext()) {
                TaskRunner runner = it.next();
                if (runner == null || runner.isRunning()) continue;
                it.remove();
                return runner;
            }
            this.wait(2000L);
        }
        return null;
    }

    private void checkShutdown() throws HiveException {
        if (this.shutdown) {
            throw new HiveException("FAILED: Operation cancelled");
        }
    }

    public synchronized void shutdown() {
        LOG.debug("Shutting down query " + this.ctx.getCmd());
        this.shutdown = true;
        for (TaskRunner runner : this.running) {
            Thread thread;
            if (!runner.isRunning()) continue;
            Task<?> task = runner.getTask();
            LOG.warn("Shutting down task : " + String.valueOf(task));
            try {
                task.shutdown();
            }
            catch (Exception e) {
                CONSOLE.printError("Exception on shutting down task " + task.getId() + ": " + String.valueOf(e));
            }
            if ((thread = runner.getRunner()) == null) continue;
            thread.interrupt();
        }
        this.running.clear();
    }

    public static boolean isLaunchable(Task<?> tsk) {
        return tsk.isNotInitialized() && tsk.isRunnable();
    }

    public synchronized boolean addToRunnable(Task<?> tsk) throws HiveException {
        if (this.runnable.contains(tsk)) {
            return false;
        }
        this.checkShutdown();
        this.runnable.add(tsk);
        tsk.setQueued();
        return true;
    }

    public int getCurJobNo() {
        return this.curJobNo;
    }

    public void incCurJobNo(int amount) {
        this.curJobNo += amount;
    }

    public void prepare(QueryPlan plan) {
        List<Task<?>> rootTasks = plan.getRootTasks();
        NodeUtils.iterateTask(rootTasks, StatsTask.class, new NodeUtils.Function<StatsTask>(){

            @Override
            public void apply(StatsTask statsTask) {
                if (((StatsWork)statsTask.getWork()).isAggregating()) {
                    TaskQueue.this.statsTasks.put(((StatsWork)statsTask.getWork()).getAggKey(), statsTask);
                }
            }
        });
    }

    public void finished(TaskRunner runner) {
        if (this.statsTasks.isEmpty() || !(runner.getTask() instanceof MapRedTask)) {
            return;
        }
        MapRedTask mapredTask = (MapRedTask)runner.getTask();
        MapWork mapWork = ((MapredWork)mapredTask.getWork()).getMapWork();
        ReduceWork reduceWork = ((MapredWork)mapredTask.getWork()).getReduceWork();
        ArrayList<Operator<? extends OperatorDesc>> operators = new ArrayList<Operator<? extends OperatorDesc>>(mapWork.getAliasToWork().values());
        if (reduceWork != null) {
            operators.add(reduceWork.getReducer());
        }
        final ArrayList statKeys = new ArrayList(1);
        NodeUtils.iterate(operators, FileSinkOperator.class, new NodeUtils.Function<FileSinkOperator>(){

            @Override
            public void apply(FileSinkOperator fsOp) {
                if (((FileSinkDesc)fsOp.getConf()).isGatherStats()) {
                    statKeys.add(((FileSinkDesc)fsOp.getConf()).getStatsAggPrefix());
                }
            }
        });
        for (String statKey : statKeys) {
            if (this.statsTasks.containsKey(statKey)) {
                ((StatsWork)this.statsTasks.get(statKey).getWork()).setSourceTask(mapredTask);
                continue;
            }
            LOG.debug("There is no correspoing statTask for: " + statKey);
        }
    }
}

