/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.Collection;
import java.util.List;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.CommitTransactionResponse;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.shaded.com.google.common.collect.ImmutableList;
import org.apache.kudu.shaded.com.google.protobuf.Message;
import org.apache.kudu.shaded.io.netty.util.Timer;
import org.apache.kudu.transactions.TxnManager;
import org.apache.kudu.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class CommitTransactionRequest
extends KuduRpc<CommitTransactionResponse> {
    private static final List<Integer> featureFlags = ImmutableList.of();
    final long txnId;

    CommitTransactionRequest(KuduTable masterTable, Timer timer, long timeoutMillis, long txnId) {
        super(masterTable, timer, timeoutMillis);
        Preconditions.checkArgument(txnId > -1L);
        this.txnId = txnId;
    }

    @Override
    Message createRequestPB() {
        TxnManager.CommitTransactionRequestPB.Builder b = TxnManager.CommitTransactionRequestPB.newBuilder();
        b.setTxnId(this.txnId);
        return b.build();
    }

    @Override
    String serviceName() {
        return "kudu.transactions.TxnManagerService";
    }

    @Override
    String method() {
        return "CommitTransaction";
    }

    @Override
    Pair<CommitTransactionResponse, Object> deserialize(CallResponse callResponse, String serverUUID) throws KuduException {
        TxnManager.CommitTransactionResponsePB.Builder b = TxnManager.CommitTransactionResponsePB.newBuilder();
        CommitTransactionRequest.readProtobuf(callResponse.getPBMessage(), b);
        CommitTransactionResponse response = new CommitTransactionResponse(this.timeoutTracker.getElapsedMillis(), serverUUID);
        return new Pair<CommitTransactionResponse, Object>(response, b.hasError() ? b.getError() : null);
    }

    @Override
    Collection<Integer> getRequiredFeatures() {
        return featureFlags;
    }
}

