/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.Weigher;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.cache.PathCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryLimitedPathCache
implements PathCache {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryLimitedPathCache.class);
    private Cache<Object, String> internalCache;

    public MemoryLimitedPathCache(Configuration conf) {
        this.internalCache = CacheBuilder.newBuilder().maximumWeight(HiveConf.getSizeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_PATH_CACHE_SIZE)).weigher((Weigher)new PathWeigher()).build();
    }

    @Override
    public void touch(Object key, String val) {
        if (key != null) {
            this.internalCache.put(key, (Object)val);
        }
    }

    @Override
    public String resolve(Object key) {
        return key != null ? (String)this.internalCache.getIfPresent(key) : null;
    }

    private static class PathWeigher
    implements Weigher<Object, String> {
        private PathWeigher() {
        }

        public int weigh(Object key, String value) {
            return 2 * value.length() + 28;
        }
    }
}

