/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.common.SSLZookeeperFactory;
import org.apache.hadoop.hive.common.ZKDeRegisterWatcher;
import org.apache.hive.org.apache.curator.framework.CuratorFramework;
import org.apache.hive.org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.hive.org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.hive.org.apache.curator.framework.api.ACLProvider;
import org.apache.hive.org.apache.curator.framework.api.BackgroundPathable;
import org.apache.hive.org.apache.curator.framework.recipes.nodes.PersistentNode;
import org.apache.hive.org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.hive.org.apache.curator.retry.RetryOneTime;
import org.apache.hive.org.apache.zookeeper.CreateMode;
import org.apache.hive.org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperHiveHelper {
    public static final Logger LOG = LoggerFactory.getLogger(ZooKeeperHiveHelper.class.getName());
    public static final String ZOOKEEPER_PATH_SEPARATOR = "/";
    private String quorum;
    private String rootNamespace;
    private int connectionTimeout;
    private int sessionTimeout;
    private int baseSleepTime;
    private int maxRetries;
    private boolean sslEnabled;
    private SSLZookeeperFactory sslZookeeperFactory;
    private CuratorFramework zooKeeperClient;
    private boolean deregisteredWithZooKeeper = false;
    private PersistentNode znode;

    public static ZooKeeperHiveHelperBuilder builder() {
        return new ZooKeeperHiveHelperBuilder();
    }

    public ZooKeeperHiveHelper(ZooKeeperHiveHelperBuilder builder) {
        String[] hosts = builder.getQuorum().split(",");
        StringBuilder quorumServers = new StringBuilder();
        for (int i = 0; i < hosts.length; ++i) {
            quorumServers.append(hosts[i].trim());
            if (!hosts[i].contains(":")) {
                quorumServers.append(":");
                quorumServers.append(builder.getClientPort());
            }
            if (i == hosts.length - 1) continue;
            quorumServers.append(",");
        }
        this.quorum = quorumServers.toString();
        this.rootNamespace = builder.getServerRegistryNameSpace();
        this.connectionTimeout = builder.getConnectionTimeout();
        this.sessionTimeout = builder.getSessionTimeout();
        this.baseSleepTime = builder.getBaseSleepTime();
        this.maxRetries = builder.getMaxRetries();
        this.sslEnabled = builder.isSslEnabled();
        this.sslZookeeperFactory = new SSLZookeeperFactory(this.sslEnabled, builder.getKeyStoreLocation(), builder.getKeyStorePassword(), builder.getKeyStoreType(), builder.getTrustStoreLocation(), builder.getTrustStorePassword(), builder.getTrustStoreType());
    }

    public String getQuorumServers() {
        return this.quorum;
    }

    public void addServerInstanceToZooKeeper(String znodePathPrefix, String znodeData, ACLProvider zooKeeperAclProvider, ZKDeRegisterWatcher watcher) throws Exception {
        this.zooKeeperClient = this.startZookeeperClient(zooKeeperAclProvider, true);
        try {
            String pathPrefix = ZOOKEEPER_PATH_SEPARATOR + this.rootNamespace + ZOOKEEPER_PATH_SEPARATOR + znodePathPrefix;
            byte[] znodeDataUTF8 = znodeData.getBytes(StandardCharsets.UTF_8);
            this.znode = new PersistentNode(this.zooKeeperClient, CreateMode.EPHEMERAL_SEQUENTIAL, false, pathPrefix, znodeDataUTF8);
            this.znode.start();
            long znodeCreationTimeout = 120L;
            if (!this.znode.waitForInitialCreate(znodeCreationTimeout, TimeUnit.SECONDS)) {
                throw new Exception("Max znode creation wait time: " + znodeCreationTimeout + "s exhausted");
            }
            this.setDeregisteredWithZooKeeper(false);
            String znodePath = this.znode.getActualPath();
            if (((BackgroundPathable)this.zooKeeperClient.checkExists().usingWatcher(watcher)).forPath(znodePath) == null) {
                throw new Exception("Unable to create znode with path prefix " + znodePathPrefix + " and data " + znodeData + " on ZooKeeper.");
            }
            LOG.info("Created a znode (actual path " + znodePath + ") on ZooKeeper with path prefix " + znodePathPrefix + " and data " + znodeData);
        }
        catch (Exception e) {
            LOG.error("Unable to create znode with path prefix " + znodePathPrefix + " and data " + znodeData + " on ZooKeeper.", e);
            if (this.znode != null) {
                this.znode.close();
            }
            throw e;
        }
    }

    public CuratorFramework startZookeeperClient(ACLProvider zooKeeperAclProvider, boolean addParentNode) throws Exception {
        CuratorFramework zkClient;
        block3: {
            zkClient = this.getNewZookeeperClient(zooKeeperAclProvider);
            zkClient.start();
            if (addParentNode) {
                try {
                    ((ACLBackgroundPathAndBytesable)zkClient.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(ZOOKEEPER_PATH_SEPARATOR + this.rootNamespace);
                    LOG.info("Created the root name space: " + this.rootNamespace + " on ZooKeeper");
                }
                catch (KeeperException e) {
                    if (e.code() == KeeperException.Code.NODEEXISTS) break block3;
                    LOG.error("Unable to create namespace: " + this.rootNamespace + " on ZooKeeper", e);
                    throw e;
                }
            }
        }
        return zkClient;
    }

    public CuratorFramework getNewZookeeperClient() {
        return this.getNewZookeeperClient(null, null);
    }

    public CuratorFramework getNewZookeeperClient(ACLProvider zooKeeperAclProvider) {
        return this.getNewZookeeperClient(zooKeeperAclProvider, null);
    }

    public CuratorFramework getNewZookeeperClient(ACLProvider zooKeeperAclProvider, String nameSpace) {
        LOG.info("Creating curator client with connectString: {} namespace: {} sessionTimeoutMs: {} connectionTimeoutMs: {} exponentialBackoff - sleepTime: {} maxRetries: {} sslEnabled: {}", this.quorum, nameSpace, this.sessionTimeout, this.connectionTimeout, this.baseSleepTime, this.maxRetries, this.sslEnabled);
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(this.quorum).namespace(nameSpace).zookeeperFactory(this.sslZookeeperFactory);
        if (this.connectionTimeout > 0) {
            builder = builder.connectionTimeoutMs(this.connectionTimeout);
        }
        if (this.sessionTimeout > 0) {
            builder = builder.sessionTimeoutMs(this.sessionTimeout);
        }
        builder = this.maxRetries > 0 ? builder.retryPolicy(new ExponentialBackoffRetry(this.baseSleepTime, this.maxRetries)) : builder.retryPolicy(new RetryOneTime(1000));
        if (zooKeeperAclProvider != null) {
            builder = builder.aclProvider(zooKeeperAclProvider);
        }
        return builder.build();
    }

    public void removeServerInstanceFromZooKeeper() throws Exception {
        this.setDeregisteredWithZooKeeper(true);
        if (this.znode != null) {
            this.znode.close();
            this.znode = null;
        }
        if (this.zooKeeperClient != null) {
            this.zooKeeperClient.close();
        }
        LOG.info("Server instance removed from ZooKeeper.");
    }

    public void deregisterZnode() {
        if (this.znode != null) {
            try {
                this.znode.close();
                LOG.warn("This server instance with path " + this.znode.getActualPath() + " is now de-registered from ZooKeeper. ");
            }
            catch (IOException e) {
                LOG.error("Failed to close the persistent ephemeral znode", e);
            }
            finally {
                this.setDeregisteredWithZooKeeper(true);
                this.znode = null;
            }
        }
    }

    public synchronized boolean isDeregisteredWithZooKeeper() {
        return this.deregisteredWithZooKeeper;
    }

    private synchronized void setDeregisteredWithZooKeeper(boolean deregisteredWithZooKeeper) {
        this.deregisteredWithZooKeeper = deregisteredWithZooKeeper;
    }

    public List<String> getServerUris() throws Exception {
        CuratorFramework zkClient = null;
        try {
            zkClient = this.startZookeeperClient(null, false);
            List serverNodes = (List)zkClient.getChildren().forPath(ZOOKEEPER_PATH_SEPARATOR + this.rootNamespace);
            ArrayList<String> serverUris = new ArrayList<String>(serverNodes.size());
            for (String serverNode : serverNodes) {
                byte[] serverUriBytes = (byte[])zkClient.getData().forPath(ZOOKEEPER_PATH_SEPARATOR + this.rootNamespace + ZOOKEEPER_PATH_SEPARATOR + serverNode);
                serverUris.add(new String(serverUriBytes, StandardCharsets.UTF_8));
            }
            zkClient.close();
            return serverUris;
        }
        catch (Exception e) {
            if (zkClient != null) {
                zkClient.close();
            }
            throw e;
        }
    }

    public static class ZooKeeperHiveHelperBuilder {
        private String quorum = null;
        private String clientPort = null;
        private String serverRegistryNameSpace = null;
        private int connectionTimeout;
        private int sessionTimeout;
        private int baseSleepTime;
        private int maxRetries;
        private boolean sslEnabled = false;
        private String keyStoreLocation = null;
        private String keyStorePassword = null;
        private String keyStoreType = null;
        private String trustStoreLocation = null;
        private String trustStorePassword = null;
        private String trustStoreType = null;

        public ZooKeeperHiveHelper build() {
            return new ZooKeeperHiveHelper(this);
        }

        public ZooKeeperHiveHelperBuilder quorum(String quorum) {
            this.quorum = quorum;
            return this;
        }

        public ZooKeeperHiveHelperBuilder clientPort(String clientPort) {
            this.clientPort = clientPort;
            return this;
        }

        public ZooKeeperHiveHelperBuilder serverRegistryNameSpace(String serverRegistryNameSpace) {
            this.serverRegistryNameSpace = serverRegistryNameSpace;
            return this;
        }

        public ZooKeeperHiveHelperBuilder connectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public ZooKeeperHiveHelperBuilder sessionTimeout(int sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
            return this;
        }

        public ZooKeeperHiveHelperBuilder baseSleepTime(int baseSleepTime) {
            this.baseSleepTime = baseSleepTime;
            return this;
        }

        public ZooKeeperHiveHelperBuilder maxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public ZooKeeperHiveHelperBuilder sslEnabled(boolean sslEnabled) {
            this.sslEnabled = sslEnabled;
            return this;
        }

        public ZooKeeperHiveHelperBuilder keyStoreLocation(String keyStoreLocation) {
            this.keyStoreLocation = keyStoreLocation;
            return this;
        }

        public ZooKeeperHiveHelperBuilder keyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public ZooKeeperHiveHelperBuilder keyStoreType(String keyStoreType) {
            this.keyStoreType = keyStoreType;
            return this;
        }

        public ZooKeeperHiveHelperBuilder trustStoreLocation(String trustStoreLocation) {
            this.trustStoreLocation = trustStoreLocation;
            return this;
        }

        public ZooKeeperHiveHelperBuilder trustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        public ZooKeeperHiveHelperBuilder trustStoreType(String trustStoreType) {
            this.trustStoreType = trustStoreType;
            return this;
        }

        public String getQuorum() {
            return this.quorum;
        }

        public String getClientPort() {
            return this.clientPort;
        }

        public String getServerRegistryNameSpace() {
            return this.serverRegistryNameSpace;
        }

        public int getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public int getSessionTimeout() {
            return this.sessionTimeout;
        }

        public int getBaseSleepTime() {
            return this.baseSleepTime;
        }

        public int getMaxRetries() {
            return this.maxRetries;
        }

        public boolean isSslEnabled() {
            return this.sslEnabled;
        }

        public String getKeyStoreLocation() {
            return this.keyStoreLocation;
        }

        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public String getKeyStoreType() {
            return this.keyStoreType;
        }

        public String getTrustStoreLocation() {
            return this.trustStoreLocation;
        }

        public String getTrustStorePassword() {
            return this.trustStorePassword;
        }

        public String getTrustStoreType() {
            return this.trustStoreType;
        }
    }
}

