/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.queries;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.jdbc.QueryHandler;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class TargetTxnIdListHandler
implements QueryHandler<List<Long>> {
    private final String replPolicy;
    private final List<Long> sourceTxnsIds;

    public TargetTxnIdListHandler(String replPolicy, List<Long> sourceTxnsIds) {
        this.replPolicy = replPolicy;
        this.sourceTxnsIds = sourceTxnsIds;
    }

    @Override
    public String getParameterizedQueryString(DatabaseProduct databaseProduct) throws MetaException {
        return "SELECT \"RTM_TARGET_TXN_ID\" FROM \"REPL_TXN_MAP\" WHERE \"RTM_SRC_TXN_ID\" IN (:txnIds) AND \"RTM_REPL_POLICY\" = :policy";
    }

    @Override
    public SqlParameterSource getQueryParameters() {
        return new MapSqlParameterSource().addValue("txnIds", this.sourceTxnsIds, -5).addValue("policy", (Object)this.replPolicy);
    }

    public List<Long> extractData(ResultSet rs) throws SQLException, DataAccessException {
        ArrayList<Long> targetTxnIdList = new ArrayList<Long>();
        while (rs.next()) {
            targetTxnIdList.add(rs.getLong(1));
        }
        return targetTxnIdList;
    }
}

