/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.BaseContentScanTask;
import org.apache.iceberg.ChangelogScanTask;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.MergeableScanTask;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;

abstract class BaseChangelogContentScanTask<ThisT extends ContentScanTask<F> & ChangelogScanTask, F extends ContentFile<F>>
extends BaseContentScanTask<ThisT, F>
implements ChangelogScanTask {
    private final int changeOrdinal;
    private final long commitSnapshotId;

    BaseChangelogContentScanTask(int changeOrdinal, long commitSnapshotId, F file, String schemaString, String specString, ResidualEvaluator residuals) {
        super(file, schemaString, specString, residuals);
        this.changeOrdinal = changeOrdinal;
        this.commitSnapshotId = commitSnapshotId;
    }

    @Override
    public int changeOrdinal() {
        return this.changeOrdinal;
    }

    @Override
    public long commitSnapshotId() {
        return this.commitSnapshotId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("change_ordinal", this.changeOrdinal).add("commit_snapshot_id", this.commitSnapshotId).add("file", this.file().location()).add("partition_data", this.file().partition()).add("residual", this.residual()).toString();
    }

    static abstract class SplitScanTask<ThisT, ParentT extends ContentScanTask<F> & ChangelogScanTask, F extends ContentFile<F>>
    implements ContentScanTask<F>,
    ChangelogScanTask,
    MergeableScanTask<ThisT> {
        private final ParentT parentTask;
        private final long offset;
        private final long length;

        protected SplitScanTask(ParentT parentTask, long offset, long length) {
            this.parentTask = parentTask;
            this.offset = offset;
            this.length = length;
        }

        protected abstract ThisT copyWithNewLength(long var1);

        protected ParentT parentTask() {
            return this.parentTask;
        }

        @Override
        public int changeOrdinal() {
            return ((ChangelogScanTask)this.parentTask).changeOrdinal();
        }

        @Override
        public long commitSnapshotId() {
            return ((ChangelogScanTask)this.parentTask).commitSnapshotId();
        }

        @Override
        public F file() {
            return this.parentTask.file();
        }

        @Override
        public PartitionSpec spec() {
            return this.parentTask.spec();
        }

        @Override
        public long start() {
            return this.offset;
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public Expression residual() {
            return this.parentTask.residual();
        }

        @Override
        public boolean canMerge(ScanTask other) {
            if (this.getClass().equals(other.getClass())) {
                SplitScanTask that = (SplitScanTask)other;
                return this.changeOrdinal() == that.changeOrdinal() && this.commitSnapshotId() == that.commitSnapshotId() && this.file().equals(that.file()) && this.start() + this.length() == that.start();
            }
            return false;
        }

        @Override
        public ThisT merge(ScanTask other) {
            SplitScanTask that = (SplitScanTask)other;
            return this.copyWithNewLength(this.length() + that.length());
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("change_ordinal", this.changeOrdinal()).add("commit_snapshot_id", this.commitSnapshotId()).add("file", this.file().location()).add("partition_data", this.file().partition()).add("offset", this.offset).add("length", this.length).add("residual", this.residual()).toString();
        }
    }
}

