/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.util.Collections;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.OperationType;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.RowSetFactory;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.MetadataOperation;
import org.apache.hive.service.cli.operation.TableTypeMapping;
import org.apache.hive.service.cli.operation.TableTypeMappingFactory;
import org.apache.hive.service.cli.session.HiveSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetTableTypesOperation
extends MetadataOperation {
    private static final Logger LOG = LoggerFactory.getLogger((String)GetTableTypesOperation.class.getName());
    protected static TableSchema RESULT_SET_SCHEMA = new TableSchema().addStringColumn("TABLE_TYPE", "Table type name.");
    private final RowSet rowSet;
    private final TableTypeMapping tableTypeMapping;

    protected GetTableTypesOperation(HiveSession parentSession) {
        super(parentSession, OperationType.GET_TABLE_TYPES);
        String tableMappingStr = this.getParentSession().getHiveConf().getVar(HiveConf.ConfVars.HIVE_SERVER2_TABLE_TYPE_MAPPING);
        this.tableTypeMapping = TableTypeMappingFactory.getTableTypeMapping(tableMappingStr);
        this.rowSet = RowSetFactory.create(RESULT_SET_SCHEMA, this.getProtocolVersion(), false);
        LOG.info("Starting GetTableTypesOperation");
    }

    @Override
    public void runInternal() throws HiveSQLException {
        this.setState(OperationState.RUNNING);
        LOG.info("Fetching table type metadata");
        if (this.isAuthV2Enabled()) {
            this.authorizeMetaGets(HiveOperationType.GET_TABLETYPES, null);
        }
        try {
            for (TableType type : TableType.values()) {
                String tableType = this.tableTypeMapping.mapToClientType(type.toString());
                this.rowSet.addRow(new String[]{tableType});
                if (!LOG.isDebugEnabled()) continue;
                String debugMessage = this.getDebugMessage("table type", RESULT_SET_SCHEMA);
                LOG.debug(debugMessage, (Object)tableType);
            }
            if (LOG.isDebugEnabled() && this.rowSet.numRows() == 0) {
                LOG.debug("No table type metadata has been returned.");
            }
            this.setState(OperationState.FINISHED);
            LOG.info("Fetching table type metadata has been successfully finished");
        }
        catch (Exception e) {
            this.setState(OperationState.ERROR);
            throw new HiveSQLException(e);
        }
    }

    @Override
    public TableSchema getResultSetSchema() throws HiveSQLException {
        this.assertState(Collections.singleton(OperationState.FINISHED));
        return RESULT_SET_SCHEMA;
    }

    @Override
    public RowSet getNextRowSet(FetchOrientation orientation, long maxRows) throws HiveSQLException {
        this.assertState(Collections.singleton(OperationState.FINISHED));
        this.validateDefaultFetchOrientation(orientation);
        if (orientation.equals((Object)FetchOrientation.FETCH_FIRST)) {
            this.rowSet.setStartOffset(0L);
        }
        return this.rowSet.extractSubset((int)maxRows);
    }
}

