/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.dto;

import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="Common message structure")
public class Message<T> {
    @Schema(description="Response Data")
    private T data;
    @Schema(title="Other Message")
    private String msg;
    @Schema(title="Response Code")
    private byte code = 0;

    public static <T> Message<T> success() {
        return new Message<T>();
    }

    public static <T> Message<T> success(String msg) {
        return new Message<T>(msg);
    }

    public static <T> Message<T> fail(byte code, String msg) {
        return new Message<T>(code, msg);
    }

    public static <T> Message<T> success(T data) {
        return new Message<T>(data);
    }

    public static <T> Message<T> successWithData(T data) {
        return new Message<T>(data);
    }

    private Message() {
    }

    private Message(String msg) {
        this.msg = msg;
    }

    private Message(byte code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private Message(T data) {
        this.data = data;
    }

    public T getData() {
        return this.data;
    }

    public String getMsg() {
        return this.msg;
    }

    public byte getCode() {
        return this.code;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setCode(byte code) {
        this.code = code;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        return !(this$msg == null ? other$msg != null : !this$msg.equals(other$msg));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Message;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        return result;
    }

    public String toString() {
        return "Message(data=" + this.getData() + ", msg=" + this.getMsg() + ", code=" + this.getCode() + ")";
    }
}

