/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.utils.rawsockets.netty.utils;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.net.util.SubnetUtils;
import org.pcap4j.core.BpfProgram;
import org.pcap4j.core.NotOpenException;
import org.pcap4j.core.PacketListener;
import org.pcap4j.core.PcapAddress;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.PcapIpV4Address;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.core.PcapNetworkInterface;
import org.pcap4j.core.Pcaps;
import org.pcap4j.packet.ArpPacket;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.namednumber.ArpHardwareType;
import org.pcap4j.packet.namednumber.ArpOperation;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArpUtils {
    private static final Logger logger = LoggerFactory.getLogger(ArpUtils.class);

    public static Set<InetAddress> scanNetworkDevice(PcapNetworkInterface nif) {
        block27: {
            try {
                String libVersion = Pcaps.libVersion();
                if (libVersion.startsWith("libpcap version ")) {
                    libVersion = libVersion.substring(16);
                    if (SystemUtils.IS_OS_MAC && !ArpUtils.checkVersionAtLeast(libVersion, "1.10.1")) {
                        logger.warn("On MacOS libpcap 1.10.1 is required, this system uses libpcap " + libVersion + ". " + "When using libpcap from homebrew, make sure to have added the library path. " + "On Intel MacOS this is usually done by setting '-Djna.library.path=/usr/local/Cellar/libpcap/1.10.1/lib' " + "on M1 this is '-Djna.library.path=/opt/homebrew/Cellar/libpcap/1.10.1/lib'");
                        return Collections.emptySet();
                    }
                    break block27;
                }
                return Collections.emptySet();
            }
            catch (Exception e) {
                return Collections.emptySet();
            }
        }
        HashSet<InetAddress> foundAddresses = new HashSet<InetAddress>();
        try {
            HashMap<String, ArrayList<String>> addresses = new HashMap<String, ArrayList<String>>();
            for (PcapAddress address : nif.getAddresses()) {
                if (!(address instanceof PcapIpV4Address)) continue;
                PcapIpV4Address ipV4Address = (PcapIpV4Address)address;
                SubnetUtils su = new SubnetUtils(ipV4Address.getAddress().getHostAddress(), ipV4Address.getNetmask().getHostAddress());
                String currentAddress = ipV4Address.getAddress().getHostAddress();
                ArrayList<String> reachableAddresses = new ArrayList<String>(Arrays.asList(su.getInfo().getAllAddresses()));
                reachableAddresses.remove(currentAddress);
                addresses.put(currentAddress, reachableAddresses);
            }
            if (addresses.isEmpty()) {
                return Collections.emptySet();
            }
            Optional<MacAddress> first = nif.getLinkLayerAddresses().stream().filter(linkLayerAddress -> linkLayerAddress instanceof MacAddress).map(linkLayerAddress -> (MacAddress)linkLayerAddress).findFirst();
            if (!first.isPresent()) {
                return Collections.emptySet();
            }
            MacAddress localMacAddress = first.get();
            PcapHandle receivingHandle = null;
            PcapHandle sendingHandle = null;
            ExecutorService arpExecutor = null;
            try {
                try {
                    receivingHandle = nif.openLive(65535, PcapNetworkInterface.PromiscuousMode.PROMISCUOUS, 100);
                    sendingHandle = nif.openLive(65535, PcapNetworkInterface.PromiscuousMode.PROMISCUOUS, 100);
                    arpExecutor = Executors.newSingleThreadExecutor();
                    StringBuilder sb = new StringBuilder("arp");
                    sb.append(" and ether dst ").append(Pcaps.toBpfString((MacAddress)localMacAddress)).append(" and (");
                    boolean firstAddress = true;
                    for (String localAddress : addresses.keySet()) {
                        if (!firstAddress) {
                            sb.append(" or ");
                        }
                        sb.append("(dst host ").append(localAddress).append(")");
                        firstAddress = false;
                    }
                    sb.append(")");
                    receivingHandle.setFilter(sb.toString(), BpfProgram.BpfCompileMode.OPTIMIZE);
                    PacketListener listener = packet -> {
                        ArpPacket arp;
                        if (packet.contains(ArpPacket.class) && (arp = (ArpPacket)packet.get(ArpPacket.class)).getHeader().getOperation().equals((Object)ArpOperation.REPLY)) {
                            foundAddresses.add(arp.getHeader().getSrcProtocolAddr());
                        }
                    };
                    PcapHandle finalReceivingHandle = receivingHandle;
                    Runnable resolutionTask = () -> {
                        try {
                            while (finalReceivingHandle.isOpen()) {
                                Packet nextPacket = finalReceivingHandle.getNextPacket();
                                if (nextPacket == null) continue;
                                listener.gotPacket(nextPacket);
                            }
                        }
                        catch (NotOpenException notOpenException) {
                            // empty catch block
                        }
                    };
                    arpExecutor.execute(resolutionTask);
                    for (Map.Entry stringListEntry : addresses.entrySet()) {
                        InetAddress localAddress = InetAddress.getByName((String)stringListEntry.getKey());
                        List remoteAddresses = (List)stringListEntry.getValue();
                        for (String remoteAddressString : remoteAddresses) {
                            InetAddress remoteAddress = InetAddress.getByName(remoteAddressString);
                            ArpPacket.Builder arpBuilder = new ArpPacket.Builder();
                            arpBuilder.hardwareType(ArpHardwareType.ETHERNET).protocolType(EtherType.IPV4).hardwareAddrLength((byte)6).protocolAddrLength((byte)4).operation(ArpOperation.REQUEST).srcHardwareAddr(localMacAddress).srcProtocolAddr(localAddress).dstHardwareAddr(MacAddress.ETHER_BROADCAST_ADDRESS).dstProtocolAddr(remoteAddress);
                            EthernetPacket.Builder etherBuilder = new EthernetPacket.Builder();
                            etherBuilder.dstAddr(MacAddress.ETHER_BROADCAST_ADDRESS).srcAddr(localMacAddress).type(EtherType.ARP).payloadBuilder((Packet.Builder)arpBuilder).paddingAtBuild(true);
                            EthernetPacket arpRequestPacket = etherBuilder.build();
                            sendingHandle.sendPacket((Packet)arpRequestPacket);
                        }
                    }
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                catch (UnknownHostException e) {
                    logger.error("error", (Throwable)e);
                    if (receivingHandle != null && receivingHandle.isOpen()) {
                        receivingHandle.close();
                    }
                    if (sendingHandle != null && sendingHandle.isOpen()) {
                        sendingHandle.close();
                    }
                    if (arpExecutor != null && !arpExecutor.isShutdown()) {
                        arpExecutor.shutdown();
                    }
                }
            }
            finally {
                if (receivingHandle != null && receivingHandle.isOpen()) {
                    receivingHandle.close();
                }
                if (sendingHandle != null && sendingHandle.isOpen()) {
                    sendingHandle.close();
                }
                if (arpExecutor != null && !arpExecutor.isShutdown()) {
                    arpExecutor.shutdown();
                }
            }
        }
        catch (NotOpenException | PcapNativeException e) {
            return Collections.emptySet();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return foundAddresses;
    }

    /*
     * Exception decompiling
     */
    public static Optional<MacAddress> resolveMacAddress(PcapNetworkInterface nif, InetSocketAddress remoteAddress, InetSocketAddress localAddress, MacAddress localMacAddress) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean checkVersionAtLeast(String current, String minimum) {
        String[] currentSegments = current.split("\\.");
        String[] minimumSegments = minimum.split("\\.");
        int numSegments = Math.min(currentSegments.length, minimumSegments.length);
        int i = 0;
        while (i < numSegments) {
            int minimumSegment;
            int currentSegment = Integer.parseInt(currentSegments[i]);
            if (currentSegment < (minimumSegment = Integer.parseInt(minimumSegments[i]))) {
                return false;
            }
            if (currentSegment > minimumSegment) {
                return true;
            }
            ++i;
        }
        return currentSegments.length >= minimumSegments.length;
    }

    private static /* synthetic */ void lambda$4(CompletableFuture completableFuture, Packet packet) {
        ArpPacket arp;
        if (packet.contains(ArpPacket.class) && (arp = (ArpPacket)packet.get(ArpPacket.class)).getHeader().getOperation().equals((Object)ArpOperation.REPLY)) {
            completableFuture.complete(arp.getHeader().getSrcHardwareAddr());
        }
    }

    private static /* synthetic */ void lambda$5(PcapHandle pcapHandle, PacketListener packetListener, CompletableFuture completableFuture) {
        try {
            pcapHandle.loop(1, packetListener);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (NotOpenException | PcapNativeException e) {
            completableFuture.completeExceptionally(e);
        }
    }
}

