/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.calculate;

import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.alert.dao.SingleAlertDao;
import org.apache.hertzbeat.alert.util.AlertUtil;
import org.apache.hertzbeat.common.entity.alerter.SingleAlert;
import org.springframework.stereotype.Component;

@Component
public class AlarmCacheManager {
    private static final String CUSTOM_FIRING_ROW_KEY = "CUSTOM_FIRING_";
    private final Table<String, String, SingleAlert> pendingAlertMap = Tables.newCustomTable(new ConcurrentHashMap(8), ConcurrentHashMap::new);
    private final Table<String, String, SingleAlert> firingAlertMap = Tables.newCustomTable(new ConcurrentHashMap(8), ConcurrentHashMap::new);

    public AlarmCacheManager(SingleAlertDao singleAlertDao) {
        List<SingleAlert> singleAlerts = singleAlertDao.querySingleAlertsByStatus("firing");
        for (SingleAlert singleAlert : singleAlerts) {
            String fingerprint = AlertUtil.calculateFingerprint(singleAlert.getLabels());
            String defineId = (String)singleAlert.getLabels().get("defineid");
            if (StringUtils.isBlank((CharSequence)defineId)) {
                defineId = this.getCustomKey(fingerprint);
            }
            singleAlert.setId(null);
            this.firingAlertMap.put((Object)defineId, (Object)fingerprint, (Object)singleAlert);
        }
    }

    public void putPending(Long defineId, String fingerPrint, SingleAlert alert) {
        this.pendingAlertMap.put((Object)String.valueOf(defineId), (Object)fingerPrint, (Object)alert);
    }

    public SingleAlert getPending(Long defineId, String fingerPrint) {
        return (SingleAlert)this.pendingAlertMap.get((Object)String.valueOf(defineId), (Object)fingerPrint);
    }

    public void removePending(Long defineId, String fingerPrint) {
        this.pendingAlertMap.remove((Object)String.valueOf(defineId), (Object)fingerPrint);
    }

    public void putFiring(Long defineId, String fingerPrint, SingleAlert alert) {
        this.firingAlertMap.put((Object)String.valueOf(defineId), (Object)fingerPrint, (Object)alert);
    }

    public void putFiring(String fingerPrint, SingleAlert alert) {
        this.firingAlertMap.put((Object)this.getCustomKey(fingerPrint), (Object)fingerPrint, (Object)alert);
    }

    public SingleAlert getFiring(Long defineId, String fingerPrint) {
        SingleAlert singleAlert = (SingleAlert)this.firingAlertMap.get((Object)String.valueOf(defineId), (Object)fingerPrint);
        if (null != singleAlert) {
            return singleAlert;
        }
        return this.getFiring(fingerPrint);
    }

    public SingleAlert removeFiring(Long defineId, String fingerPrint) {
        SingleAlert singleAlert = (SingleAlert)this.firingAlertMap.remove((Object)String.valueOf(defineId), (Object)fingerPrint);
        if (null == singleAlert) {
            return (SingleAlert)this.firingAlertMap.remove((Object)this.getCustomKey(fingerPrint), (Object)fingerPrint);
        }
        return singleAlert;
    }

    public SingleAlert getFiring(String fingerPrint) {
        return (SingleAlert)this.firingAlertMap.get((Object)this.getCustomKey(fingerPrint), (Object)fingerPrint);
    }

    private String getCustomKey(String fingerPrint) {
        return CUSTOM_FIRING_ROW_KEY + fingerPrint;
    }

    public SingleAlert removeFiring(String fingerPrint) {
        return (SingleAlert)this.firingAlertMap.remove((Object)this.getCustomKey(fingerPrint), (Object)fingerPrint);
    }
}

