/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.grafana.config;

import org.apache.hertzbeat.grafana.config.GrafanaProperties;
import org.apache.hertzbeat.grafana.service.DatasourceService;
import org.apache.hertzbeat.grafana.service.ServiceAccountService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
public class GrafanaInit
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(GrafanaInit.class);
    @Autowired
    private GrafanaProperties grafanaProperties;
    @Autowired
    private ServiceAccountService serviceAccountService;
    @Autowired
    private DatasourceService datasourceService;

    public void run(String ... args) throws Exception {
        if (this.grafanaProperties.enabled()) {
            log.info("grafana init start");
            try {
                String token = this.serviceAccountService.applyForToken();
                this.datasourceService.existOrCreateDatasource(token);
            }
            catch (Exception e) {
                log.error("grafana init error", (Throwable)e);
            }
        }
    }
}

