/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.alerter;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.apache.hertzbeat.common.entity.alerter.JsonMapAttributeConverter;
import org.apache.hertzbeat.common.entity.manager.JsonStringListAttributeConverter;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="hzb_alert_inhibit")
@Schema(description="Alert Inhibit Rule Entity")
@EntityListeners(value={AuditingEntityListener.class})
public class AlertInhibit {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Schema(title="Inhibit Rule ID", example="1")
    private Long id;
    @Schema(title="Inhibit Rule Name", example="inhibit_high_cpu")
    @Size(max=100)
    @NotNull
    private @Size(max=100) @NotNull String name;
    @Schema(title="Source Alert Match Labels")
    @Convert(converter=JsonMapAttributeConverter.class)
    @Column(length=2048)
    private Map<String, String> sourceLabels;
    @Schema(title="Target Alert Match Labels")
    @Convert(converter=JsonMapAttributeConverter.class)
    @Column(length=2048)
    private Map<String, String> targetLabels;
    @Schema(title="Equal Labels")
    @Convert(converter=JsonStringListAttributeConverter.class)
    @Column(length=2048)
    private List<String> equalLabels;
    @Schema(title="Whether to enable this policy", example="true")
    private Boolean enable;
    @Schema(title="The creator of this record", example="tom")
    @CreatedBy
    private String creator;
    @Schema(title="This record was last modified by", example="tom")
    @LastModifiedBy
    private String modifier;
    @Schema(title="This record creation time (millisecond timestamp)")
    @CreatedDate
    private LocalDateTime gmtCreate;
    @Schema(title="Record the latest modification time (timestamp in milliseconds)")
    @LastModifiedDate
    private LocalDateTime gmtUpdate;

    public static AlertInhibitBuilder builder() {
        return new AlertInhibitBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getSourceLabels() {
        return this.sourceLabels;
    }

    public Map<String, String> getTargetLabels() {
        return this.targetLabels;
    }

    public List<String> getEqualLabels() {
        return this.equalLabels;
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public LocalDateTime getGmtCreate() {
        return this.gmtCreate;
    }

    public LocalDateTime getGmtUpdate() {
        return this.gmtUpdate;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSourceLabels(Map<String, String> sourceLabels) {
        this.sourceLabels = sourceLabels;
    }

    public void setTargetLabels(Map<String, String> targetLabels) {
        this.targetLabels = targetLabels;
    }

    public void setEqualLabels(List<String> equalLabels) {
        this.equalLabels = equalLabels;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setGmtCreate(LocalDateTime gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtUpdate(LocalDateTime gmtUpdate) {
        this.gmtUpdate = gmtUpdate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlertInhibit)) {
            return false;
        }
        AlertInhibit other = (AlertInhibit)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Boolean this$enable = this.getEnable();
        Boolean other$enable = other.getEnable();
        if (this$enable == null ? other$enable != null : !((Object)this$enable).equals(other$enable)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, String> this$sourceLabels = this.getSourceLabels();
        Map<String, String> other$sourceLabels = other.getSourceLabels();
        if (this$sourceLabels == null ? other$sourceLabels != null : !((Object)this$sourceLabels).equals(other$sourceLabels)) {
            return false;
        }
        Map<String, String> this$targetLabels = this.getTargetLabels();
        Map<String, String> other$targetLabels = other.getTargetLabels();
        if (this$targetLabels == null ? other$targetLabels != null : !((Object)this$targetLabels).equals(other$targetLabels)) {
            return false;
        }
        List<String> this$equalLabels = this.getEqualLabels();
        List<String> other$equalLabels = other.getEqualLabels();
        if (this$equalLabels == null ? other$equalLabels != null : !((Object)this$equalLabels).equals(other$equalLabels)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        LocalDateTime this$gmtCreate = this.getGmtCreate();
        LocalDateTime other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        LocalDateTime this$gmtUpdate = this.getGmtUpdate();
        LocalDateTime other$gmtUpdate = other.getGmtUpdate();
        return !(this$gmtUpdate == null ? other$gmtUpdate != null : !((Object)this$gmtUpdate).equals(other$gmtUpdate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlertInhibit;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Boolean $enable = this.getEnable();
        result = result * 59 + ($enable == null ? 43 : ((Object)$enable).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, String> $sourceLabels = this.getSourceLabels();
        result = result * 59 + ($sourceLabels == null ? 43 : ((Object)$sourceLabels).hashCode());
        Map<String, String> $targetLabels = this.getTargetLabels();
        result = result * 59 + ($targetLabels == null ? 43 : ((Object)$targetLabels).hashCode());
        List<String> $equalLabels = this.getEqualLabels();
        result = result * 59 + ($equalLabels == null ? 43 : ((Object)$equalLabels).hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        LocalDateTime $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        LocalDateTime $gmtUpdate = this.getGmtUpdate();
        result = result * 59 + ($gmtUpdate == null ? 43 : ((Object)$gmtUpdate).hashCode());
        return result;
    }

    public String toString() {
        return "AlertInhibit(id=" + this.getId() + ", name=" + this.getName() + ", sourceLabels=" + this.getSourceLabels() + ", targetLabels=" + this.getTargetLabels() + ", equalLabels=" + this.getEqualLabels() + ", enable=" + this.getEnable() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", gmtCreate=" + this.getGmtCreate() + ", gmtUpdate=" + this.getGmtUpdate() + ")";
    }

    public AlertInhibit(Long id, String name, Map<String, String> sourceLabels, Map<String, String> targetLabels, List<String> equalLabels, Boolean enable, String creator, String modifier, LocalDateTime gmtCreate, LocalDateTime gmtUpdate) {
        this.id = id;
        this.name = name;
        this.sourceLabels = sourceLabels;
        this.targetLabels = targetLabels;
        this.equalLabels = equalLabels;
        this.enable = enable;
        this.creator = creator;
        this.modifier = modifier;
        this.gmtCreate = gmtCreate;
        this.gmtUpdate = gmtUpdate;
    }

    public AlertInhibit() {
    }

    public static class AlertInhibitBuilder {
        private Long id;
        private String name;
        private Map<String, String> sourceLabels;
        private Map<String, String> targetLabels;
        private List<String> equalLabels;
        private Boolean enable;
        private String creator;
        private String modifier;
        private LocalDateTime gmtCreate;
        private LocalDateTime gmtUpdate;

        AlertInhibitBuilder() {
        }

        public AlertInhibitBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public AlertInhibitBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AlertInhibitBuilder sourceLabels(Map<String, String> sourceLabels) {
            this.sourceLabels = sourceLabels;
            return this;
        }

        public AlertInhibitBuilder targetLabels(Map<String, String> targetLabels) {
            this.targetLabels = targetLabels;
            return this;
        }

        public AlertInhibitBuilder equalLabels(List<String> equalLabels) {
            this.equalLabels = equalLabels;
            return this;
        }

        public AlertInhibitBuilder enable(Boolean enable) {
            this.enable = enable;
            return this;
        }

        public AlertInhibitBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public AlertInhibitBuilder modifier(String modifier) {
            this.modifier = modifier;
            return this;
        }

        public AlertInhibitBuilder gmtCreate(LocalDateTime gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public AlertInhibitBuilder gmtUpdate(LocalDateTime gmtUpdate) {
            this.gmtUpdate = gmtUpdate;
            return this;
        }

        public AlertInhibit build() {
            return new AlertInhibit(this.id, this.name, this.sourceLabels, this.targetLabels, this.equalLabels, this.enable, this.creator, this.modifier, this.gmtCreate, this.gmtUpdate);
        }

        public String toString() {
            return "AlertInhibit.AlertInhibitBuilder(id=" + this.id + ", name=" + this.name + ", sourceLabels=" + this.sourceLabels + ", targetLabels=" + this.targetLabels + ", equalLabels=" + this.equalLabels + ", enable=" + this.enable + ", creator=" + this.creator + ", modifier=" + this.modifier + ", gmtCreate=" + this.gmtCreate + ", gmtUpdate=" + this.gmtUpdate + ")";
        }
    }
}

