/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.callback;

import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.callback.DelegatingContextView;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.callback.MutableMethodExecutionInfo;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.callback.ProxyConfig;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.callback.StopWatch;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.core.MethodExecutionInfo;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.core.ProxyEventType;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.listener.ProxyExecutionListener;
import java.util.function.Consumer;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

class MethodInvocationSubscriber
implements CoreSubscriber<Object>,
Subscription,
Scannable,
Fuseable.QueueSubscription<Object> {
    protected final CoreSubscriber<Object> delegate;
    protected final MutableMethodExecutionInfo executionInfo;
    protected final ProxyExecutionListener listener;
    protected final StopWatch stopWatch;
    protected Subscription subscription;
    @Nullable
    protected Consumer<MethodExecutionInfo> onComplete;

    public MethodInvocationSubscriber(CoreSubscriber<Object> delegate, MutableMethodExecutionInfo executionInfo, ProxyConfig proxyConfig, @Nullable Consumer<MethodExecutionInfo> onComplete) {
        this.delegate = delegate;
        this.executionInfo = executionInfo;
        this.listener = proxyConfig.getListeners();
        this.stopWatch = new StopWatch(proxyConfig.getClock());
        this.onComplete = onComplete;
    }

    public Context currentContext() {
        return this.delegate.currentContext();
    }

    public void onSubscribe(Subscription s) {
        this.subscription = s;
        this.beforeMethod();
        this.delegate.onSubscribe((Subscription)this);
    }

    public void onNext(Object object) {
        this.executionInfo.setResult(object);
        this.delegate.onNext(object);
    }

    public void onError(Throwable t) {
        this.executionInfo.setThrown(t);
        this.afterMethod();
        this.delegate.onError(t);
    }

    public void onComplete() {
        if (this.onComplete != null) {
            this.onComplete.accept(this.executionInfo);
        }
        this.afterMethod();
        this.delegate.onComplete();
    }

    public void request(long n) {
        this.subscription.request(n);
    }

    public void cancel() {
        this.afterMethod();
        this.subscription.cancel();
    }

    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.ACTUAL) {
            return this.delegate;
        }
        if (key == Scannable.Attr.PARENT) {
            return this.subscription;
        }
        return null;
    }

    public int requestFusion(int requestedMode) {
        return 0;
    }

    @Nullable
    public Object poll() {
        return null;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public void clear() {
    }

    protected void beforeMethod() {
        this.executionInfo.setThreadName(Thread.currentThread().getName());
        this.executionInfo.setThreadId(Thread.currentThread().getId());
        this.executionInfo.setProxyEventType(ProxyEventType.BEFORE_METHOD);
        this.executionInfo.getValueStore().put(ContextView.class, new DelegatingContextView((ContextView)this.currentContext()));
        this.stopWatch.start();
        this.listener.beforeMethod(this.executionInfo);
    }

    private void afterMethod() {
        this.executionInfo.setExecuteDuration(this.stopWatch.getElapsedDuration());
        this.executionInfo.setThreadName(Thread.currentThread().getName());
        this.executionInfo.setThreadId(Thread.currentThread().getId());
        this.executionInfo.setProxyEventType(ProxyEventType.AFTER_METHOD);
        this.listener.afterMethod(this.executionInfo);
    }
}

