/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.util.Objects;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Parameter;
import org.restlet.engine.util.SystemUtils;
import org.restlet.util.Series;

public abstract class ChallengeMessage {
    public static final String QUALITY_AUTHENTICATION = "auth";
    public static final String QUALITY_AUTHENTICATION_INTEGRITY = "auth-int";
    private volatile String rawValue;
    private volatile Series<Parameter> parameters;
    private volatile ChallengeScheme scheme;
    private volatile String serverNonce;
    private volatile String realm;
    private volatile String opaque;
    private volatile String digestAlgorithm;

    public ChallengeMessage(ChallengeScheme scheme) {
        this(scheme, null, null);
    }

    public ChallengeMessage(ChallengeScheme scheme, Series<Parameter> parameters) {
        this(scheme, null, null);
    }

    public ChallengeMessage(ChallengeScheme scheme, String realm) {
        this(scheme, realm, null);
    }

    public ChallengeMessage(ChallengeScheme scheme, String realm, Series<Parameter> parameters) {
        this(scheme, realm, parameters, "MD5", null, null);
    }

    public ChallengeMessage(ChallengeScheme scheme, String realm, Series<Parameter> parameters, String digestAlgorithm, String opaque, String serverNonce) {
        this.parameters = parameters;
        this.scheme = scheme;
        this.serverNonce = serverNonce;
        this.realm = realm;
        this.opaque = opaque;
        this.digestAlgorithm = digestAlgorithm;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ChallengeMessage)) {
            return false;
        }
        ChallengeMessage that = (ChallengeMessage)obj;
        return this.getParameters().equals(that.getParameters()) && Objects.equals(this.getRealm(), that.getRealm()) && Objects.equals(this.getScheme(), that.getScheme()) && Objects.equals(this.getServerNonce(), that.getServerNonce()) && Objects.equals(this.getOpaque(), that.getOpaque()) && Objects.equals(this.getDigestAlgorithm(), that.getDigestAlgorithm());
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public Series<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new Series<Parameter>(Parameter.class);
        }
        return this.parameters;
    }

    public String getRawValue() {
        return this.rawValue;
    }

    public String getRealm() {
        return this.realm;
    }

    public ChallengeScheme getScheme() {
        return this.scheme;
    }

    public String getServerNonce() {
        return this.serverNonce;
    }

    public int hashCode() {
        return SystemUtils.hashCode(this.getScheme(), this.getRealm(), this.getParameters());
    }

    public void setDigestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public void setOpaque(String opaque) {
        this.opaque = opaque;
    }

    public void setParameters(Series<Parameter> parameters) {
        this.parameters = parameters;
    }

    public void setRawValue(String rawValue) {
        this.rawValue = rawValue;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public void setScheme(ChallengeScheme scheme) {
        this.scheme = scheme;
    }

    public void setServerNonce(String serverNonce) {
        this.serverNonce = serverNonce;
    }
}

