/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.agent;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.helix.ExternalCommand;
import org.apache.helix.HelixManager;
import org.apache.helix.NotificationContext;
import org.apache.helix.agent.CommandAttribute;
import org.apache.helix.agent.ProcessMonitorThread;
import org.apache.helix.agent.SystemUtil;
import org.apache.helix.model.HelixConfigScope;
import org.apache.helix.model.Message;
import org.apache.helix.model.builder.HelixConfigScopeBuilder;
import org.apache.helix.participant.statemachine.StateModel;
import org.apache.helix.participant.statemachine.StateModelInfo;
import org.apache.helix.participant.statemachine.Transition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StateModelInfo(initialState="OFFLINE", states={})
public class AgentStateModel
extends StateModel {
    private static final Logger _logger = LoggerFactory.getLogger(AgentStateModel.class);
    private static Pattern pattern = Pattern.compile("(\\{.+?\\})");

    private static String buildKey(String fromState, String toState, CommandAttribute attribute) {
        return fromState + "-" + toState + "." + attribute.getName();
    }

    private static String instantiateByMessage(String string, Message message) {
        Matcher matcher = pattern.matcher(string);
        String result = string;
        while (matcher.find()) {
            String var = matcher.group();
            result = result.replace(var, message.getAttribute(Message.Attributes.valueOf((String)var.substring(1, var.length() - 1))));
        }
        return result;
    }

    @Transition(to="*", from="*")
    public void genericStateTransitionHandler(Message message, NotificationContext context) throws Exception {
        Map cmdKeyValueMap;
        String cmd = message.getRecord().getSimpleField(CommandAttribute.COMMAND.getName());
        String workingDir = message.getRecord().getSimpleField(CommandAttribute.WORKING_DIR.getName());
        String timeout = message.getRecord().getSimpleField(CommandAttribute.TIMEOUT.getName());
        String pidFile = message.getRecord().getSimpleField(CommandAttribute.PID_FILE.getName());
        HelixManager manager = context.getManager();
        String clusterName = manager.getClusterName();
        String fromState = message.getFromState();
        String toState = message.getToState();
        String cmdKey = AgentStateModel.buildKey(fromState, toState, CommandAttribute.COMMAND);
        String workingDirKey = AgentStateModel.buildKey(fromState, toState, CommandAttribute.WORKING_DIR);
        String timeoutKey = AgentStateModel.buildKey(fromState, toState, CommandAttribute.TIMEOUT);
        String pidFileKey = AgentStateModel.buildKey(fromState, toState, CommandAttribute.PID_FILE);
        List<String> cmdConfigKeys = Arrays.asList(cmdKey, workingDirKey, timeoutKey, pidFileKey);
        if (cmd == null) {
            HelixConfigScope resourceScope = new HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty.RESOURCE).forCluster(clusterName).forResource(message.getResourceName()).build();
            cmdKeyValueMap = manager.getConfigAccessor().get(resourceScope, cmdConfigKeys);
            if (cmdKeyValueMap != null) {
                cmd = (String)cmdKeyValueMap.get(cmdKey);
                workingDir = (String)cmdKeyValueMap.get(workingDirKey);
                timeout = (String)cmdKeyValueMap.get(timeoutKey);
                pidFile = (String)cmdKeyValueMap.get(pidFileKey);
            }
        }
        if (cmd == null) {
            HelixConfigScope clusterScope = new HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty.CLUSTER).forCluster(clusterName).build();
            cmdKeyValueMap = manager.getConfigAccessor().get(clusterScope, cmdConfigKeys);
            if (cmdKeyValueMap != null) {
                cmd = (String)cmdKeyValueMap.get(cmdKey);
                workingDir = (String)cmdKeyValueMap.get(workingDirKey);
                timeout = (String)cmdKeyValueMap.get(timeoutKey);
                pidFile = (String)cmdKeyValueMap.get(pidFileKey);
            }
        }
        if (cmd == null) {
            throw new Exception("Unable to find command for transition from:" + message.getFromState() + " to:" + message.getToState());
        }
        _logger.info("Executing command: " + cmd + ", using workingDir: " + workingDir + ", timeout: " + timeout + ", on " + manager.getInstanceName());
        if (cmd.equals(CommandAttribute.NOP.getName())) {
            return;
        }
        String[] cmdSplits = cmd.trim().split("\\s+");
        String cmdValue = cmdSplits[0];
        String[] args = Arrays.copyOfRange(cmdSplits, 1, cmdSplits.length);
        long timeoutValue = 0L;
        if (timeout != null) {
            try {
                timeoutValue = Long.parseLong(timeout);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ExternalCommand externalCmd = ExternalCommand.executeWithTimeout((File)new File(workingDir), (String)cmdValue, (long)timeoutValue, (String[])args);
        int exitValue = externalCmd.exitValue();
        _logger.debug("command:  {}, exitValue: {} output: {}\n", new Object[]{cmd, exitValue, externalCmd.getStringOutput()});
        if (pidFile == null) {
            return;
        }
        String pidFileValue = AgentStateModel.instantiateByMessage(pidFile, message);
        String pid = SystemUtil.getPidFromFile(new File(pidFileValue));
        if (pid != null) {
            new ProcessMonitorThread(pid).start();
        }
    }
}

