/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.chaos.actions.HdfsActionUtils;
import org.apache.hadoop.hbase.chaos.actions.RestartActionBaseAction;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartRandomDataNodeAction
extends RestartActionBaseAction {
    private static final Logger LOG = LoggerFactory.getLogger(RestartRandomDataNodeAction.class);

    public RestartRandomDataNodeAction(long sleepTime) {
        super(sleepTime);
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void perform() throws Exception {
        this.getLogger().info("Performing action: Restart random data node");
        ServerName server = PolicyBasedChaosMonkey.selectRandomItem(this.getDataNodes());
        this.restartDataNode(server, this.sleepTime);
    }

    private ServerName[] getDataNodes() throws IOException {
        try (DistributedFileSystem dfs = HdfsActionUtils.createDfs(this.getConf());){
            DFSClient dfsClient = dfs.getClient();
            ServerName[] serverNameArray = (ServerName[])Arrays.stream(dfsClient.datanodeReport(HdfsConstants.DatanodeReportType.LIVE)).map(dn -> ServerName.valueOf((String)dn.getHostName(), (int)-1, (long)-1L)).toArray(ServerName[]::new);
            return serverNameArray;
        }
    }
}

