/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.rest.RowResultGenerator;
import org.apache.hadoop.hbase.rest.RowSpec;
import org.apache.hadoop.hbase.rest.ScannerResultGenerator;
import org.apache.hadoop.hbase.rest.model.ScannerModel;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class ResultGenerator
implements Iterator<Cell> {
    public static ResultGenerator fromRowSpec(String table, RowSpec rowspec, Filter filter, boolean cacheBlocks) throws IOException {
        if (rowspec.isSingleRow()) {
            return new RowResultGenerator(table, rowspec, filter, cacheBlocks);
        }
        return new ScannerResultGenerator(table, rowspec, filter, cacheBlocks);
    }

    public static Filter buildFilter(String filter) throws Exception {
        return ScannerModel.buildFilter(filter);
    }

    public abstract void putBack(Cell var1);

    public abstract void close();
}

