/**
 *  Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hadoop.yarn.server.globalpolicygenerator;

import org.apache.hadoop.yarn.server.federation.utils.FederationRegistryClient;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;

/**
 * Context implementation for Global Policy Generator.
 */
public class GPGContextImpl implements GPGContext {

  private FederationStateStoreFacade facade;
  private GPGPolicyFacade policyFacade;
  private FederationRegistryClient registryClient;

  @Override
  public FederationStateStoreFacade getStateStoreFacade() {
    return facade;
  }

  @Override
  public void setStateStoreFacade(
      FederationStateStoreFacade federationStateStoreFacade) {
    this.facade = federationStateStoreFacade;
  }

  @Override
  public GPGPolicyFacade getPolicyFacade(){
    return policyFacade;
  }

  @Override
  public void setPolicyFacade(GPGPolicyFacade gpgPolicyfacade){
    policyFacade = gpgPolicyfacade;
  }

  @Override
  public FederationRegistryClient getRegistryClient() {
    return registryClient;
  }

  @Override
  public void setRegistryClient(FederationRegistryClient client) {
    registryClient = client;
  }
}
