/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.TestMethodTestDescriptor;
import org.junit.jupiter.engine.execution.InterceptingExecutableInvoker;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.extension.MutableExtensionRegistry;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;

@API(status=API.Status.INTERNAL, since="5.0")
public class TestTemplateInvocationTestDescriptor
extends TestMethodTestDescriptor {
    public static final String SEGMENT_TYPE = "test-template-invocation";
    private static final InterceptingExecutableInvoker.ReflectiveInterceptorCall<Method, Void> interceptorCall = InterceptingExecutableInvoker.ReflectiveInterceptorCall.ofVoidMethod(InvocationInterceptor::interceptTestTemplateMethod);
    private TestTemplateInvocationContext invocationContext;
    private final int index;

    TestTemplateInvocationTestDescriptor(UniqueId uniqueId, Class<?> testClass, Method templateMethod, TestTemplateInvocationContext invocationContext, int index, JupiterConfiguration configuration) {
        super(uniqueId, invocationContext.getDisplayName(index), testClass, templateMethod, configuration, interceptorCall);
        this.invocationContext = invocationContext;
        this.index = index;
    }

    @Override
    protected TestTemplateInvocationTestDescriptor withUniqueId(UnaryOperator<UniqueId> uniqueIdTransformer) {
        return new TestTemplateInvocationTestDescriptor((UniqueId)uniqueIdTransformer.apply(this.getUniqueId()), this.getTestClass(), this.getTestMethod(), this.invocationContext, this.index, this.configuration);
    }

    @Override
    public Set<ExclusiveResource> getExclusiveResources() {
        return Collections.emptySet();
    }

    @Override
    public String getLegacyReportingName() {
        return super.getLegacyReportingName() + "[" + this.index + "]";
    }

    @Override
    protected MutableExtensionRegistry populateNewExtensionRegistry(JupiterEngineExecutionContext context) {
        MutableExtensionRegistry registry = super.populateNewExtensionRegistry(context);
        this.invocationContext.getAdditionalExtensions().forEach(extension -> registry.registerExtension((Extension)extension, this.invocationContext));
        return registry;
    }

    @Override
    protected void prepareExtensionContext(ExtensionContext extensionContext) {
        this.invocationContext.prepareInvocation(extensionContext);
    }

    public void after(JupiterEngineExecutionContext context) {
        this.invocationContext = null;
    }
}

