/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.decompiled;

import groovyjarjarasm.asm.Type;
import groovyjarjarasm.asm.signature.SignatureReader;
import groovyjarjarasm.asm.signature.SignatureVisitor;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.RecordComponentNode;
import org.codehaus.groovy.ast.decompiled.Annotations;
import org.codehaus.groovy.ast.decompiled.AsmDecompiler;
import org.codehaus.groovy.ast.decompiled.AsmReferenceResolver;
import org.codehaus.groovy.ast.decompiled.ClassStub;
import org.codehaus.groovy.ast.decompiled.FormalParameterParser;
import org.codehaus.groovy.ast.decompiled.RecordComponentStub;
import org.codehaus.groovy.ast.decompiled.TypeSignatureParser;

class ClassSignatureParser {
    ClassSignatureParser() {
    }

    static void configureClass(ClassNode classNode, ClassStub stub, AsmReferenceResolver resolver) {
        if (stub.signature != null) {
            ClassSignatureParser.parseClassSignature(classNode, stub.signature, resolver);
            return;
        }
        if (stub.superName != null) {
            ClassNode sc = resolver.resolveClass(AsmDecompiler.fromInternalName(stub.superName));
            classNode.setSuperClass(sc);
        }
        int nInterfaces = stub.interfaceNames.length;
        ClassNode[] interfaces = new ClassNode[nInterfaces];
        for (int i = 0; i < nInterfaces; ++i) {
            String name = stub.interfaceNames[i];
            interfaces[i] = resolver.resolveClass(AsmDecompiler.fromInternalName(name));
        }
        classNode.setInterfaces(interfaces);
        if (!stub.permittedSubclasses.isEmpty()) {
            List<ClassNode> permitted = classNode.getPermittedSubclasses();
            for (String name : stub.permittedSubclasses) {
                ClassNode ps = resolver.resolveClass(AsmDecompiler.fromInternalName(name));
                permitted.add(ps);
            }
        }
        if (!stub.recordComponents.isEmpty()) {
            ArrayList<RecordComponentNode> recordComponents = new ArrayList<RecordComponentNode>(stub.recordComponents.size());
            for (RecordComponentStub rc : stub.recordComponents) {
                final ClassNode[] type = new ClassNode[]{resolver.resolveType(Type.getType(rc.descriptor))};
                if (rc.signature != null) {
                    new SignatureReader(rc.signature).accept(new TypeSignatureParser(resolver){

                        @Override
                        void finished(ClassNode result) {
                            type[0] = 1.applyErasure(result, type[0]);
                        }
                    });
                } else {
                    type[0] = type[0].getPlainNodeReference();
                }
                RecordComponentNode recordComponent = new RecordComponentNode(classNode, rc.name, type[0]);
                Annotations.addAnnotations(rc, recordComponent, resolver);
                Annotations.addTypeAnnotations(rc, type[0], resolver);
                recordComponents.add(recordComponent);
            }
            classNode.setRecordComponents(recordComponents);
        }
    }

    private static void parseClassSignature(final ClassNode classNode, String signature, final AsmReferenceResolver resolver) {
        final ArrayList interfaces = new ArrayList();
        FormalParameterParser parser = new FormalParameterParser(resolver){

            @Override
            public SignatureVisitor visitSuperclass() {
                this.flushTypeParameter();
                return new TypeSignatureParser(resolver){

                    @Override
                    void finished(ClassNode superClass) {
                        classNode.setSuperClass(superClass);
                    }
                };
            }

            @Override
            public SignatureVisitor visitInterface() {
                this.flushTypeParameter();
                return new TypeSignatureParser(resolver){

                    @Override
                    void finished(ClassNode superInterface) {
                        interfaces.add(superInterface);
                    }
                };
            }
        };
        new SignatureReader(signature).accept(parser);
        classNode.setInterfaces(interfaces.isEmpty() ? ClassNode.EMPTY_ARRAY : interfaces.toArray(ClassNode.EMPTY_ARRAY));
        GenericsType[] typeParameters = parser.getTypeParameters();
        if (typeParameters.length > 0) {
            classNode.setGenericsTypes(typeParameters);
        }
    }
}

