/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener.api.event.job;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.gravitino.annotation.DeveloperApi;
import org.apache.gravitino.listener.api.event.OperationType;
import org.apache.gravitino.listener.api.event.job.JobEvent;
import org.apache.gravitino.listener.api.info.JobInfo;
import org.apache.gravitino.utils.NameIdentifierUtil;

@DeveloperApi
public class RunJobEvent
extends JobEvent {
    private final JobInfo jobInfo;
    private final String jobTemplateName;
    private final Map<String, String> jobConf;

    public RunJobEvent(String user, String metalake, String jobTemplateName, Map<String, String> jobConf, JobInfo jobInfo) {
        super(user, NameIdentifierUtil.ofJob(metalake, jobInfo.jobId()));
        this.jobTemplateName = jobTemplateName;
        this.jobConf = ImmutableMap.copyOf(jobConf);
        this.jobInfo = jobInfo;
    }

    public JobInfo runJobInfo() {
        return this.jobInfo;
    }

    public String jobTemplateName() {
        return this.jobTemplateName;
    }

    public Map<String, String> jobConf() {
        return this.jobConf;
    }

    @Override
    public OperationType operationType() {
        return OperationType.RUN_JOB;
    }
}

