/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.gcs.fs;

import com.google.cloud.hadoop.util.AccessTokenProvider;
import java.io.IOException;
import org.apache.gravitino.catalog.hadoop.fs.FileSystemUtils;
import org.apache.gravitino.catalog.hadoop.fs.GravitinoFileSystemCredentialsProvider;
import org.apache.gravitino.credential.Credential;
import org.apache.gravitino.credential.GCSTokenCredential;
import org.apache.gravitino.gcs.fs.GCSUtils;
import org.apache.hadoop.conf.Configuration;

public class GCSCredentialsProvider
implements AccessTokenProvider {
    private Configuration configuration;
    private GravitinoFileSystemCredentialsProvider gravitinoFileSystemCredentialsProvider;
    private AccessTokenProvider.AccessToken accessToken;
    private long expirationTime = Long.MAX_VALUE;
    private static final double EXPIRATION_TIME_FACTOR = 0.5;

    public AccessTokenProvider.AccessToken getAccessToken() {
        if (this.accessToken == null || System.currentTimeMillis() >= this.expirationTime) {
            try {
                this.refresh();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to refresh access token", e);
            }
        }
        return this.accessToken;
    }

    public void refresh() throws IOException {
        Credential[] gravitinoCredentials = this.gravitinoFileSystemCredentialsProvider.getCredentials();
        Credential credential = GCSUtils.getGCSTokenCredential(gravitinoCredentials);
        if (credential == null) {
            throw new RuntimeException("No suitable credential for OSS found...");
        }
        if (credential instanceof GCSTokenCredential) {
            GCSTokenCredential gcsTokenCredential = (GCSTokenCredential)credential;
            this.accessToken = new AccessTokenProvider.AccessToken(gcsTokenCredential.token(), Long.valueOf(credential.expireTimeInMs()));
            if (credential.expireTimeInMs() > 0L) {
                this.expirationTime = System.currentTimeMillis() + (long)((double)(credential.expireTimeInMs() - System.currentTimeMillis()) * 0.5);
            }
        }
    }

    public void setConf(Configuration configuration) {
        this.configuration = configuration;
        this.gravitinoFileSystemCredentialsProvider = FileSystemUtils.getGvfsCredentialProvider((Configuration)configuration);
    }

    public Configuration getConf() {
        return this.configuration;
    }
}

