/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.utils;

import com.googlecode.aviator.AviatorEvaluatorInstance;
import com.googlecode.aviator.Feature;
import com.googlecode.aviator.annotation.Function;
import com.googlecode.aviator.annotation.Ignore;
import com.googlecode.aviator.exception.NoSuchPropertyException;
import com.googlecode.aviator.parser.ExpressionParser;
import com.googlecode.aviator.runtime.RuntimeUtils;
import com.googlecode.aviator.runtime.function.ClassMethodFunction;
import com.googlecode.aviator.runtime.type.AviatorJavaType;
import com.googlecode.aviator.utils.ArrayUtils;
import com.googlecode.aviator.utils.Constants;
import com.googlecode.aviator.utils.Env;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Reflector {
    public static ConcurrentHashMap<Class<?>, Reference<Map<String, PropertyFoundResult>>> cachedProperties = new ConcurrentHashMap();
    public static ConcurrentHashMap<Class<?>, Reference<Map<String, PropertyFoundResult>>> cachedSettters = new ConcurrentHashMap();
    private static final ReferenceQueue<Map<String, PropertyFoundResult>> cachedSetterRq = new ReferenceQueue();
    private static final ReferenceQueue<Map<String, PropertyFoundResult>> cachePropertyRq = new ReferenceQueue();
    public static ConcurrentHashMap<Class<?>, Reference<Map<String, PropertyFoundResult>>> cachedMethods = new ConcurrentHashMap();
    private static final ReferenceQueue<Map<String, PropertyFoundResult>> cacheMethodRq = new ReferenceQueue();
    static ConcurrentHashMap<MethodKey, Reference<List<Method>>> instanceMethodsCache = new ConcurrentHashMap();
    static final ReferenceQueue<List<Method>> instanceMethodsRq = new ReferenceQueue();
    private static Set<Class<?>> longClasses = Reflector.asSet(Long.class, Long.TYPE, Integer.class, Integer.TYPE, Byte.class, Byte.TYPE, Short.class, Short.TYPE, Byte.class, Byte.TYPE);
    private static Set<Class<?>> doubleClasses = Reflector.asSet(Double.class, Double.TYPE, Float.class, Float.TYPE);

    public static RuntimeException sneakyThrow(Throwable t) {
        if (t == null) {
            throw new NullPointerException();
        }
        Reflector.sneakyThrow0(t);
        return null;
    }

    private static <T extends Throwable> void sneakyThrow0(Throwable t) throws T {
        throw t;
    }

    private static String noMethodReport(String methodName, Object target, Object[] args) {
        return "No matching method " + methodName + " found taking " + args.length + " args" + (target == null ? "" : " for " + target.getClass());
    }

    public static boolean subsumes(Class<?>[] c1, Class<?>[] c2) {
        Boolean better = false;
        for (int i = 0; i < c1.length; ++i) {
            if (c1[i] == c2[i]) continue;
            if (!c1[i].isPrimitive() && c2[i].isPrimitive() || c2[i].isAssignableFrom(c1[i])) {
                better = true;
                continue;
            }
            return false;
        }
        return better;
    }

    private static Throwable getCauseOrElse(Exception e) {
        if (e.getCause() != null) {
            return e.getCause();
        }
        return e;
    }

    static Object invokeMatchingMethod(String methodName, List methods, Object target, Object[] args) {
        Method m2 = null;
        Object[] boxedArgs = null;
        if (methods.isEmpty()) {
            throw new IllegalArgumentException(Reflector.noMethodReport(methodName, target, args));
        }
        if (methods.size() == 1) {
            m2 = (Method)methods.get(0);
            boxedArgs = Reflector.boxArgs(m2.getParameterTypes(), args);
        } else {
            Method foundm = null;
            for (Method m2 : methods) {
                Class<?>[] params = m2.getParameterTypes();
                if (!Reflector.isCongruent(params, args) || foundm != null && !Reflector.subsumes(params, foundm.getParameterTypes())) continue;
                foundm = m2;
                boxedArgs = Reflector.boxArgs(params, args);
            }
            m2 = foundm;
        }
        if (m2 == null) {
            throw new IllegalArgumentException(Reflector.noMethodReport(methodName, target, args));
        }
        try {
            return m2.invoke(target, boxedArgs);
        }
        catch (Exception e) {
            throw Reflector.sneakyThrow(Reflector.getCauseOrElse(e));
        }
    }

    public static StringBuilder capitalize(StringBuilder sb, String s) {
        if (s == null) {
            return sb;
        }
        if (s.length() > 1 && Character.isUpperCase(s.charAt(1))) {
            return sb.append(s);
        }
        sb.append(s.substring(0, 1).toUpperCase());
        sb.append(s.substring(1));
        return sb;
    }

    private static String genGetterName(String prefix, String name) {
        StringBuilder sb = new StringBuilder(prefix);
        Reflector.capitalize(sb, name);
        return sb.toString();
    }

    public static Object fastGetProperty(Object obj, String name, PropertyType type) {
        Class<?> clazz = type.isStaticProperty() ? (Class<?>)obj : obj.getClass();
        Map<String, PropertyFoundResult> results = null;
        results = type == PropertyType.StaticMethod ? Reflector.getClassPropertyResults(cachedMethods, cacheMethodRq, clazz) : Reflector.getClassPropertyResults(cachedProperties, cachePropertyRq, clazz);
        try {
            PropertyFoundResult result = results.get(name);
            if (result == null) {
                switch (type) {
                    case StaticField: {
                        result = Reflector.retrieveStaticFieldHandle(results, clazz, name);
                        break;
                    }
                    case Getter: {
                        result = Reflector.retrieveGetterHandle(results, clazz, name);
                        break;
                    }
                    case StaticMethod: {
                        result = Reflector.retrieveStaticFunction(results, clazz, name);
                    }
                }
            }
            if (type == PropertyType.StaticMethod) {
                return result.func;
            }
            if (result.handle != null) {
                Object ret;
                Object object = ret = type == PropertyType.StaticField ? result.handle.invoke() : result.handle.invoke(obj);
                if (result.isBooleanType && !(ret instanceof Boolean)) {
                    Reflector.putDummyHandle(name, results);
                    return Reflector.throwNoSuchPropertyException("Property `" + name + "` not found in java bean: " + obj);
                }
                return ret;
            }
            if (type == PropertyType.StaticMethod) {
                return null;
            }
            return Reflector.throwNoSuchPropertyException("Property `" + name + "` not found in java bean: " + obj);
        }
        catch (Throwable t) {
            if (!results.containsKey(name)) {
                Reflector.putDummyHandle(name, results);
            }
            throw Reflector.sneakyThrow(t);
        }
    }

    public static Object throwNoSuchPropertyException(String msg) {
        throw new NoSuchPropertyException(msg);
    }

    private static PropertyFoundResult retrieveStaticFieldHandle(Map<String, PropertyFoundResult> results, Class<?> clazz, String name) throws IllegalAccessException, NoSuchFieldException {
        PropertyFoundResult result;
        Field field = null;
        try {
            field = clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (field != null && Modifier.isStatic(field.getModifiers())) {
            field.setAccessible(true);
            MethodHandle handle = MethodHandles.lookup().unreflectGetter(field);
            result = new PropertyFoundResult(handle, false);
        } else {
            result = new PropertyFoundResult(null, false);
        }
        results.put(name, result);
        return result;
    }

    private static PropertyFoundResult retrieveStaticFunction(Map<String, PropertyFoundResult> results, Class<?> clazz, String name) throws IllegalAccessException, NoSuchMethodException {
        PropertyFoundResult result;
        List<Method> methods = Reflector.getStaticMethods(clazz, name);
        if (methods != null && !methods.isEmpty()) {
            ClassMethodFunction func = new ClassMethodFunction(clazz, true, name, name, methods);
            result = new PropertyFoundResult(func);
        } else {
            result = new PropertyFoundResult(null);
        }
        results.put(name, result);
        return result;
    }

    private static PropertyFoundResult retrieveGetterHandle(Map<String, PropertyFoundResult> results, Class<?> clazz, String name) throws IllegalAccessException {
        PropertyFoundResult result;
        List<Method> methods = Reflector.getInstanceMethods(clazz, Reflector.genGetterName("get", name));
        boolean isBooleanType = false;
        if (methods == null || methods.isEmpty()) {
            methods = Reflector.getInstanceMethods(clazz, Reflector.genGetterName("is", name));
            isBooleanType = true;
        }
        if ((methods == null || methods.isEmpty()) && name.startsWith("is")) {
            methods = Reflector.getInstanceMethods(clazz, name);
            isBooleanType = true;
        }
        if (methods != null && !methods.isEmpty()) {
            Method method = methods.get(0);
            for (Method m : methods) {
                if (m.getParameterTypes().length != 0) continue;
                method = m;
                break;
            }
            method.setAccessible(true);
            MethodHandle handle = MethodHandles.lookup().unreflect(method);
            result = new PropertyFoundResult(handle, isBooleanType);
        } else {
            result = new PropertyFoundResult(null, isBooleanType);
        }
        results.put(name, result);
        return result;
    }

    private static PropertyFoundResult retrieveSetterHandle(Map<String, PropertyFoundResult> results, Class<?> clazz, String name) throws IllegalAccessException {
        PropertyFoundResult result;
        List<Method> methods = Reflector.getInstanceMethods(clazz, Reflector.genGetterName("set", name));
        if (methods != null && !methods.isEmpty()) {
            Method method = methods.get(0);
            for (Method m : methods) {
                if (m.getParameterTypes().length != 1) continue;
                method = m;
                break;
            }
            method.setAccessible(true);
            MethodHandle handle = MethodHandles.lookup().unreflect(method);
            result = new PropertyFoundResult(handle, false);
        } else {
            result = new PropertyFoundResult(null, false);
        }
        results.put(name, result);
        return result;
    }

    private static void putDummyHandle(String name, Map<String, PropertyFoundResult> handles) {
        handles.put(name, new PropertyFoundResult(null, false));
    }

    private static Map<String, PropertyFoundResult> getClassPropertyResults(ConcurrentHashMap<Class<?>, Reference<Map<String, PropertyFoundResult>>> cache, ReferenceQueue<Map<String, PropertyFoundResult>> rq, Class<?> clazz) {
        Reference existsRef = cache.get(clazz);
        Map<String, PropertyFoundResult> results = Collections.emptyMap();
        if (existsRef == null) {
            Reflector.clearCache(rq, cache);
            results = new ConcurrentHashMap<String, PropertyFoundResult>();
            existsRef = cache.putIfAbsent(clazz, new SoftReference<Map<String, PropertyFoundResult>>(results, rq));
        }
        if (existsRef == null) {
            return results;
        }
        results = existsRef.get();
        if (results != null) {
            return results;
        }
        cache.remove(clazz, existsRef);
        return Reflector.getClassPropertyResults(cache, rq, clazz);
    }

    public static List<Method> getStaticMethods(Class<?> c, String methodName) {
        ArrayList<Method> ret = new ArrayList<Method>();
        for (Method method : c.getMethods()) {
            int modifiers = method.getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || !methodName.equals(method.getName())) continue;
            ret.add(method);
        }
        return ret;
    }

    static <K, V> void clearCache(ReferenceQueue<V> rq, ConcurrentHashMap<K, Reference<V>> cache) {
        if (rq.poll() != null) {
            while (rq.poll() != null) {
            }
            for (Map.Entry<K, Reference<V>> e : cache.entrySet()) {
                Reference<V> val = e.getValue();
                if (val == null || val.get() != null) continue;
                cache.remove(e.getKey(), val);
            }
        }
    }

    public static List<Method> getInstanceMethods(Class<?> clazz, String methodName) {
        MethodKey key = new MethodKey(clazz, methodName);
        Reference existingRef = instanceMethodsCache.get(key);
        List<Method> methods = Collections.emptyList();
        if (existingRef == null) {
            Reflector.clearCache(instanceMethodsRq, instanceMethodsCache);
            methods = Reflector.getClassInstanceMethods(clazz, methodName);
            existingRef = instanceMethodsCache.putIfAbsent(key, new SoftReference<List<Method>>(methods, instanceMethodsRq));
        }
        if (existingRef == null) {
            return methods;
        }
        List<Method> existingMethods = existingRef.get();
        if (existingMethods != null) {
            return existingMethods;
        }
        instanceMethodsCache.remove(key, existingRef);
        return Reflector.getInstanceMethods(clazz, methodName);
    }

    private static List<Method> getClassInstanceMethods(Class<?> c, String methodName) {
        ArrayList<Method> ret = new ArrayList<Method>();
        for (Method method : c.getMethods()) {
            int modifiers = method.getModifiers();
            if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || !methodName.equals(method.getName())) continue;
            method.setAccessible(true);
            ret.add(method);
        }
        return ret;
    }

    public static Object invokeStaticMethod(Class<?> c, String methodName, List<Method> methods, Object[] args) {
        return Reflector.invokeMatchingMethod(methodName, methods, null, args);
    }

    public static Object invokeInstanceMethod(Class<?> c, String methodName, Object target, List<Method> methods, Object[] args) {
        return Reflector.invokeMatchingMethod(methodName, methods, target, args);
    }

    public static Object boxArg(Class<?> paramType, Object arg) {
        if (!paramType.isPrimitive()) {
            if (arg instanceof Number) {
                Number n = (Number)arg;
                if (paramType == Integer.class) {
                    return n.intValue();
                }
                if (paramType == Float.class) {
                    return Float.valueOf(n.floatValue());
                }
                if (paramType == Double.class) {
                    return n.doubleValue();
                }
                if (paramType == Long.class) {
                    return n.longValue();
                }
                if (paramType == Short.class) {
                    return n.shortValue();
                }
                if (paramType == Byte.class) {
                    return n.byteValue();
                }
            }
            return paramType.cast(arg);
        }
        if (paramType == Boolean.TYPE) {
            return Boolean.class.cast(arg);
        }
        if (paramType == Character.TYPE) {
            return Character.class.cast(arg);
        }
        if (arg instanceof Number) {
            Number n = (Number)arg;
            if (paramType == Integer.TYPE) {
                return n.intValue();
            }
            if (paramType == Float.TYPE) {
                return Float.valueOf(n.floatValue());
            }
            if (paramType == Double.TYPE) {
                return n.doubleValue();
            }
            if (paramType == Long.TYPE) {
                return n.longValue();
            }
            if (paramType == Short.TYPE) {
                return n.shortValue();
            }
            if (paramType == Byte.TYPE) {
                return n.byteValue();
            }
        }
        throw new IllegalArgumentException("Unexpected param type, expected: " + paramType + ", given: " + arg.getClass().getName());
    }

    public static Object[] boxArgs(Class<?>[] params, Object[] args) {
        if (params.length == 0) {
            return null;
        }
        Object[] ret = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            Object arg = args[i];
            Class<?> paramType = params[i];
            ret[i] = Reflector.boxArg(paramType, arg);
        }
        return ret;
    }

    private static Set<Class<?>> asSet(Class<?> ... classes) {
        HashSet ret = new HashSet();
        for (Class<?> clazz : classes) {
            ret.add(clazz);
        }
        return ret;
    }

    public static boolean paramArgTypeMatch(Class<?> paramType, Class<?> argType) {
        boolean ret;
        if (argType == null) {
            return !paramType.isPrimitive();
        }
        if (paramType == argType || paramType.isAssignableFrom(argType)) {
            return true;
        }
        boolean bl = ret = longClasses.contains(paramType) && longClasses.contains(argType);
        if (ret) {
            return ret;
        }
        boolean bl2 = ret = doubleClasses.contains(paramType) && doubleClasses.contains(argType);
        if (ret) {
            return ret;
        }
        if (paramType == Character.TYPE) {
            return argType == Character.class;
        }
        if (paramType == Boolean.TYPE) {
            return argType == Boolean.class;
        }
        return false;
    }

    public static boolean isCongruent(Class<?>[] params, Object[] args) {
        boolean ret = false;
        if (args == null) {
            return params.length == 0;
        }
        if (params.length == args.length) {
            ret = true;
            for (int i = 0; ret && i < params.length; ++i) {
                Object arg = args[i];
                Class<?> argType = arg == null ? null : arg.getClass();
                Class<?> paramType = params[i];
                ret = Reflector.paramArgTypeMatch(paramType, argType);
            }
        }
        return ret;
    }

    public static Object getProperty(Object target, String name) {
        String[] names = Constants.SPLIT_PAT.split(name);
        return Reflector.fastGetProperty(name, names, null, target instanceof Map ? Target.withEnv((Map)target) : Target.withObject(target), false, 0, names.length);
    }

    public static void setProperty(Map<String, Object> env, String name, Object val) {
        String[] names = Constants.SPLIT_PAT.split(name);
        Object target = Reflector.fastGetProperty(name, names, null, Target.withEnv(env), false, 0, names.length - 1);
        if (target == null) {
            throw new NoSuchPropertyException("Property `" + name + "` not found in java bean:" + env);
        }
        name = names[names.length - 1];
        int arrayIndex = -1;
        String keyIndex = null;
        switch (name.charAt(name.length() - 1)) {
            case ']': {
                int idx = name.indexOf("[");
                if (idx < 0) {
                    throw new IllegalArgumentException("Should not happen, doesn't contains '['");
                }
                String rawName = name;
                name = name.substring(0, idx);
                arrayIndex = Integer.valueOf(rawName.substring(idx + 1, rawName.length() - 1));
                break;
            }
            case ')': {
                int idx = name.indexOf("(");
                if (idx < 0) {
                    throw new IllegalArgumentException("Should not happen, doesn't contains '('");
                }
                String rawName = name;
                name = name.substring(0, idx);
                keyIndex = rawName.substring(idx + 1, rawName.length() - 1);
            }
        }
        if (arrayIndex >= 0 || keyIndex != null) {
            if (!name.isEmpty()) {
                target = Reflector.fastGetProperty(target, name, PropertyType.Getter);
            }
            if (arrayIndex >= 0) {
                ArrayUtils.set(target, arrayIndex, Reflector.boxArg(target.getClass().getComponentType(), val));
            } else {
                ((Map)target).put(keyIndex, val);
            }
        } else if (target instanceof Map) {
            ((Map)target).put(name, val);
        } else {
            Class<?> clazz = target.getClass();
            Map<String, PropertyFoundResult> results = Reflector.getClassPropertyResults(cachedSettters, cachedSetterRq, clazz);
            try {
                PropertyFoundResult result = results.get(name);
                if (result == null) {
                    result = Reflector.retrieveSetterHandle(results, clazz, name);
                }
                if (result.handle == null) {
                    throw new NoSuchPropertyException("Setter not found for property `" + name + "` in class: " + clazz);
                }
                result.handle.invoke(target, Reflector.boxArg(result.handle.type().parameterType(1), val));
            }
            catch (Throwable t) {
                if (!results.containsKey(name)) {
                    Reflector.putDummyHandle(name, results);
                }
                throw Reflector.sneakyThrow(t);
            }
        }
    }

    public static Object fastGetProperty(String name, String[] names, Map<String, Object> env, Target target, boolean tryResolveStaticMethod, int offset, int len) {
        int max = Math.min(offset + len, names.length);
        for (int i = offset; i < max; ++i) {
            String rName = AviatorJavaType.reserveName(names[i]);
            rName = rName != null ? rName : names[i];
            int arrayIndex = -1;
            String keyIndex = null;
            switch (rName.charAt(rName.length() - 1)) {
                case ']': {
                    int idx = rName.indexOf("[");
                    if (idx < 0) {
                        throw new IllegalArgumentException("Should not happen, doesn't contains '['");
                    }
                    String rawName = rName;
                    rName = rName.substring(0, idx);
                    arrayIndex = Integer.valueOf(rawName.substring(idx + 1, rawName.length() - 1));
                    break;
                }
                case ')': {
                    int idx = rName.indexOf("(");
                    if (idx < 0) {
                        throw new IllegalArgumentException("Should not happen, doesn't contains '('");
                    }
                    String rawName = rName;
                    rName = rName.substring(0, idx);
                    keyIndex = rawName.substring(idx + 1, rawName.length() - 1);
                }
            }
            Object val = null;
            if (target.innerClazz != null) {
                AviatorEvaluatorInstance instance = RuntimeUtils.getInstance(env);
                instance.checkIfClassIsAllowed(true, target.innerClazz);
                val = tryResolveStaticMethod && instance.isFeatureEnabled(Feature.StaticMethods) && names.length == 2 ? Reflector.fastGetProperty(target.innerClazz, rName, PropertyType.StaticMethod) : (instance.isFeatureEnabled(Feature.StaticFields) ? Reflector.fastGetProperty(target.innerClazz, rName, PropertyType.StaticField) : Reflector.fastGetProperty(target.innerClazz, rName, PropertyType.Getter));
            } else if (rName.isEmpty()) {
                if (arrayIndex < 0 && keyIndex == null) {
                    throw new IllegalArgumentException("Invalid format");
                }
                val = target.innerEnv != null ? target.innerEnv : target.targetObject;
            } else if (target.innerEnv != null) {
                val = target.innerEnv.get(rName);
                if (val == null && i == 0 && env instanceof Env) {
                    val = AviatorJavaType.tryResolveAsClass(env, rName);
                }
            } else {
                val = Reflector.fastGetProperty(target.targetObject, rName, PropertyType.Getter);
            }
            if (arrayIndex >= 0) {
                if (val.getClass().isArray()) {
                    val = ArrayUtils.get(val, arrayIndex);
                } else if (val instanceof List) {
                    val = ((List)val).get(arrayIndex);
                } else if (val instanceof CharSequence) {
                    val = Character.valueOf(((CharSequence)val).charAt(arrayIndex));
                } else {
                    throw new IllegalArgumentException("Can't access " + val + " with index `" + arrayIndex + "`, it's not an array, list or CharSequence");
                }
            }
            if (keyIndex != null) {
                if (Map.class.isAssignableFrom(val.getClass())) {
                    val = ((Map)val).get(keyIndex);
                } else {
                    throw new IllegalArgumentException("Can't access " + val + " with key `" + keyIndex + "`, it's not a map");
                }
            }
            if (i == max - 1) {
                return val;
            }
            if (val instanceof Map) {
                target.innerEnv = (Map)val;
                target.innerClazz = null;
                target.targetObject = null;
                continue;
            }
            if (val instanceof Class) {
                target.innerClazz = (Class)val;
                target.innerEnv = null;
                target.targetObject = null;
                continue;
            }
            if (val == null) {
                throw new NullPointerException(rName);
            }
            target.targetObject = val;
            target.innerEnv = null;
            target.innerClazz = null;
        }
        return Reflector.throwNoSuchPropertyException("Variable `" + name + "` not found in env: " + env);
    }

    public static Map<String, List<Method>> findMethodsFromClass(Class<?> clazz, boolean isStatic) {
        HashMap<String, List<Method>> methodMap = new HashMap<String, List<Method>>();
        for (Method method : clazz.getMethods()) {
            ArrayList<Method> methods;
            String rename;
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers) || (!isStatic ? Modifier.isStatic(modifiers) : !Modifier.isStatic(modifiers)) || method.getAnnotation(Ignore.class) != null) continue;
            String methodName = method.getName();
            Function func = method.getAnnotation(Function.class);
            if (func != null && !(rename = func.rename()).isEmpty()) {
                if (!ExpressionParser.isJavaIdentifier(rename)) {
                    throw new IllegalArgumentException("Invalid rename `" + rename + "` for method " + method.getName() + " in class " + clazz);
                }
                methodName = func.rename();
            }
            if ((methods = (ArrayList<Method>)methodMap.get(methodName)) == null) {
                methods = new ArrayList<Method>(3);
                methodMap.put(methodName, methods);
            }
            methods.add(method);
        }
        return methodMap;
    }

    public static class Target {
        Map<String, Object> innerEnv;
        Class<?> innerClazz;
        Object targetObject;

        public static Target withObject(Object target) {
            Target t = new Target();
            t.targetObject = target;
            return t;
        }

        public static Target withEnv(Map<String, Object> env) {
            Target t = new Target();
            t.innerEnv = env;
            return t;
        }
    }

    static class MethodKey {
        Class<?> clazz;
        String name;

        public MethodKey(Class<?> clazz, String name) {
            this.clazz = clazz;
            this.name = name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodKey other = (MethodKey)obj;
            if (this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }

    public static enum PropertyType {
        Getter,
        StaticField,
        StaticMethod;


        boolean isStaticProperty() {
            return this == StaticField || this == StaticMethod;
        }
    }

    static class PropertyFoundResult {
        MethodHandle handle;
        boolean isBooleanType;
        ClassMethodFunction func;

        public PropertyFoundResult(ClassMethodFunction func) {
            this.func = func;
        }

        public PropertyFoundResult(MethodHandle handle, boolean isBooleanType) {
            this.isBooleanType = isBooleanType;
            this.handle = handle;
        }

        public String toString() {
            return "MethodHandleResult [handle=" + this.handle + ", isBooleanType=" + this.isBooleanType + ", func=" + this.func + "]";
        }
    }
}

