/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.s3.fs;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.catalog.hadoop.fs.FileSystemProvider;
import org.apache.gravitino.catalog.hadoop.fs.FileSystemUtils;
import org.apache.gravitino.catalog.hadoop.fs.SupportsCredentialVending;
import org.apache.gravitino.credential.AwsIrsaCredential;
import org.apache.gravitino.credential.Credential;
import org.apache.gravitino.credential.S3SecretKeyCredential;
import org.apache.gravitino.credential.S3TokenCredential;
import org.apache.gravitino.s3.fs.S3CredentialsProvider;
import org.apache.gravitino.s3.fs.S3Utils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3FileSystemProvider
implements FileSystemProvider,
SupportsCredentialVending {
    private static final Logger LOG = LoggerFactory.getLogger(S3FileSystemProvider.class);
    @VisibleForTesting
    public static final Map<String, String> GRAVITINO_KEY_TO_S3_HADOOP_KEY = ImmutableMap.of((Object)"s3-endpoint", (Object)"fs.s3a.endpoint", (Object)"s3-access-key-id", (Object)"fs.s3a.access.key", (Object)"s3-secret-access-key", (Object)"fs.s3a.secret.key");
    private static final String S3_CREDENTIAL_KEY = "fs.s3a.aws.credentials.provider";
    private static final String S3_SIMPLE_CREDENTIAL = "org.apache.hadoop.fs.s3a.SimpleAWSCredentialsProvider";

    public FileSystem getFileSystem(Path path, Map<String, String> config) throws IOException {
        Map<String, String> hadoopConfMap = FileSystemUtils.toHadoopConfigMap(config, GRAVITINO_KEY_TO_S3_HADOOP_KEY);
        if (!hadoopConfMap.containsKey(S3_CREDENTIAL_KEY)) {
            hadoopConfMap.put(S3_CREDENTIAL_KEY, S3_SIMPLE_CREDENTIAL);
        }
        this.checkAndSetCredentialProvider(hadoopConfMap);
        hadoopConfMap = this.additionalS3Config(hadoopConfMap);
        Configuration configuration = FileSystemUtils.createConfiguration(hadoopConfMap);
        return S3AFileSystem.newInstance((URI)path.toUri(), (Configuration)configuration);
    }

    public Map<String, String> getFileSystemCredentialConf(Credential[] credentials) {
        Credential credential = S3Utils.getSuitableCredential(credentials);
        HashMap result = Maps.newHashMap();
        if (credential instanceof S3SecretKeyCredential || credential instanceof S3TokenCredential || credential instanceof AwsIrsaCredential) {
            result.put(S3_CREDENTIAL_KEY, S3CredentialsProvider.class.getCanonicalName());
        }
        return result;
    }

    private void checkAndSetCredentialProvider(Map<String, String> configs) {
        String provides = configs.get(S3_CREDENTIAL_KEY);
        if (provides == null) {
            return;
        }
        Splitter splitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
        Joiner joiner = Joiner.on((String)",").skipNulls();
        List providers = splitter.splitToList((CharSequence)provides);
        ArrayList validProviders = Lists.newArrayList();
        for (String provider : providers) {
            try {
                Class<?> c = Class.forName(provider);
                if (AWSCredentialsProvider.class.isAssignableFrom(c)) {
                    validProviders.add(provider);
                    continue;
                }
                LOG.warn("Credential provider {} is not a subclass of AWSCredentialsProvider, skipping", (Object)provider);
            }
            catch (Exception e) {
                LOG.warn("Credential provider {} not found in the Hadoop runtime, falling back to default", (Object)provider);
                configs.put(S3_CREDENTIAL_KEY, S3_SIMPLE_CREDENTIAL);
                return;
            }
        }
        if (validProviders.isEmpty()) {
            configs.put(S3_CREDENTIAL_KEY, S3_SIMPLE_CREDENTIAL);
        } else {
            configs.put(S3_CREDENTIAL_KEY, joiner.join((Iterable)validProviders));
        }
    }

    public String scheme() {
        return "s3a";
    }

    public String name() {
        return "s3";
    }

    private Map<String, String> additionalS3Config(Map<String, String> configs) {
        HashMap additionalConfigs = Maps.newHashMap(configs);
        if (!configs.containsKey("fs.s3a.attempts.maximum")) {
            additionalConfigs.put("fs.s3a.attempts.maximum", "2");
        }
        if (!configs.containsKey("fs.s3a.connection.establish.timeout")) {
            additionalConfigs.put("fs.s3a.connection.establish.timeout", "5000");
        }
        if (!configs.containsKey("fs.s3a.retry.limit")) {
            additionalConfigs.put("fs.s3a.retry.limit", "2");
        }
        if (!configs.containsKey("fs.s3a.retry.throttle.limit")) {
            additionalConfigs.put("fs.s3a.retry.throttle.limit", "2");
        }
        return ImmutableMap.copyOf((Map)additionalConfigs);
    }
}

