/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.file;

import java.util.Objects;
import org.apache.gravitino.annotation.Evolving;

@Evolving
public interface FilesetChange {
    public static FilesetChange rename(String newName) {
        return new RenameFileset(newName);
    }

    public static FilesetChange updateComment(String newComment) {
        return new UpdateFilesetComment(newComment);
    }

    public static FilesetChange setProperty(String property, String value) {
        return new SetProperty(property, value);
    }

    public static FilesetChange removeProperty(String property) {
        return new RemoveProperty(property);
    }

    @Deprecated
    public static FilesetChange removeComment() {
        return RemoveComment.getInstance();
    }

    public static final class RenameFileset
    implements FilesetChange {
        private final String newName;

        private RenameFileset(String newName) {
            this.newName = newName;
        }

        public String getNewName() {
            return this.newName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RenameFileset that = (RenameFileset)o;
            return Objects.equals(this.newName, that.newName);
        }

        public int hashCode() {
            return Objects.hash(this.newName);
        }

        public String toString() {
            return "RENAMEFILESET " + this.newName;
        }
    }

    public static final class UpdateFilesetComment
    implements FilesetChange {
        private final String newComment;

        private UpdateFilesetComment(String newComment) {
            this.newComment = newComment;
        }

        public String getNewComment() {
            return this.newComment;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpdateFilesetComment that = (UpdateFilesetComment)o;
            return Objects.equals(this.newComment, that.newComment);
        }

        public int hashCode() {
            return Objects.hash(this.newComment);
        }

        public String toString() {
            return "UPDATEFILESETCOMMENT " + this.newComment;
        }
    }

    public static final class SetProperty
    implements FilesetChange {
        private final String property;
        private final String value;

        private SetProperty(String property, String value) {
            this.property = property;
            this.value = value;
        }

        public String getProperty() {
            return this.property;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SetProperty that = (SetProperty)o;
            return Objects.equals(this.property, that.property) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.property, this.value);
        }

        public String toString() {
            return "SETPROPERTY " + this.property + " " + this.value;
        }
    }

    public static final class RemoveProperty
    implements FilesetChange {
        private final String property;

        private RemoveProperty(String property) {
            this.property = property;
        }

        public String getProperty() {
            return this.property;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoveProperty that = (RemoveProperty)o;
            return Objects.equals(this.property, that.property);
        }

        public int hashCode() {
            return Objects.hash(this.property);
        }

        public String toString() {
            return "REMOVEPROPERTY " + this.property;
        }
    }

    public static final class RemoveComment
    implements FilesetChange {
        private static final RemoveComment INSTANCE = new RemoveComment();

        private static RemoveComment getInstance() {
            return INSTANCE;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return Objects.hash("REMOVECOMMENT");
        }

        public String toString() {
            return "REMOVECOMMENT";
        }
    }
}

