/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.responses;

import java.util.Arrays;
import org.apache.gravitino.dto.MetalakeDTO;
import org.apache.gravitino.dto.responses.BaseResponse;
import org.apache.gravitino.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.org.apache.commons.lang3.StringUtils;

public class MetalakeListResponse
extends BaseResponse {
    @JsonProperty(value="metalakes")
    private final MetalakeDTO[] metalakes;

    public MetalakeListResponse(MetalakeDTO[] metalakes) {
        super(0);
        this.metalakes = metalakes;
    }

    public MetalakeListResponse() {
        this.metalakes = null;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        super.validate();
        Preconditions.checkArgument(this.metalakes != null, "metalakes must be non-null");
        Arrays.stream(this.metalakes).forEach(metalake -> {
            Preconditions.checkArgument(StringUtils.isNotBlank(metalake.name()), "metalake 'name' must not be null and empty");
            Preconditions.checkArgument(metalake.auditInfo() != null, "metalake 'audit' must not be null");
        });
    }

    public MetalakeDTO[] getMetalakes() {
        return this.metalakes;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetalakeListResponse)) {
            return false;
        }
        MetalakeListResponse other = (MetalakeListResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.deepEquals(this.getMetalakes(), other.getMetalakes());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MetalakeListResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.getMetalakes());
        return result;
    }

    @Override
    public String toString() {
        return "MetalakeListResponse(metalakes=" + Arrays.deepToString(this.getMetalakes()) + ")";
    }
}

