/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import java.util.TimeZone;
import org.apache.paimon.casting.AbstractCastRule;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastRulePredicate;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.utils.DateTimeUtils;

class DateToTimestampCastRule
extends AbstractCastRule<Number, Timestamp> {
    static final DateToTimestampCastRule INSTANCE = new DateToTimestampCastRule();

    private DateToTimestampCastRule() {
        super(CastRulePredicate.builder().input(DataTypeRoot.DATE).target(DataTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE).target(DataTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE).build());
    }

    @Override
    public CastExecutor<Number, Timestamp> create(DataType inputType, DataType targetType) {
        if (targetType.is(DataTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE)) {
            return value -> Timestamp.fromEpochMillis(value.longValue() * 86400000L);
        }
        if (targetType.is(DataTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE)) {
            return value -> DateTimeUtils.dateToTimestampWithLocalZone(value.intValue(), TimeZone.getDefault());
        }
        return null;
    }
}

