/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.gravitino.Entity;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.meta.FilesetEntity;
import org.apache.gravitino.meta.NamespacedEntityId;
import org.apache.gravitino.metrics.MethodMonitorAspect;
import org.apache.gravitino.metrics.Monitored;
import org.apache.gravitino.metrics.source.MetricsSource;
import org.apache.gravitino.storage.relational.mapper.FilesetMetaMapper;
import org.apache.gravitino.storage.relational.mapper.FilesetVersionMapper;
import org.apache.gravitino.storage.relational.mapper.OwnerMetaMapper;
import org.apache.gravitino.storage.relational.mapper.PolicyMetadataObjectRelMapper;
import org.apache.gravitino.storage.relational.mapper.SecurableObjectMapper;
import org.apache.gravitino.storage.relational.mapper.StatisticMetaMapper;
import org.apache.gravitino.storage.relational.mapper.TagMetadataObjectRelMapper;
import org.apache.gravitino.storage.relational.po.FilesetMaxVersionPO;
import org.apache.gravitino.storage.relational.po.FilesetPO;
import org.apache.gravitino.storage.relational.service.EntityIdService;
import org.apache.gravitino.storage.relational.utils.ExceptionUtils;
import org.apache.gravitino.storage.relational.utils.POConverters;
import org.apache.gravitino.storage.relational.utils.SessionUtils;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.NamespaceUtil;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesetMetaService {
    private static final FilesetMetaService INSTANCE;
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ Annotation ajc$anno$6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ Annotation ajc$anno$7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ Annotation ajc$anno$8;

    public static FilesetMetaService getInstance() {
        return INSTANCE;
    }

    private FilesetMetaService() {
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getFilesetPOBySchemaIdAndName")
    public FilesetPO getFilesetPOBySchemaIdAndName(Long schemaId, String filesetName) {
        Long l = schemaId;
        String string = filesetName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)l, (Object)string);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = FilesetMetaService.class.getDeclaredMethod("getFilesetPOBySchemaIdAndName", Long.class, String.class).getAnnotation(Monitored.class);
        }
        return (FilesetPO)FilesetMetaService.getFilesetPOBySchemaIdAndName_aroundBody1$advice(this, l, string, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getFilesetIdBySchemaIdAndName")
    public Long getFilesetIdBySchemaIdAndName(Long schemaId, String filesetName) {
        Long l = schemaId;
        String string = filesetName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)l, (Object)string);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = FilesetMetaService.class.getDeclaredMethod("getFilesetIdBySchemaIdAndName", Long.class, String.class).getAnnotation(Monitored.class);
        }
        return (Long)FilesetMetaService.getFilesetIdBySchemaIdAndName_aroundBody3$advice(this, l, string, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getFilesetByIdentifier")
    public FilesetEntity getFilesetByIdentifier(NameIdentifier identifier) {
        NameIdentifier nameIdentifier = identifier;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)nameIdentifier);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = FilesetMetaService.class.getDeclaredMethod("getFilesetByIdentifier", NameIdentifier.class).getAnnotation(Monitored.class);
        }
        return (FilesetEntity)FilesetMetaService.getFilesetByIdentifier_aroundBody5$advice(this, nameIdentifier, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="listFilesetsByNamespace")
    public List<FilesetEntity> listFilesetsByNamespace(Namespace namespace) {
        Namespace namespace2 = namespace;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)namespace2);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = FilesetMetaService.class.getDeclaredMethod("listFilesetsByNamespace", Namespace.class).getAnnotation(Monitored.class);
        }
        return (List)FilesetMetaService.listFilesetsByNamespace_aroundBody7$advice(this, namespace2, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="insertFileset")
    public void insertFileset(FilesetEntity filesetEntity, boolean overwrite) throws IOException {
        FilesetEntity filesetEntity2 = filesetEntity;
        boolean bl = overwrite;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)filesetEntity2, (Object)Conversions.booleanObject((boolean)bl));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = FilesetMetaService.class.getDeclaredMethod("insertFileset", FilesetEntity.class, Boolean.TYPE).getAnnotation(Monitored.class);
        }
        FilesetMetaService.insertFileset_aroundBody9$advice(this, filesetEntity2, bl, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="updateFileset")
    public <E extends Entity & HasIdentifier> FilesetEntity updateFileset(NameIdentifier identifier, Function<E, E> updater) throws IOException {
        NameIdentifier nameIdentifier = identifier;
        Function<E, E> function = updater;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)nameIdentifier, function);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = FilesetMetaService.class.getDeclaredMethod("updateFileset", NameIdentifier.class, Function.class).getAnnotation(Monitored.class);
        }
        return (FilesetEntity)FilesetMetaService.updateFileset_aroundBody11$advice(this, nameIdentifier, function, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="deleteFileset")
    public boolean deleteFileset(NameIdentifier identifier) {
        NameIdentifier nameIdentifier = identifier;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)nameIdentifier);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = FilesetMetaService.class.getDeclaredMethod("deleteFileset", NameIdentifier.class).getAnnotation(Monitored.class);
        }
        return Conversions.booleanValue((Object)FilesetMetaService.deleteFileset_aroundBody13$advice(this, nameIdentifier, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation));
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="deleteFilesetAndVersionMetasByLegacyTimeline")
    public int deleteFilesetAndVersionMetasByLegacyTimeline(Long legacyTimeline, int limit) {
        Long l = legacyTimeline;
        int n = limit;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)l, (Object)Conversions.intObject((int)n));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$7;
        if (annotation == null) {
            annotation = ajc$anno$7 = FilesetMetaService.class.getDeclaredMethod("deleteFilesetAndVersionMetasByLegacyTimeline", Long.class, Integer.TYPE).getAnnotation(Monitored.class);
        }
        return Conversions.intValue((Object)FilesetMetaService.deleteFilesetAndVersionMetasByLegacyTimeline_aroundBody15$advice(this, l, n, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation));
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="deleteFilesetVersionsByRetentionCount")
    public int deleteFilesetVersionsByRetentionCount(Long versionRetentionCount, int limit) {
        Long l = versionRetentionCount;
        int n = limit;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)l, (Object)Conversions.intObject((int)n));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$8;
        if (annotation == null) {
            annotation = ajc$anno$8 = FilesetMetaService.class.getDeclaredMethod("deleteFilesetVersionsByRetentionCount", Long.class, Integer.TYPE).getAnnotation(Monitored.class);
        }
        return Conversions.intValue((Object)FilesetMetaService.deleteFilesetVersionsByRetentionCount_aroundBody17$advice(this, l, n, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation));
    }

    private void fillFilesetPOBuilderParentEntityId(FilesetPO.Builder builder, Namespace namespace) {
        NamespaceUtil.checkFileset(namespace);
        NamespacedEntityId namespacedEntityId = EntityIdService.getEntityIds(NameIdentifier.of((String[])namespace.levels()), Entity.EntityType.SCHEMA);
        builder.withMetalakeId(namespacedEntityId.namespaceIds()[0]);
        builder.withCatalogId(namespacedEntityId.namespaceIds()[1]);
        builder.withSchemaId(namespacedEntityId.entityId());
    }

    static {
        FilesetMetaService.ajc$preClinit();
        INSTANCE = new FilesetMetaService();
        LOG = LoggerFactory.getLogger(FilesetMetaService.class);
    }

    private static final /* synthetic */ FilesetPO getFilesetPOBySchemaIdAndName_aroundBody0(FilesetMetaService ajc$this, Long schemaId, String filesetName, JoinPoint joinPoint) {
        FilesetPO filesetPO = SessionUtils.getWithoutCommit(FilesetMetaMapper.class, mapper -> mapper.selectFilesetMetaBySchemaIdAndName(schemaId, filesetName));
        if (filesetPO == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.FILESET.name().toLowerCase(), filesetName});
        }
        return filesetPO;
    }

    private static final /* synthetic */ Object getFilesetPOBySchemaIdAndName_aroundBody1$advice(FilesetMetaService ajc$this, Long schemaId, String filesetName, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        FilesetPO filesetPO;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return FilesetMetaService.getFilesetPOBySchemaIdAndName_aroundBody0(ajc$this, schemaId, filesetName, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return FilesetMetaService.getFilesetPOBySchemaIdAndName_aroundBody0(ajc$this, schemaId, filesetName, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                FilesetPO result = FilesetMetaService.getFilesetPOBySchemaIdAndName_aroundBody0(ajc$this, schemaId, filesetName, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                filesetPO = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return filesetPO;
    }

    private static final /* synthetic */ Long getFilesetIdBySchemaIdAndName_aroundBody2(FilesetMetaService ajc$this, Long schemaId, String filesetName, JoinPoint joinPoint) {
        Long filesetId = SessionUtils.getWithoutCommit(FilesetMetaMapper.class, mapper -> mapper.selectFilesetIdBySchemaIdAndName(schemaId, filesetName));
        if (filesetId == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.FILESET.name().toLowerCase(), filesetName});
        }
        return filesetId;
    }

    private static final /* synthetic */ Object getFilesetIdBySchemaIdAndName_aroundBody3$advice(FilesetMetaService ajc$this, Long schemaId, String filesetName, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Long l;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return FilesetMetaService.getFilesetIdBySchemaIdAndName_aroundBody2(ajc$this, schemaId, filesetName, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return FilesetMetaService.getFilesetIdBySchemaIdAndName_aroundBody2(ajc$this, schemaId, filesetName, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Long result = FilesetMetaService.getFilesetIdBySchemaIdAndName_aroundBody2(ajc$this, schemaId, filesetName, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                l = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return l;
    }

    private static final /* synthetic */ FilesetEntity getFilesetByIdentifier_aroundBody4(FilesetMetaService ajc$this, NameIdentifier identifier, JoinPoint joinPoint) {
        NameIdentifierUtil.checkFileset(identifier);
        String filesetName = identifier.name();
        Long schemaId = EntityIdService.getEntityId(NameIdentifier.of((String[])identifier.namespace().levels()), Entity.EntityType.SCHEMA);
        FilesetPO filesetPO = ajc$this.getFilesetPOBySchemaIdAndName(schemaId, filesetName);
        return POConverters.fromFilesetPO(filesetPO, identifier.namespace());
    }

    private static final /* synthetic */ Object getFilesetByIdentifier_aroundBody5$advice(FilesetMetaService ajc$this, NameIdentifier identifier, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        FilesetEntity filesetEntity;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return FilesetMetaService.getFilesetByIdentifier_aroundBody4(ajc$this, identifier, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return FilesetMetaService.getFilesetByIdentifier_aroundBody4(ajc$this, identifier, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                FilesetEntity result = FilesetMetaService.getFilesetByIdentifier_aroundBody4(ajc$this, identifier, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                filesetEntity = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return filesetEntity;
    }

    private static final /* synthetic */ List listFilesetsByNamespace_aroundBody6(FilesetMetaService ajc$this, Namespace namespace, JoinPoint joinPoint) {
        NamespaceUtil.checkFileset(namespace);
        Long schemaId = EntityIdService.getEntityId(NameIdentifier.of((String[])namespace.levels()), Entity.EntityType.SCHEMA);
        List filesetPOs = SessionUtils.getWithoutCommit(FilesetMetaMapper.class, mapper -> mapper.listFilesetPOsBySchemaId(schemaId));
        return POConverters.fromFilesetPOs(filesetPOs, namespace);
    }

    private static final /* synthetic */ Object listFilesetsByNamespace_aroundBody7$advice(FilesetMetaService ajc$this, Namespace namespace, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        List list;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return FilesetMetaService.listFilesetsByNamespace_aroundBody6(ajc$this, namespace, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return FilesetMetaService.listFilesetsByNamespace_aroundBody6(ajc$this, namespace, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                List result = FilesetMetaService.listFilesetsByNamespace_aroundBody6(ajc$this, namespace, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                list = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return list;
    }

    private static final /* synthetic */ void insertFileset_aroundBody8(FilesetMetaService ajc$this, FilesetEntity filesetEntity, boolean overwrite, JoinPoint joinPoint) {
        try {
            NameIdentifierUtil.checkFileset(filesetEntity.nameIdentifier());
            FilesetPO.Builder builder = FilesetPO.builder();
            ajc$this.fillFilesetPOBuilderParentEntityId(builder, filesetEntity.namespace());
            FilesetPO po = POConverters.initializeFilesetPOWithVersion(filesetEntity, builder);
            SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(FilesetMetaMapper.class, mapper -> {
                if (overwrite) {
                    mapper.insertFilesetMetaOnDuplicateKeyUpdate(po);
                } else {
                    mapper.insertFilesetMeta(po);
                }
            }), () -> SessionUtils.doWithoutCommit(FilesetVersionMapper.class, mapper -> {
                if (overwrite) {
                    mapper.insertFilesetVersionsOnDuplicateKeyUpdate(po.getFilesetVersionPOs());
                } else {
                    mapper.insertFilesetVersions(po.getFilesetVersionPOs());
                }
            }));
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.FILESET, filesetEntity.nameIdentifier().toString());
            throw re;
        }
    }

    private static final /* synthetic */ Object insertFileset_aroundBody9$advice(FilesetMetaService ajc$this, FilesetEntity filesetEntity, boolean overwrite, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object var14_19;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                FilesetMetaService.insertFileset_aroundBody8(ajc$this, filesetEntity, overwrite, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                FilesetMetaService.insertFileset_aroundBody8(ajc$this, filesetEntity, overwrite, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                FilesetMetaService.insertFileset_aroundBody8(ajc$this, filesetEntity, overwrite, (JoinPoint)proceedingJoinPoint);
                Object result = null;
                successMeter.mark();
                var14_19 = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return var14_19;
    }

    private static final /* synthetic */ FilesetEntity updateFileset_aroundBody10(FilesetMetaService ajc$this, NameIdentifier identifier, Function updater, JoinPoint joinPoint) {
        Integer updateResult;
        NameIdentifierUtil.checkFileset(identifier);
        String filesetName = identifier.name();
        Long schemaId = EntityIdService.getEntityId(NameIdentifier.of((String[])identifier.namespace().levels()), Entity.EntityType.SCHEMA);
        FilesetPO oldFilesetPO = ajc$this.getFilesetPOBySchemaIdAndName(schemaId, filesetName);
        FilesetEntity oldFilesetEntity = POConverters.fromFilesetPO(oldFilesetPO, identifier.namespace());
        FilesetEntity newEntity = (FilesetEntity)updater.apply(oldFilesetEntity);
        Preconditions.checkArgument((boolean)Objects.equals(oldFilesetEntity.id(), newEntity.id()), (String)"The updated fileset entity id: %s should be same with the table entity id before: %s", (Object)newEntity.id(), (Object)oldFilesetEntity.id());
        try {
            boolean checkNeedUpdateVersion = POConverters.checkFilesetVersionNeedUpdate(oldFilesetPO.getFilesetVersionPOs(), newEntity);
            FilesetPO newFilesetPO = POConverters.updateFilesetPOWithVersion(oldFilesetPO, newEntity, checkNeedUpdateVersion);
            if (checkNeedUpdateVersion) {
                SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(FilesetVersionMapper.class, mapper -> mapper.insertFilesetVersions(newFilesetPO.getFilesetVersionPOs())), () -> SessionUtils.doWithoutCommit(FilesetMetaMapper.class, mapper -> mapper.updateFilesetMeta(newFilesetPO, oldFilesetPO)));
                updateResult = 1;
            } else {
                updateResult = SessionUtils.doWithCommitAndFetchResult(FilesetMetaMapper.class, mapper -> mapper.updateFilesetMeta(newFilesetPO, oldFilesetPO));
            }
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.FILESET, newEntity.nameIdentifier().toString());
            throw re;
        }
        if (updateResult > 0) {
            return newEntity;
        }
        throw new IOException("Failed to update the entity: " + String.valueOf(identifier));
    }

    private static final /* synthetic */ Object updateFileset_aroundBody11$advice(FilesetMetaService ajc$this, NameIdentifier identifier, Function updater, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        FilesetEntity filesetEntity;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return FilesetMetaService.updateFileset_aroundBody10(ajc$this, identifier, updater, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return FilesetMetaService.updateFileset_aroundBody10(ajc$this, identifier, updater, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                FilesetEntity result = FilesetMetaService.updateFileset_aroundBody10(ajc$this, identifier, updater, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                filesetEntity = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return filesetEntity;
    }

    private static final /* synthetic */ boolean deleteFileset_aroundBody12(FilesetMetaService ajc$this, NameIdentifier identifier, JoinPoint joinPoint) {
        NameIdentifierUtil.checkFileset(identifier);
        Long filesetId = EntityIdService.getEntityId(identifier, Entity.EntityType.FILESET);
        SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(FilesetMetaMapper.class, mapper -> mapper.softDeleteFilesetMetasByFilesetId(filesetId)), () -> SessionUtils.doWithoutCommit(FilesetVersionMapper.class, mapper -> mapper.softDeleteFilesetVersionsByFilesetId(filesetId)), () -> SessionUtils.doWithoutCommit(OwnerMetaMapper.class, mapper -> mapper.softDeleteOwnerRelByMetadataObjectIdAndType(filesetId, MetadataObject.Type.FILESET.name())), () -> SessionUtils.doWithoutCommit(SecurableObjectMapper.class, mapper -> mapper.softDeleteObjectRelsByMetadataObject(filesetId, MetadataObject.Type.FILESET.name())), () -> SessionUtils.doWithoutCommit(TagMetadataObjectRelMapper.class, mapper -> mapper.softDeleteTagMetadataObjectRelsByMetadataObject(filesetId, MetadataObject.Type.FILESET.name())), () -> SessionUtils.doWithoutCommit(StatisticMetaMapper.class, mapper -> mapper.softDeleteStatisticsByEntityId(filesetId)), () -> SessionUtils.doWithoutCommit(PolicyMetadataObjectRelMapper.class, mapper -> mapper.softDeletePolicyMetadataObjectRelsByMetadataObject(filesetId, MetadataObject.Type.FILESET.name())));
        return true;
    }

    private static final /* synthetic */ Object deleteFileset_aroundBody13$advice(FilesetMetaService ajc$this, NameIdentifier identifier, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object object;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.booleanObject((boolean)FilesetMetaService.deleteFileset_aroundBody12(ajc$this, identifier, (JoinPoint)proceedingJoinPoint));
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.booleanObject((boolean)FilesetMetaService.deleteFileset_aroundBody12(ajc$this, identifier, (JoinPoint)proceedingJoinPoint));
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Object result = Conversions.booleanObject((boolean)FilesetMetaService.deleteFileset_aroundBody12(ajc$this, identifier, (JoinPoint)proceedingJoinPoint));
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    private static final /* synthetic */ int deleteFilesetAndVersionMetasByLegacyTimeline_aroundBody14(FilesetMetaService ajc$this, Long legacyTimeline, int limit, JoinPoint joinPoint) {
        int filesetDeletedCount = SessionUtils.doWithCommitAndFetchResult(FilesetMetaMapper.class, mapper -> mapper.deleteFilesetMetasByLegacyTimeline(legacyTimeline, limit));
        int filesetVersionDeletedCount = SessionUtils.doWithCommitAndFetchResult(FilesetVersionMapper.class, mapper -> mapper.deleteFilesetVersionsByLegacyTimeline(legacyTimeline, limit));
        return filesetDeletedCount + filesetVersionDeletedCount;
    }

    private static final /* synthetic */ Object deleteFilesetAndVersionMetasByLegacyTimeline_aroundBody15$advice(FilesetMetaService ajc$this, Long legacyTimeline, int limit, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object object;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)FilesetMetaService.deleteFilesetAndVersionMetasByLegacyTimeline_aroundBody14(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)FilesetMetaService.deleteFilesetAndVersionMetasByLegacyTimeline_aroundBody14(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Object result = Conversions.intObject((int)FilesetMetaService.deleteFilesetAndVersionMetasByLegacyTimeline_aroundBody14(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    private static final /* synthetic */ int deleteFilesetVersionsByRetentionCount_aroundBody16(FilesetMetaService ajc$this, Long versionRetentionCount, int limit, JoinPoint joinPoint) {
        List filesetCurVersions = SessionUtils.getWithoutCommit(FilesetVersionMapper.class, mapper -> mapper.selectFilesetVersionsByRetentionCount(versionRetentionCount));
        int totalDeletedCount = 0;
        for (FilesetMaxVersionPO filesetCurVersion : filesetCurVersions) {
            long versionRetentionLine = filesetCurVersion.getVersion() - versionRetentionCount;
            int deletedCount = SessionUtils.doWithCommitAndFetchResult(FilesetVersionMapper.class, mapper -> mapper.softDeleteFilesetVersionsByRetentionLine(filesetCurVersion.getFilesetId(), versionRetentionLine, limit));
            totalDeletedCount += deletedCount;
            LOG.info("Soft delete filesetVersions count: {} which versions are older than or equal to versionRetentionLine: {}, the current filesetId and version is: <{}, {}>.", new Object[]{deletedCount, versionRetentionLine, filesetCurVersion.getFilesetId(), filesetCurVersion.getVersion()});
        }
        return totalDeletedCount;
    }

    private static final /* synthetic */ Object deleteFilesetVersionsByRetentionCount_aroundBody17$advice(FilesetMetaService ajc$this, Long versionRetentionCount, int limit, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object object;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)FilesetMetaService.deleteFilesetVersionsByRetentionCount_aroundBody16(ajc$this, versionRetentionCount, limit, (JoinPoint)proceedingJoinPoint));
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)FilesetMetaService.deleteFilesetVersionsByRetentionCount_aroundBody16(ajc$this, versionRetentionCount, limit, (JoinPoint)proceedingJoinPoint));
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Object result = Conversions.intObject((int)FilesetMetaService.deleteFilesetVersionsByRetentionCount_aroundBody16(ajc$this, versionRetentionCount, limit, (JoinPoint)proceedingJoinPoint));
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("FilesetMetaService.java", FilesetMetaService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFilesetPOBySchemaIdAndName", "org.apache.gravitino.storage.relational.service.FilesetMetaService", "java.lang.Long:java.lang.String", "schemaId:filesetName", "", "org.apache.gravitino.storage.relational.po.FilesetPO"), 73);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFilesetIdBySchemaIdAndName", "org.apache.gravitino.storage.relational.service.FilesetMetaService", "java.lang.Long:java.lang.String", "schemaId:filesetName", "", "java.lang.Long"), 91);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFilesetByIdentifier", "org.apache.gravitino.storage.relational.service.FilesetMetaService", "org.apache.gravitino.NameIdentifier", "identifier", "", "org.apache.gravitino.meta.FilesetEntity"), 109);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listFilesetsByNamespace", "org.apache.gravitino.storage.relational.service.FilesetMetaService", "org.apache.gravitino.Namespace", "namespace", "", "java.util.List"), 126);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "insertFileset", "org.apache.gravitino.storage.relational.service.FilesetMetaService", "org.apache.gravitino.meta.FilesetEntity:boolean", "filesetEntity:overwrite", "java.io.IOException", "void"), 144);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateFileset", "org.apache.gravitino.storage.relational.service.FilesetMetaService", "org.apache.gravitino.NameIdentifier:java.util.function.Function", "identifier:updater", "java.io.IOException", "org.apache.gravitino.meta.FilesetEntity"), 185);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteFileset", "org.apache.gravitino.storage.relational.service.FilesetMetaService", "org.apache.gravitino.NameIdentifier", "identifier", "", "boolean"), 250);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteFilesetAndVersionMetasByLegacyTimeline", "org.apache.gravitino.storage.relational.service.FilesetMetaService", "java.lang.Long:int", "legacyTimeline:limit", "", "int"), 300);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteFilesetVersionsByRetentionCount", "org.apache.gravitino.storage.relational.service.FilesetMetaService", "java.lang.Long:int", "versionRetentionCount:limit", "", "int"), 320);
    }
}

