/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.merge;

import com.lancedb.lance.shaded.guava.base.MoreObjects;
import com.lancedb.lance.shaded.guava.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;

public class MergeInsertParams {
    private final List<String> on;
    private WhenMatched whenMatched = WhenMatched.DoNothing;
    private Optional<String> whenMatchedUpdateExpr = Optional.empty();
    private WhenNotMatched whenNotMatched = WhenNotMatched.InsertAll;
    private WhenNotMatchedBySource whenNotMatchedBySource = WhenNotMatchedBySource.Keep;
    private Optional<String> whenNotMatchedBySourceDeleteExpr = Optional.empty();
    private Optional<ByteBuffer> whenNotMatchedBySourceDeleteSubstraitExpr = Optional.empty();
    private int conflictRetries = 10;
    private long retryTimeoutMs = 30000L;
    private boolean skipAutoCleanup = false;

    public MergeInsertParams(List<String> on) {
        this.on = on;
    }

    public MergeInsertParams withMatchedUpdateAll() {
        this.whenMatched = WhenMatched.UpdateAll;
        return this;
    }

    public MergeInsertParams withMatchedDoNothing() {
        this.whenMatched = WhenMatched.DoNothing;
        return this;
    }

    public MergeInsertParams withMatchedUpdateIf(String expr) {
        Preconditions.checkNotNull(expr);
        this.whenMatched = WhenMatched.UpdateIf;
        this.whenMatchedUpdateExpr = Optional.of(expr);
        return this;
    }

    public MergeInsertParams withMatchedFail() {
        this.whenMatched = WhenMatched.Fail;
        return this;
    }

    public MergeInsertParams withNotMatched(WhenNotMatched whenNotMatched) {
        this.whenNotMatched = whenNotMatched;
        return this;
    }

    public MergeInsertParams withNotMatchedBySourceKeep() {
        this.whenNotMatchedBySource = WhenNotMatchedBySource.Keep;
        return this;
    }

    public MergeInsertParams withNotMatchedBySourceDelete() {
        this.whenNotMatchedBySource = WhenNotMatchedBySource.Delete;
        return this;
    }

    public MergeInsertParams withNotMatchedBySourceDeleteIf(String expr) {
        Preconditions.checkNotNull(expr);
        this.whenNotMatchedBySource = WhenNotMatchedBySource.DeleteIf;
        this.whenNotMatchedBySourceDeleteExpr = Optional.of(expr);
        this.whenNotMatchedBySourceDeleteSubstraitExpr = Optional.empty();
        return this;
    }

    public MergeInsertParams withNotMatchedBySourceDeleteSubstraitIf(ByteBuffer expr) {
        Preconditions.checkNotNull(expr);
        this.whenNotMatchedBySource = WhenNotMatchedBySource.DeleteIf;
        this.whenNotMatchedBySourceDeleteExpr = Optional.empty();
        this.whenNotMatchedBySourceDeleteSubstraitExpr = Optional.of(expr);
        return this;
    }

    public MergeInsertParams withConflictRetries(int retries) {
        this.conflictRetries = retries;
        return this;
    }

    public MergeInsertParams withRetryTimeoutMs(long timeoutMs) {
        this.retryTimeoutMs = timeoutMs;
        return this;
    }

    public MergeInsertParams withSkipAutoCleanup(boolean skipAutoCleanup) {
        this.skipAutoCleanup = skipAutoCleanup;
        return this;
    }

    public List<String> on() {
        return this.on;
    }

    public WhenMatched whenMatched() {
        return this.whenMatched;
    }

    public String whenMatchedValue() {
        return this.whenMatched.name();
    }

    public Optional<String> whenMatchedUpdateExpr() {
        return this.whenMatchedUpdateExpr;
    }

    public WhenNotMatched whenNotMatched() {
        return this.whenNotMatched;
    }

    public String whenNotMatchedValue() {
        return this.whenNotMatched.name();
    }

    public WhenNotMatchedBySource whenNotMatchedBySource() {
        return this.whenNotMatchedBySource;
    }

    public String whenNotMatchedBySourceValue() {
        return this.whenNotMatchedBySource.name();
    }

    public Optional<String> whenNotMatchedBySourceDeleteExpr() {
        return this.whenNotMatchedBySourceDeleteExpr;
    }

    public Optional<ByteBuffer> whenNotMatchedBySourceDeleteSubstraitExpr() {
        return this.whenNotMatchedBySourceDeleteSubstraitExpr;
    }

    public int conflictRetries() {
        return this.conflictRetries;
    }

    public long retryTimeoutMs() {
        return this.retryTimeoutMs;
    }

    public boolean skipAutoCleanup() {
        return this.skipAutoCleanup;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("on", this.on).add("whenMatched", (Object)this.whenMatched).add("whenMatchedUpdateExpr", this.whenMatchedUpdateExpr.orElse(null)).add("whenNotMatched", (Object)this.whenNotMatched).add("whenNotMatchedBySource", (Object)this.whenNotMatchedBySource).add("whenNotMatchedBySourceDeleteExpr", this.whenNotMatchedBySourceDeleteExpr.orElse(null)).add("whenNotMatchedBySourceDeleteSubstraitExpr", this.whenNotMatchedBySourceDeleteSubstraitExpr.map(buf -> "ByteBuffer[" + buf.remaining() + " bytes]").orElse(null)).add("conflictRetries", this.conflictRetries).add("retryTimeoutMs", this.retryTimeoutMs).add("skipAutoCleanup", this.skipAutoCleanup).toString();
    }

    public static enum WhenNotMatchedBySource {
        Keep,
        Delete,
        DeleteIf;

    }

    public static enum WhenNotMatched {
        InsertAll,
        DoNothing;

    }

    public static enum WhenMatched {
        UpdateAll,
        DoNothing,
        UpdateIf,
        Fail;

    }
}

