/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service.dispatcher;

import java.util.HashMap;
import org.apache.gravitino.Entity;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.credential.CredentialPrivilege;
import org.apache.gravitino.iceberg.common.utils.IcebergIdentifierUtils;
import org.apache.gravitino.iceberg.service.IcebergCatalogWrapperManager;
import org.apache.gravitino.iceberg.service.authorization.IcebergRESTServerContext;
import org.apache.gravitino.iceberg.service.dispatcher.IcebergTableOperationDispatcher;
import org.apache.gravitino.listener.api.event.IcebergRequestContext;
import org.apache.gravitino.server.authorization.MetadataAuthzHelper;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.PlanTableScanRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadCredentialsResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.PlanTableScanResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergTableOperationExecutor
implements IcebergTableOperationDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergTableOperationExecutor.class);
    private IcebergCatalogWrapperManager icebergCatalogWrapperManager;

    public IcebergTableOperationExecutor(IcebergCatalogWrapperManager icebergCatalogWrapperManager) {
        this.icebergCatalogWrapperManager = icebergCatalogWrapperManager;
    }

    @Override
    public LoadTableResponse createTable(IcebergRequestContext context, Namespace namespace, CreateTableRequest createTableRequest) {
        String existingOwner;
        String authenticatedUser = context.userName();
        if (!"anonymous".equals(authenticatedUser) && !authenticatedUser.equals(existingOwner = (String)createTableRequest.properties().get("owner"))) {
            HashMap<String, String> properties = new HashMap<String, String>(createTableRequest.properties());
            properties.put("owner", authenticatedUser);
            LOG.debug("Overriding table owner from '{}' to authenticated user: '{}'", (Object)existingOwner, (Object)authenticatedUser);
            createTableRequest = CreateTableRequest.builder().withName(createTableRequest.name()).withSchema(createTableRequest.schema()).withPartitionSpec(createTableRequest.spec()).withWriteOrder(createTableRequest.writeOrder()).withLocation(createTableRequest.location()).setProperties(properties).build();
        }
        return this.icebergCatalogWrapperManager.getCatalogWrapper(context.catalogName()).createTable(namespace, createTableRequest, context.requestCredentialVending());
    }

    @Override
    public LoadTableResponse updateTable(IcebergRequestContext context, TableIdentifier tableIdentifier, UpdateTableRequest updateTableRequest) {
        return this.icebergCatalogWrapperManager.getCatalogWrapper(context.catalogName()).updateTable(tableIdentifier, updateTableRequest);
    }

    @Override
    public void dropTable(IcebergRequestContext context, TableIdentifier tableIdentifier, boolean purgeRequested) {
        if (purgeRequested) {
            this.icebergCatalogWrapperManager.getCatalogWrapper(context.catalogName()).purgeTable(tableIdentifier);
        } else {
            this.icebergCatalogWrapperManager.getCatalogWrapper(context.catalogName()).dropTable(tableIdentifier);
        }
    }

    @Override
    public LoadTableResponse loadTable(IcebergRequestContext context, TableIdentifier tableIdentifier) {
        CredentialPrivilege privilege = CredentialPrivilege.READ;
        if (context.requestCredentialVending()) {
            privilege = IcebergTableOperationExecutor.getCredentialPrivilege(context, tableIdentifier);
        }
        return this.icebergCatalogWrapperManager.getCatalogWrapper(context.catalogName()).loadTable(tableIdentifier, context.requestCredentialVending(), privilege);
    }

    @Override
    public ListTablesResponse listTable(IcebergRequestContext context, Namespace namespace) {
        return this.icebergCatalogWrapperManager.getCatalogWrapper(context.catalogName()).listTable(namespace);
    }

    @Override
    public boolean tableExists(IcebergRequestContext context, TableIdentifier tableIdentifier) {
        return this.icebergCatalogWrapperManager.getCatalogWrapper(context.catalogName()).tableExists(tableIdentifier);
    }

    @Override
    public void renameTable(IcebergRequestContext context, RenameTableRequest renameTableRequest) {
        this.icebergCatalogWrapperManager.getCatalogWrapper(context.catalogName()).renameTable(renameTableRequest);
    }

    @Override
    public LoadCredentialsResponse getTableCredentials(IcebergRequestContext context, TableIdentifier tableIdentifier) {
        CredentialPrivilege privilege = IcebergTableOperationExecutor.getCredentialPrivilege(context, tableIdentifier);
        return this.icebergCatalogWrapperManager.getCatalogWrapper(context.catalogName()).getTableCredentials(tableIdentifier, privilege);
    }

    private static CredentialPrivilege getCredentialPrivilege(IcebergRequestContext context, TableIdentifier tableIdentifier) {
        String metalake = IcebergRESTServerContext.getInstance().metalakeName();
        NameIdentifier identifier = IcebergIdentifierUtils.toGravitinoTableIdentifier((String)metalake, (String)context.catalogName(), (TableIdentifier)tableIdentifier);
        boolean writable = MetadataAuthzHelper.checkAccess((NameIdentifier)identifier, (Entity.EntityType)Entity.EntityType.TABLE, (String)"ANY(OWNER, METALAKE, CATALOG, SCHEMA, TABLE) ||\nANY_MODIFY_TABLE\n");
        return writable ? CredentialPrivilege.WRITE : CredentialPrivilege.READ;
    }

    @Override
    public PlanTableScanResponse planTableScan(IcebergRequestContext context, TableIdentifier tableIdentifier, PlanTableScanRequest scanRequest) {
        return this.icebergCatalogWrapperManager.getCatalogWrapper(context.catalogName()).planTableScan(tableIdentifier, scanRequest);
    }
}

