/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.launcher;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public final class TwillLauncher {
    private static final int TEMP_DIR_ATTEMPTS = 20;

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            System.out.println("Usage: java " + TwillLauncher.class.getName() + " [jarFile] [mainClass] [use_classpath]");
            return;
        }
        File file = new File(args[0]);
        final File targetDir = TwillLauncher.createTempDir("twill.launcher");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.out.println("Cleanup directory " + targetDir);
                TwillLauncher.deleteDir(targetDir);
            }
        });
        System.out.println("UnJar " + file + " to " + targetDir);
        TwillLauncher.unJar(file, targetDir);
        URLClassLoader classLoader = TwillLauncher.createClassLoader(targetDir, Boolean.parseBoolean(args[2]));
        Thread.currentThread().setContextClassLoader(classLoader);
        System.out.println("Launch class (" + args[1] + ") with classpath: " + Arrays.toString(classLoader.getURLs()));
        Class<?> mainClass = classLoader.loadClass(args[1]);
        Method mainMethod = mainClass.getMethod("main", String[].class);
        Object[] arguments = Arrays.copyOfRange(args, 3, args.length);
        System.out.println("Launching main: " + mainMethod + " " + Arrays.toString(arguments));
        mainMethod.invoke(mainClass, new Object[]{arguments});
        System.out.println("Main class completed.");
        System.out.println("Launcher completed");
    }

    private static File createTempDir(String prefix) throws IOException {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        if (!baseDir.isDirectory() && !baseDir.mkdirs()) {
            throw new IOException("Tmp directory not exists: " + baseDir.getAbsolutePath());
        }
        String baseName = prefix + "-" + System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 20; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IOException("Failed to create directory within 20 attempts (tried " + baseName + "0 to " + baseName + 19 + ')');
    }

    private static void unJar(File jarFile, File targetDir) throws IOException {
        try (JarInputStream jarInput = new JarInputStream(new FileInputStream(jarFile));){
            JarEntry jarEntry = jarInput.getNextJarEntry();
            while (jarEntry != null) {
                File target = new File(targetDir, jarEntry.getName());
                if (jarEntry.isDirectory()) {
                    target.mkdirs();
                } else {
                    target.getParentFile().mkdirs();
                    TwillLauncher.copy(jarInput, target);
                }
                jarEntry = jarInput.getNextJarEntry();
            }
        }
    }

    private static void copy(InputStream is, File file) throws IOException {
        byte[] buf = new byte[8192];
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
            int len = is.read(buf);
            while (len != -1) {
                ((OutputStream)os).write(buf, 0, len);
                len = is.read(buf);
            }
        }
    }

    private static URLClassLoader createClassLoader(File dir, boolean useClassPath) {
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            urls.add(dir.toURI().toURL());
            urls.add(new File(dir, "classes").toURI().toURL());
            urls.add(new File(dir, "resources").toURI().toURL());
            File libDir = new File(dir, "lib");
            File[] files = libDir.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.getName().endsWith(".jar")) continue;
                    urls.add(file.toURI().toURL());
                }
            }
            if (useClassPath) {
                TwillLauncher.addClassPathsToList(urls, "classpath");
            }
            TwillLauncher.addClassPathsToList(urls, "application-classpath");
            return new URLClassLoader(urls.toArray(new URL[0]));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static void addClassPathsToList(List<URL> urls, String resource) throws IOException {
        block26: {
            try (InputStream is = ClassLoader.getSystemResourceAsStream(resource);){
                if (is == null) break block26;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));){
                    String line = reader.readLine();
                    if (line != null) {
                        for (String path : line.split(":")) {
                            urls.addAll(TwillLauncher.getClassPaths(path.trim()));
                        }
                    }
                }
            }
        }
    }

    private static Collection<URL> getClassPaths(String path) throws MalformedURLException {
        String classpath = TwillLauncher.expand(path);
        if (classpath.endsWith("/*")) {
            File dir = new File(classpath.substring(0, classpath.length() - 2));
            File[] files = dir.listFiles();
            if (files == null || files.length == 0) {
                return TwillLauncher.singleItem(dir.toURI().toURL());
            }
            ArrayList<URL> result = new ArrayList<URL>(files.length);
            for (File file : files) {
                if (!file.getName().endsWith(".jar")) continue;
                result.add(file.toURI().toURL());
            }
            return result;
        }
        return TwillLauncher.singleItem(new File(classpath).toURI().toURL());
    }

    private static Collection<URL> singleItem(URL url) {
        ArrayList<URL> result = new ArrayList<URL>(1);
        result.add(url);
        return result;
    }

    private static String expand(String value) {
        String result = value;
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            result = result.replace("$" + entry.getKey(), entry.getValue());
            result = result.replace("${" + entry.getKey() + "}", entry.getValue());
        }
        return result;
    }

    private static void deleteDir(File dir) {
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            dir.delete();
            return;
        }
        for (File file : files) {
            TwillLauncher.deleteDir(file);
        }
        dir.delete();
    }
}

