/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.CommandHandler;
import org.apache.gravitino.cli.FullName;
import org.apache.gravitino.cli.GravitinoCommandLine;
import org.apache.gravitino.cli.Main;
import org.apache.gravitino.cli.commands.Command;

public class UserCommandHandler
extends CommandHandler {
    private final GravitinoCommandLine gravitinoCommandLine;
    private final CommandLine line;
    private final String command;
    private final CommandContext context;
    private final FullName name;
    private final String metalake;
    private String user;

    public UserCommandHandler(GravitinoCommandLine gravitinoCommandLine, CommandLine line, String command, CommandContext context) {
        this.gravitinoCommandLine = gravitinoCommandLine;
        this.line = line;
        this.command = command;
        this.context = context;
        this.name = new FullName(line);
        this.metalake = this.name.getMetalakeName();
    }

    @Override
    protected void handle() {
        String userName = this.line.getOptionValue("login");
        Command.setAuthenticationMode(this.context.auth(), userName);
        this.user = this.line.getOptionValue("user");
        if (this.user == null && !"list".equals(this.command)) {
            System.err.println("Missing --user option.");
            Main.exit(-1);
        }
        if (!this.executeCommand()) {
            System.err.println("Unsupported or unknown command.");
            Main.exit(-1);
        }
    }

    private boolean executeCommand() {
        switch (this.command) {
            case "details": {
                this.handleDetailsCommand();
                return true;
            }
            case "list": {
                this.handleListCommand();
                return true;
            }
            case "create": {
                this.handleCreateCommand();
                return true;
            }
            case "delete": {
                this.handleDeleteCommand();
                return true;
            }
            case "revoke": {
                this.handleRevokeCommand();
                return true;
            }
            case "grant": {
                this.handleGrantCommand();
                return true;
            }
        }
        return false;
    }

    private void handleListCommand() {
        this.gravitinoCommandLine.newListUsers(this.context, this.metalake).validate().handle();
    }

    private void handleDetailsCommand() {
        if (this.line.hasOption("audit")) {
            this.gravitinoCommandLine.newUserAudit(this.context, this.metalake, this.user).validate().handle();
        } else {
            this.gravitinoCommandLine.newUserDetails(this.context, this.metalake, this.user).validate().handle();
        }
    }

    private void handleCreateCommand() {
        this.gravitinoCommandLine.newCreateUser(this.context, this.metalake, this.user).validate().handle();
    }

    private void handleDeleteCommand() {
        this.gravitinoCommandLine.newDeleteUser(this.context, this.metalake, this.user).validate().handle();
    }

    private void handleRevokeCommand() {
        boolean removeAll = this.line.hasOption("all");
        if (removeAll) {
            this.gravitinoCommandLine.newRemoveAllRoles(this.context, this.metalake, this.user, "user").validate().handle();
            System.out.printf("Removed all roles from user %s%n", this.user);
        } else {
            Object[] revokeRoles;
            for (String string : revokeRoles = this.line.getOptionValues("role")) {
                this.gravitinoCommandLine.newRemoveRoleFromUser(this.context, this.metalake, this.user, string).validate().handle();
            }
            System.out.printf("Removed roles %s from user %s%n", COMMA_JOINER.join(revokeRoles), this.user);
        }
    }

    private void handleGrantCommand() {
        Object[] grantRoles;
        for (String string : grantRoles = this.line.getOptionValues("role")) {
            this.gravitinoCommandLine.newAddRoleToUser(this.context, this.metalake, this.user, string).validate().handle();
        }
        System.out.printf("Add roles %s to user %s%n", COMMA_JOINER.join(grantRoles), this.user);
    }
}

