/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.base;

import org.apache.gravitino.storage.relational.po.TablePO;
import org.apache.ibatis.annotations.Param;

public class TableVersionBaseSQLProvider {
    public String insertTableVersion(@Param(value="tablePO") TablePO tablePO) {
        return "INSERT INTO table_version_info (table_id, format, properties, partitioning, distribution, sort_orders, indexes, comment, version, deleted_at) VALUES ( #{tablePO.tableId}, #{tablePO.format}, #{tablePO.properties}, #{tablePO.partitions}, #{tablePO.distribution}, #{tablePO.sortOrders}, #{tablePO.indexes}, #{tablePO.comment}, #{tablePO.currentVersion}, #{tablePO.deletedAt} )";
    }

    public String insertTableVersionOnDuplicateKeyUpdate(@Param(value="tablePO") TablePO tablePO) {
        return "INSERT INTO table_version_info (table_id, format, properties, partitioning, distribution, sort_orders, indexes, comment, version, deleted_at) VALUES ( #{tablePO.tableId}, #{tablePO.format}, #{tablePO.properties}, #{tablePO.partitions}, #{tablePO.distribution}, #{tablePO.sortOrders}, #{tablePO.indexes}, #{tablePO.comment}, #{tablePO.currentVersion}, #{tablePO.deletedAt} ) ON DUPLICATE KEY UPDATE format = #{tablePO.format}, properties = #{tablePO.properties}, partitioning = #{tablePO.partitions}, distribution = #{tablePO.distribution}, sort_orders = #{tablePO.sortOrders}, indexes = #{tablePO.indexes}, comment = #{tablePO.comment}, version = #{tablePO.currentVersion}, deleted_at = #{tablePO.deletedAt}";
    }

    public String softDeleteTableVersionByTableIdAndVersion(@Param(value="tableId") Long tableId, @Param(value="version") Long version) {
        return "UPDATE table_version_info SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE table_id = #{tableId} AND version = #{version} AND deleted_at = 0";
    }

    public String deleteTableVersionByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM table_version_info WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit}";
    }
}

