/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.safe.SafeBinaryRow;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.data.serializer.InternalSerializers;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.manifest.FileSource;
import org.apache.paimon.stats.SimpleStats;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.utils.InternalRowUtils;
import org.apache.paimon.utils.SerializationUtils;

public class DataFileMeta10LegacySerializer
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final RowType SCHEMA = new RowType(false, Arrays.asList(new DataField(0, "_FILE_NAME", (DataType)SerializationUtils.newStringType(false)), new DataField(1, "_FILE_SIZE", (DataType)new BigIntType(false)), new DataField(2, "_ROW_COUNT", (DataType)new BigIntType(false)), new DataField(3, "_MIN_KEY", (DataType)SerializationUtils.newBytesType(false)), new DataField(4, "_MAX_KEY", (DataType)SerializationUtils.newBytesType(false)), new DataField(5, "_KEY_STATS", (DataType)SimpleStats.SCHEMA), new DataField(6, "_VALUE_STATS", (DataType)SimpleStats.SCHEMA), new DataField(7, "_MIN_SEQUENCE_NUMBER", (DataType)new BigIntType(false)), new DataField(8, "_MAX_SEQUENCE_NUMBER", (DataType)new BigIntType(false)), new DataField(9, "_SCHEMA_ID", (DataType)new BigIntType(false)), new DataField(10, "_LEVEL", (DataType)new IntType(false)), new DataField(11, "_EXTRA_FILES", (DataType)new ArrayType(false, (DataType)SerializationUtils.newStringType(false))), new DataField(12, "_CREATION_TIME", (DataType)DataTypes.TIMESTAMP_MILLIS()), new DataField(13, "_DELETE_ROW_COUNT", (DataType)new BigIntType(true)), new DataField(14, "_EMBEDDED_FILE_INDEX", (DataType)SerializationUtils.newBytesType(true)), new DataField(15, "_FILE_SOURCE", (DataType)new TinyIntType(true)), new DataField(16, "_VALUE_STATS_COLS", (DataType)DataTypes.ARRAY((DataType)DataTypes.STRING().notNull()))));
    protected final InternalRowSerializer rowSerializer = InternalSerializers.create((RowType)SCHEMA);

    public final void serializeList(List<DataFileMeta> records, DataOutputView target) throws IOException {
        target.writeInt(records.size());
        for (DataFileMeta t : records) {
            this.serialize(t, target);
        }
    }

    public void serialize(DataFileMeta meta, DataOutputView target) throws IOException {
        GenericRow row = GenericRow.of((Object[])new Object[]{BinaryString.fromString((String)meta.fileName()), meta.fileSize(), meta.rowCount(), SerializationUtils.serializeBinaryRow(meta.minKey()), SerializationUtils.serializeBinaryRow(meta.maxKey()), meta.keyStats().toRow(), meta.valueStats().toRow(), meta.minSequenceNumber(), meta.maxSequenceNumber(), meta.schemaId(), meta.level(), InternalRowUtils.toStringArrayData(meta.extraFiles()), meta.creationTime(), meta.deleteRowCount().orElse(null), meta.embeddedIndex(), meta.fileSource().map(FileSource::toByteValue).orElse(null), InternalRowUtils.toStringArrayData(meta.valueStatsCols())});
        this.rowSerializer.serialize((InternalRow)row, target);
    }

    public final List<DataFileMeta> deserializeList(DataInputView source) throws IOException {
        int size = source.readInt();
        ArrayList<DataFileMeta> records = new ArrayList<DataFileMeta>(size);
        for (int i = 0; i < size; ++i) {
            records.add(this.deserialize(source));
        }
        return records;
    }

    public DataFileMeta deserialize(DataInputView in) throws IOException {
        byte[] bytes = new byte[in.readInt()];
        in.readFully(bytes);
        SafeBinaryRow row = new SafeBinaryRow(this.rowSerializer.getArity(), bytes, 0);
        return new DataFileMeta(row.getString(0).toString(), row.getLong(1), row.getLong(2), SerializationUtils.deserializeBinaryRow(row.getBinary(3)), SerializationUtils.deserializeBinaryRow(row.getBinary(4)), SimpleStats.fromRow(row.getRow(5, 3)), SimpleStats.fromRow(row.getRow(6, 3)), row.getLong(7), row.getLong(8), row.getLong(9), row.getInt(10), InternalRowUtils.fromStringArrayData((InternalArray)row.getArray(11)), row.getTimestamp(12, 3), row.isNullAt(13) ? null : Long.valueOf(row.getLong(13)), row.isNullAt(14) ? null : row.getBinary(14), row.isNullAt(15) ? null : FileSource.fromByteValue(row.getByte(15)), row.isNullAt(16) ? null : InternalRowUtils.fromStringArrayData((InternalArray)row.getArray(16)), null);
    }
}

